/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.RoiEvent;
import events.RoiListener;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.Roi;
import java.util.ArrayList;

public class RoiWatcher {
    public static final String MONITOR_LOC = "RoiWatcher.monitor";
    public static final long POLL_TIME = 10L;
    final ImagePlus data;

    public RoiWatcher(ImagePlus data) {
        this.data = data;
        if (data.getProperty(MONITOR_LOC) == null) {
            data.setProperty(MONITOR_LOC, (Object)new RoiMonitor(data));
        }
    }

    private RoiMonitor getMonitor() {
        return (RoiMonitor)this.data.getProperty(MONITOR_LOC);
    }

    public void addRoiListener(RoiListener l) {
        this.getMonitor().addRoiListener(l);
    }

    public boolean removeRoiListener(RoiListener l) {
        return this.getMonitor().removeRoiListener(l);
    }

    private static class RoiMonitor
    implements Runnable,
    ImageListener {
        final ImagePlus ip;
        final ArrayList<RoiListener> listeners = new ArrayList();
        Roi oldRoi;
        boolean run = true;
        Thread thread;

        public RoiMonitor(ImagePlus ip) {
            this.ip = ip;
            ImagePlus.addImageListener((ImageListener)this);
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void fireRoiChange(RoiEvent e) {
            System.out.println("roi change from " + this);
            for (RoiListener l : this.listeners) {
                try {
                    l.roiChanged(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void addRoiListener(RoiListener l) {
            this.listeners.add(l);
        }

        public boolean removeRoiListener(RoiListener l) {
            return this.listeners.remove(l);
        }

        public void imageOpened(ImagePlus arg0) {
        }

        public void imageClosed(ImagePlus image) {
            if (image == this.ip) {
                image.getProperties().remove(RoiWatcher.MONITOR_LOC);
                this.listeners.clear();
                ImagePlus.removeImageListener((ImageListener)this);
            }
        }

        public void imageUpdated(ImagePlus image) {
            if (image == this.ip) {
                System.out.println("Image update, loading new ROI");
                this.oldRoi = this.ip.getRoi();
            }
        }

        @Override
        public void run() {
            while (this.run) {
                Roi newRoi;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if ((newRoi = this.ip.getRoi()) == null && newRoi == null || (newRoi != null || newRoi == null) && newRoi.equals((Object)this.oldRoi)) continue;
                System.out.println("newRoi = " + newRoi);
                System.out.println("oldRoi = " + this.oldRoi);
                this.fireRoiChange(new RoiEvent(this.ip));
                this.oldRoi = newRoi;
            }
        }
    }
}

