/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.ImagePlus;
import ij.io.FileInfo;
import java.io.File;

public class FileAndChannel {
    private String filePath;
    private File fileObject;
    private int channelZeroIndexed;
    private String channelString;

    public FileAndChannel(String filePath, int channelZeroIndexed) {
        this.filePath = filePath;
        this.channelZeroIndexed = channelZeroIndexed;
        this.channelString = "Channel : Ch" + (channelZeroIndexed + 1);
        this.fileObject = new File(this.filePath);
    }

    public boolean exists() {
        return this.fileObject.exists();
    }

    public boolean correctFileName(ImagePlus i) {
        FileInfo info = i.getOriginalFileInfo();
        String id = info.directory;
        if (id.lastIndexOf(File.separatorChar) == id.length() - 1) {
            id = id.substring(0, id.length() - 1);
        }
        boolean matches = id.equals(this.fileObject.getParent()) && info.fileName.equals(this.fileObject.getName());
        return matches;
    }

    public boolean correctChannel(ImagePlus i) {
        boolean matches = -1 != i.getTitle().indexOf(this.channelString);
        return matches;
    }

    public int getChannelZeroIndexed() {
        return this.channelZeroIndexed;
    }

    public String getPath() {
        return this.filePath;
    }
}

