/*
 * Decompiled with CFR 0.152.
 */
package vib.edge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import vib.edge.DistanceComparator;
import vib.edge.PointComparator;

public class CircleIterators {
    public static int[][] FullCircle(double radius) {
        return CircleIterators.FullCircle(radius, true);
    }

    public static int[][] FullCircle(double radius, boolean withOrigin) {
        int[] x;
        int j;
        int quarter;
        int i;
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (i = (int)radius; i >= 0; --i) {
            quarter = (int)Math.sqrt(radius * radius - (double)(i * i));
            for (j = -quarter; j <= quarter; ++j) {
                if (!withOrigin && i == 0 && j == 0) continue;
                x = new int[]{j, i};
                list.add(x);
            }
        }
        for (i = 1; i <= (int)radius; ++i) {
            quarter = (int)Math.sqrt(radius * radius - (double)(i * i));
            j = -quarter;
            while (j <= quarter) {
                x = new int[]{j++, -i};
                list.add(x);
            }
        }
        int count = list.size();
        int[][] result = new int[count][2];
        for (int i2 = 0; i2 < count; ++i2) {
            result[i2] = (int[])list.get(count - 1 - i2);
        }
        return result;
    }

    public static int[][] FullCircleSortedByDistance(double radius, boolean ascending) {
        int[][] result = CircleIterators.FullCircle(radius, true);
        DistanceComparator compare = new DistanceComparator(ascending);
        Arrays.sort(result, compare);
        return result;
    }

    public static int[][] SortedHalfCircle(double radius) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i = (int)radius; i >= 0; --i) {
            int j;
            int quarter = (int)Math.sqrt(radius * radius - (double)(i * i));
            int n = j = i > 0 ? -quarter : 1;
            while (j <= quarter) {
                int[] x = new int[]{j++, i};
                list.add(x);
            }
        }
        Collections.sort(list, new PointComparator());
        int count = list.size();
        int[][] result = new int[count][2];
        for (int i = 0; i < count; ++i) {
            result[i] = (int[])list.get(count - 1 - i);
        }
        return result;
    }

    public static int[][][] Edgelets(int[][] shc, double radius) {
        int[][][] result = new int[shc.length][][];
        ArrayList<int[]> plist = new ArrayList<int[]>();
        for (int k = 0; k < shc.length; ++k) {
            int i;
            int oldx;
            double dist = Math.sqrt(shc[k][0] * shc[k][0] + shc[k][1] * shc[k][1]);
            double dx = (double)shc[k][0] / dist;
            double dy = (double)shc[k][1] / dist;
            int oldy = oldx = -2 * (int)radius;
            boolean npoints = false;
            int[] x = new int[2];
            for (i = -((int)radius); i <= (int)radius; ++i) {
                x[0] = (int)(dx * (double)i);
                x[1] = (int)(dy * (double)i);
                if (x[0] == oldx && x[1] == oldy) continue;
                oldx = x[0];
                oldy = x[1];
                plist.add(x);
                x = new int[2];
            }
            result[k] = new int[plist.size()][2];
            for (i = 0; i < plist.size(); ++i) {
                result[k][i] = (int[])plist.get(i);
            }
            plist.clear();
        }
        return result;
    }

    public static int[][] RightSickle(double radius) {
        int halfCount = (int)radius;
        int[][] result = new int[2 * halfCount + 1][2];
        for (int i = halfCount; i >= -halfCount; --i) {
            result[i + halfCount][0] = (int)Math.sqrt(radius * radius - (double)(i * i));
            result[i + halfCount][1] = i;
        }
        return result;
    }

    public static void main(String[] args) {
        int i;
        int[][] list = CircleIterators.SortedHalfCircle(5.0);
        int[][] pixels = new int[11][11];
        for (i = 0; i < list.length; ++i) {
            System.out.print("(" + list[i][0] + "," + list[i][1] + ") ");
            pixels[5 + list[i][0]][5 + list[i][1]] = i + 1;
        }
        System.out.println("");
        for (i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                System.out.print((char)(64 + pixels[5 + j][5 + i]));
            }
            System.out.println("");
        }
        int[][] slist = CircleIterators.SortedHalfCircle(5.0);
        int[][][] slines = CircleIterators.Edgelets(slist, 5.0);
        for (int i2 = 0; i2 < slist.length; ++i2) {
            System.out.println("Point (" + slist[i2][0] + "," + slist[i2][1] + ")");
            for (int j = 0; j < slines[i2].length; ++j) {
                System.out.print("(" + slines[i2][j][0] + "," + slines[i2][j][1] + ")");
            }
            System.out.println();
        }
    }
}

