/*
 * Decompiled with CFR 0.152.
 */
package bdv;

import bdv.KeyConfigScopes;
import bdv.TransformEventHandler;
import bdv.TransformState;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.ScrollBehaviour;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Behaviours;

public class TransformEventHandler2D
implements TransformEventHandler {
    public static final String DRAG_TRANSLATE = "2d drag translate";
    public static final String DRAG_ROTATE = "2d drag rotate";
    public static final String ZOOM_NORMAL = "2d scroll zoom";
    public static final String SCROLL_TRANSLATE = "2d scroll translate";
    public static final String SCROLL_ROTATE = "2d scroll rotate";
    public static final String ROTATE_LEFT = "2d rotate left";
    public static final String ROTATE_RIGHT = "2d rotate right";
    public static final String KEY_ZOOM_IN = "2d zoom in";
    public static final String KEY_ZOOM_OUT = "2d zoom out";
    public static final String ZOOM_FAST = "2d scroll zoom fast";
    public static final String SCROLL_TRANSLATE_FAST = "2d scroll translate fast";
    public static final String SCROLL_ROTATE_FAST = "2d scroll rotate fast";
    public static final String ROTATE_LEFT_FAST = "2d rotate left fast";
    public static final String ROTATE_RIGHT_FAST = "2d rotate right fast";
    public static final String KEY_ZOOM_IN_FAST = "2d zoom in fast";
    public static final String KEY_ZOOM_OUT_FAST = "2d zoom out fast";
    public static final String ZOOM_SLOW = "2d scroll zoom slow";
    public static final String SCROLL_TRANSLATE_SLOW = "2d scroll translate slow";
    public static final String SCROLL_ROTATE_SLOW = "2d scroll rotate slow";
    public static final String ROTATE_LEFT_SLOW = "2d rotate left slow";
    public static final String ROTATE_RIGHT_SLOW = "2d rotate right slow";
    public static final String KEY_ZOOM_IN_SLOW = "2d zoom in slow";
    public static final String KEY_ZOOM_OUT_SLOW = "2d zoom out slow";
    public static final String[] DRAG_TRANSLATE_KEYS = new String[]{"button2", "button3"};
    public static final String[] DRAG_ROTATE_KEYS = new String[]{"button1"};
    public static final String[] ZOOM_NORMAL_KEYS = new String[]{"scroll", "meta scroll", "ctrl shift scroll"};
    public static final String[] SCROLL_TRANSLATE_KEYS = new String[]{"not mapped"};
    public static final String[] SCROLL_ROTATE_KEYS = new String[]{"not mapped"};
    public static final String[] ROTATE_LEFT_KEYS = new String[]{"LEFT"};
    public static final String[] ROTATE_RIGHT_KEYS = new String[]{"RIGHT"};
    public static final String[] KEY_ZOOM_IN_KEYS = new String[]{"UP"};
    public static final String[] KEY_ZOOM_OUT_KEYS = new String[]{"DOWN"};
    public static final String[] ZOOM_FAST_KEYS = new String[]{"shift scroll"};
    public static final String[] SCROLL_TRANSLATE_FAST_KEYS = new String[]{"not mapped"};
    public static final String[] SCROLL_ROTATE_FAST_KEYS = new String[]{"not mapped"};
    public static final String[] ROTATE_LEFT_FAST_KEYS = new String[]{"shift LEFT"};
    public static final String[] ROTATE_RIGHT_FAST_KEYS = new String[]{"shift RIGHT"};
    public static final String[] KEY_ZOOM_IN_FAST_KEYS = new String[]{"shift UP"};
    public static final String[] KEY_ZOOM_OUT_FAST_KEYS = new String[]{"shift DOWN"};
    public static final String[] ZOOM_SLOW_KEYS = new String[]{"ctrl scroll"};
    public static final String[] SCROLL_TRANSLATE_SLOW_KEYS = new String[]{"not mapped"};
    public static final String[] SCROLL_ROTATE_SLOW_KEYS = new String[]{"not mapped"};
    public static final String[] ROTATE_LEFT_SLOW_KEYS = new String[]{"ctrl LEFT"};
    public static final String[] ROTATE_RIGHT_SLOW_KEYS = new String[]{"ctrl RIGHT"};
    public static final String[] KEY_ZOOM_IN_SLOW_KEYS = new String[]{"ctrl UP"};
    public static final String[] KEY_ZOOM_OUT_SLOW_KEYS = new String[]{"ctrl DOWN"};
    private final DragTranslate dragTranslate;
    private final DragRotate dragRotate;
    private final Zoom zoom;
    private final Zoom zoomFast;
    private final Zoom zoomSlow;
    private final ScrollTranslate scrollTranslate;
    private final ScrollTranslate scrollTranslateFast;
    private final ScrollTranslate scrollTranslateSlow;
    private final ScrollRotate scrollRotate;
    private final ScrollRotate scrollRotateFast;
    private final ScrollRotate scrollRotateSlow;
    private final KeyRotate keyRotateLeft;
    private final KeyRotate keyRotateLeftFast;
    private final KeyRotate keyRotateLeftSlow;
    private final KeyRotate keyRotateRight;
    private final KeyRotate keyRotateRightFast;
    private final KeyRotate keyRotateRightSlow;
    private final KeyZoom keyZoomIn;
    private final KeyZoom keyZoomInFast;
    private final KeyZoom keyZoomInSlow;
    private final KeyZoom keyZoomOut;
    private final KeyZoom keyZoomOutFast;
    private final KeyZoom keyZoomOutSlow;
    private static final double[] speed = new double[]{1.0, 10.0, 0.1};
    private final AffineTransform3D affineDragStart = new AffineTransform3D();
    private final AffineTransform3D affineDragCurrent = new AffineTransform3D();
    private double oX;
    private double oY;
    private int canvasW = 1;
    private int canvasH = 1;
    private int centerX = 0;
    private int centerY = 0;
    private final TransformState transform;
    private static final double step = Math.PI / 180;

    public TransformEventHandler2D(TransformState transform) {
        this.transform = transform;
        this.dragTranslate = new DragTranslate();
        this.dragRotate = new DragRotate();
        this.scrollTranslate = new ScrollTranslate(speed[0]);
        this.scrollTranslateFast = new ScrollTranslate(speed[1]);
        this.scrollTranslateSlow = new ScrollTranslate(speed[2]);
        this.zoom = new Zoom(speed[0]);
        this.zoomFast = new Zoom(speed[1]);
        this.zoomSlow = new Zoom(speed[2]);
        this.scrollRotate = new ScrollRotate(2.0 * speed[0]);
        this.scrollRotateFast = new ScrollRotate(2.0 * speed[1]);
        this.scrollRotateSlow = new ScrollRotate(2.0 * speed[2]);
        this.keyRotateLeft = new KeyRotate(speed[0]);
        this.keyRotateLeftFast = new KeyRotate(speed[1]);
        this.keyRotateLeftSlow = new KeyRotate(speed[2]);
        this.keyRotateRight = new KeyRotate(-speed[0]);
        this.keyRotateRightFast = new KeyRotate(-speed[1]);
        this.keyRotateRightSlow = new KeyRotate(-speed[2]);
        this.keyZoomIn = new KeyZoom(speed[0]);
        this.keyZoomInFast = new KeyZoom(speed[1]);
        this.keyZoomInSlow = new KeyZoom(speed[2]);
        this.keyZoomOut = new KeyZoom(-speed[0]);
        this.keyZoomOutFast = new KeyZoom(-speed[1]);
        this.keyZoomOutSlow = new KeyZoom(-speed[2]);
    }

    @Override
    public void install(Behaviours behaviours) {
        behaviours.behaviour((Behaviour)this.dragTranslate, DRAG_TRANSLATE, DRAG_TRANSLATE_KEYS);
        behaviours.behaviour((Behaviour)this.dragRotate, DRAG_ROTATE, DRAG_ROTATE_KEYS);
        behaviours.behaviour((Behaviour)this.scrollTranslate, SCROLL_TRANSLATE, SCROLL_TRANSLATE_KEYS);
        behaviours.behaviour((Behaviour)this.scrollTranslateFast, SCROLL_TRANSLATE_FAST, SCROLL_TRANSLATE_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.scrollTranslateSlow, SCROLL_TRANSLATE_SLOW, SCROLL_TRANSLATE_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.zoom, ZOOM_NORMAL, ZOOM_NORMAL_KEYS);
        behaviours.behaviour((Behaviour)this.zoomFast, ZOOM_FAST, ZOOM_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.zoomSlow, ZOOM_SLOW, ZOOM_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.scrollRotate, SCROLL_ROTATE, SCROLL_ROTATE_KEYS);
        behaviours.behaviour((Behaviour)this.scrollRotateFast, SCROLL_ROTATE_FAST, SCROLL_ROTATE_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.scrollRotateSlow, SCROLL_ROTATE_SLOW, SCROLL_ROTATE_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyRotateLeft, ROTATE_LEFT, ROTATE_LEFT_KEYS);
        behaviours.behaviour((Behaviour)this.keyRotateLeftFast, ROTATE_LEFT_FAST, ROTATE_LEFT_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyRotateLeftSlow, ROTATE_LEFT_SLOW, ROTATE_LEFT_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyRotateRight, ROTATE_RIGHT, ROTATE_RIGHT_KEYS);
        behaviours.behaviour((Behaviour)this.keyRotateRightFast, ROTATE_RIGHT_FAST, ROTATE_RIGHT_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyRotateRightSlow, ROTATE_RIGHT_SLOW, ROTATE_RIGHT_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomIn, KEY_ZOOM_IN, KEY_ZOOM_IN_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomInFast, KEY_ZOOM_IN_FAST, KEY_ZOOM_IN_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomInSlow, KEY_ZOOM_IN_SLOW, KEY_ZOOM_IN_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomOut, KEY_ZOOM_OUT, KEY_ZOOM_OUT_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomOutFast, KEY_ZOOM_OUT_FAST, KEY_ZOOM_OUT_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomOutSlow, KEY_ZOOM_OUT_SLOW, KEY_ZOOM_OUT_SLOW_KEYS);
    }

    @Override
    public void setCanvasSize(int width, int height, boolean updateTransform) {
        if (width == 0 || height == 0) {
            return;
        }
        if (updateTransform) {
            AffineTransform3D affine = this.transform.get();
            affine.set(affine.get(0, 3) - (double)(this.canvasW / 2), 0, 3);
            affine.set(affine.get(1, 3) - (double)(this.canvasH / 2), 1, 3);
            affine.scale((double)width / (double)this.canvasW);
            affine.set(affine.get(0, 3) + (double)(width / 2), 0, 3);
            affine.set(affine.get(1, 3) + (double)(height / 2), 1, 3);
            this.transform.set(affine);
        }
        this.canvasW = width;
        this.canvasH = height;
        this.centerX = width / 2;
        this.centerY = height / 2;
    }

    private void scale(double s, double x, double y) {
        AffineTransform3D affine = this.transform.get();
        affine.set(affine.get(0, 3) - x, 0, 3);
        affine.set(affine.get(1, 3) - y, 1, 3);
        affine.scale(s);
        affine.set(affine.get(0, 3) + x, 0, 3);
        affine.set(affine.get(1, 3) + y, 1, 3);
        this.transform.set(affine);
    }

    private void rotate(AffineTransform3D affine, double d) {
        affine.set(affine.get(0, 3) - (double)this.centerX, 0, 3);
        affine.set(affine.get(1, 3) - (double)this.centerY, 1, 3);
        affine.rotate(2, d);
        affine.set(affine.get(0, 3) + (double)this.centerX, 0, 3);
        affine.set(affine.get(1, 3) + (double)this.centerY, 1, 3);
    }

    private class KeyZoom
    implements ClickBehaviour {
        private final double dScale;

        public KeyZoom(double speed) {
            this.dScale = speed > 0.0 ? 1.0 + 0.1 * speed : 1.0 / (1.0 - 0.1 * speed);
        }

        public void click(int x, int y) {
            TransformEventHandler2D.this.scale(this.dScale, TransformEventHandler2D.this.centerX, TransformEventHandler2D.this.centerY);
        }
    }

    private class KeyRotate
    implements ClickBehaviour {
        private final double speed;

        public KeyRotate(double speed) {
            this.speed = speed;
        }

        public void click(int x, int y) {
            AffineTransform3D affine = TransformEventHandler2D.this.transform.get();
            TransformEventHandler2D.this.rotate(affine, Math.PI / 180 * this.speed);
            TransformEventHandler2D.this.transform.set(affine);
        }
    }

    private class Zoom
    implements ScrollBehaviour {
        private final double speed;

        public Zoom(double speed) {
            this.speed = speed;
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            double s = this.speed * wheelRotation;
            double dScale = 1.0 + 0.05 * Math.abs(s);
            if (s > 0.0) {
                TransformEventHandler2D.this.scale(1.0 / dScale, x, y);
            } else {
                TransformEventHandler2D.this.scale(dScale, x, y);
            }
        }
    }

    private class ScrollTranslate
    implements ScrollBehaviour {
        private final double speed;

        public ScrollTranslate(double speed) {
            this.speed = speed;
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            AffineTransform3D affine = TransformEventHandler2D.this.transform.get();
            double d = -wheelRotation * 10.0 * this.speed;
            if (isHorizontal) {
                affine.translate(new double[]{d, 0.0, 0.0});
            } else {
                affine.translate(new double[]{0.0, d, 0.0});
            }
            TransformEventHandler2D.this.transform.set(affine);
        }
    }

    private class DragTranslate
    implements DragBehaviour {
        private DragTranslate() {
        }

        public void init(int x, int y) {
            TransformEventHandler2D.this.oX = x;
            TransformEventHandler2D.this.oY = y;
            TransformEventHandler2D.this.transform.get(TransformEventHandler2D.this.affineDragStart);
        }

        public void drag(int x, int y) {
            double dX = TransformEventHandler2D.this.oX - (double)x;
            double dY = TransformEventHandler2D.this.oY - (double)y;
            TransformEventHandler2D.this.affineDragCurrent.set(TransformEventHandler2D.this.affineDragStart);
            TransformEventHandler2D.this.affineDragCurrent.set(TransformEventHandler2D.this.affineDragCurrent.get(0, 3) - dX, 0, 3);
            TransformEventHandler2D.this.affineDragCurrent.set(TransformEventHandler2D.this.affineDragCurrent.get(1, 3) - dY, 1, 3);
            TransformEventHandler2D.this.transform.set(TransformEventHandler2D.this.affineDragCurrent);
        }

        public void end(int x, int y) {
        }
    }

    private class ScrollRotate
    implements ScrollBehaviour {
        private final double speed;

        public ScrollRotate(double speed) {
            this.speed = speed;
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            AffineTransform3D affine = TransformEventHandler2D.this.transform.get();
            double theta = this.speed * wheelRotation * Math.PI / 180.0;
            affine.set(affine.get(0, 3) - (double)x, 0, 3);
            affine.set(affine.get(1, 3) - (double)y, 1, 3);
            affine.rotate(2, theta);
            affine.set(affine.get(0, 3) + (double)x, 0, 3);
            affine.set(affine.get(1, 3) + (double)y, 1, 3);
            TransformEventHandler2D.this.transform.set(affine);
        }
    }

    private class DragRotate
    implements DragBehaviour {
        private DragRotate() {
        }

        public void init(int x, int y) {
            TransformEventHandler2D.this.oX = x;
            TransformEventHandler2D.this.oY = y;
            TransformEventHandler2D.this.transform.get(TransformEventHandler2D.this.affineDragStart);
        }

        public void drag(int x, int y) {
            double dX = x - TransformEventHandler2D.this.centerX;
            double dY = y - TransformEventHandler2D.this.centerY;
            double odX = TransformEventHandler2D.this.oX - (double)TransformEventHandler2D.this.centerX;
            double odY = TransformEventHandler2D.this.oY - (double)TransformEventHandler2D.this.centerY;
            double theta = Math.atan2(dY, dX) - Math.atan2(odY, odX);
            TransformEventHandler2D.this.affineDragCurrent.set(TransformEventHandler2D.this.affineDragStart);
            TransformEventHandler2D.this.rotate(TransformEventHandler2D.this.affineDragCurrent, theta);
            TransformEventHandler2D.this.transform.set(TransformEventHandler2D.this.affineDragCurrent);
        }

        public void end(int x, int y) {
        }
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(KeyConfigScopes.BIGDATAVIEWER, new String[]{"bdv"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TransformEventHandler2D.DRAG_TRANSLATE, DRAG_TRANSLATE_KEYS, "Pan the view by mouse-dragging. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.DRAG_ROTATE, DRAG_ROTATE_KEYS, "Rotate the view by mouse-dragging. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ZOOM_NORMAL, ZOOM_NORMAL_KEYS, "Zoom in by scrolling. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ZOOM_FAST, ZOOM_FAST_KEYS, "Zoom in by scrolling (fast). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ZOOM_SLOW, ZOOM_SLOW_KEYS, "Zoom in by scrolling (slow). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.SCROLL_TRANSLATE, SCROLL_TRANSLATE_KEYS, "Translate by scrolling. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.SCROLL_TRANSLATE_FAST, SCROLL_TRANSLATE_FAST_KEYS, "Translate by scrolling (fast). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.SCROLL_TRANSLATE_SLOW, SCROLL_TRANSLATE_SLOW_KEYS, "Translate by scrolling (slow). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ROTATE_LEFT, ROTATE_LEFT_KEYS, "Rotate left (counter-clockwise) by 1 degree. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ROTATE_RIGHT, ROTATE_RIGHT_KEYS, "Rotate right (clockwise) by 1 degree. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.KEY_ZOOM_IN, KEY_ZOOM_IN_KEYS, "Zoom in. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.KEY_ZOOM_OUT, KEY_ZOOM_OUT_KEYS, "Zoom out. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ROTATE_LEFT_FAST, ROTATE_LEFT_FAST_KEYS, "Rotate left (counter-clockwise) by 10 degrees. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ROTATE_RIGHT_FAST, ROTATE_RIGHT_FAST_KEYS, "Rotate right (clockwise) by 10 degrees. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.KEY_ZOOM_IN_FAST, KEY_ZOOM_IN_FAST_KEYS, "Zoom in (fast). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.KEY_ZOOM_OUT_FAST, KEY_ZOOM_OUT_FAST_KEYS, "Zoom out (fast). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ROTATE_LEFT_SLOW, ROTATE_LEFT_SLOW_KEYS, "Rotate left (counter-clockwise) by 0.1 degree. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.ROTATE_RIGHT_SLOW, ROTATE_RIGHT_SLOW_KEYS, "Rotate right (clockwise) by 0.1 degree. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.KEY_ZOOM_IN_SLOW, KEY_ZOOM_IN_SLOW_KEYS, "Zoom in (slow). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.KEY_ZOOM_OUT_SLOW, KEY_ZOOM_OUT_SLOW_KEYS, "Zoom out (slow). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.SCROLL_ROTATE, SCROLL_ROTATE_KEYS, "Rotate by scrolling. Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.SCROLL_ROTATE_FAST, SCROLL_ROTATE_FAST_KEYS, "Rotate by scrolling (fast). Active in 2D mode.");
            descriptions.add(TransformEventHandler2D.SCROLL_ROTATE_SLOW, SCROLL_ROTATE_SLOW_KEYS, "Rotate by scrolling (slow). Active in 2D mode.");
        }
    }
}

