/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.remote;

import bdv.img.MipmapInfo;
import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.ViewLevelId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.TimePoint;

public class RemoteImageLoaderMetaData {
    protected int maxNumTimepoints;
    protected int maxNumSetups;
    protected int maxNumLevels;
    protected final HashMap<Integer, MipmapInfo> perSetupMipmapInfo = new HashMap();
    protected final HashMap<ViewLevelId, DimsAndExistence> dimsAndExistence = new HashMap();

    public RemoteImageLoaderMetaData(Hdf5ImageLoader imgLoader, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        List timepoints = sequenceDescription.getTimePoints().getTimePointsOrdered();
        this.maxNumTimepoints = ((TimePoint)timepoints.get(timepoints.size() - 1)).getId() + 1;
        List setups = sequenceDescription.getViewSetupsOrdered();
        this.maxNumSetups = ((BasicViewSetup)setups.get(setups.size() - 1)).getId() + 1;
        this.maxNumLevels = 0;
        for (BasicViewSetup setup : setups) {
            int setupId = setup.getId();
            MipmapInfo info = ((Hdf5ImageLoader.SetupImgLoader)imgLoader.getSetupImgLoader(setupId)).getMipmapInfo();
            this.perSetupMipmapInfo.put(setupId, info);
            int numLevels = info.getNumLevels();
            if (numLevels > this.maxNumLevels) {
                this.maxNumLevels = numLevels;
            }
            for (TimePoint timepoint : timepoints) {
                int timepointId = timepoint.getId();
                for (int level = 0; level < numLevels; ++level) {
                    ViewLevelId id = new ViewLevelId(timepointId, setupId, level);
                    this.dimsAndExistence.put(id, imgLoader.getDimsAndExistence(id));
                }
            }
        }
    }

    protected HashMap<ViewLevelId, int[]> createCellsDimensions() {
        HashMap<ViewLevelId, int[]> cellsDimensions = new HashMap<ViewLevelId, int[]>();
        for (Map.Entry<ViewLevelId, DimsAndExistence> entry : this.dimsAndExistence.entrySet()) {
            ViewLevelId id = entry.getKey();
            long[] imageDimensions = entry.getValue().getDimensions();
            int[] cellSize = this.perSetupMipmapInfo.get(id.getViewSetupId()).getSubdivisions()[id.getLevel()];
            int[] dims = new int[]{(int)(imageDimensions[0] + (long)cellSize[0] - 1L) / cellSize[0], (int)(imageDimensions[1] + (long)cellSize[1] - 1L) / cellSize[1], (int)(imageDimensions[2] + (long)cellSize[2] - 1L) / cellSize[2]};
            cellsDimensions.put(id, dims);
        }
        return cellsDimensions;
    }
}

