/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.brightness;

import bdv.tools.brightness.ConverterSetup;
import java.util.Arrays;
import java.util.List;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.listeners.Listeners;

public class RealARGBColorConverterSetup
implements ConverterSetup {
    private final int id;
    private final List<ColorConverter> converters;
    private final Listeners.List<ConverterSetup.SetupChangeListener> listeners;

    public RealARGBColorConverterSetup(int setupId, ColorConverter ... converters) {
        this(setupId, Arrays.asList(converters));
    }

    public RealARGBColorConverterSetup(int setupId, List<ColorConverter> converters) {
        this.id = setupId;
        this.converters = converters;
        this.listeners = new Listeners.SynchronizedList();
    }

    @Override
    public Listeners<ConverterSetup.SetupChangeListener> setupChangeListeners() {
        return this.listeners;
    }

    @Override
    public void setDisplayRange(double min, double max) {
        boolean changed = false;
        for (ColorConverter converter : this.converters) {
            if (converter.getMin() != min) {
                converter.setMin(min);
                changed = true;
            }
            if (converter.getMax() == max) continue;
            converter.setMax(max);
            changed = true;
        }
        if (changed) {
            this.listeners.list.forEach(l -> l.setupParametersChanged(this));
        }
    }

    @Override
    public void setColor(ARGBType color) {
        if (!this.supportsColor()) {
            return;
        }
        boolean changed = false;
        for (ColorConverter converter : this.converters) {
            if (converter.getColor().get() == color.get()) continue;
            converter.setColor(color);
            changed = true;
        }
        if (changed) {
            this.listeners.list.forEach(l -> l.setupParametersChanged(this));
        }
    }

    @Override
    public boolean supportsColor() {
        return this.converters.get(0).supportsColor();
    }

    @Override
    public int getSetupId() {
        return this.id;
    }

    @Override
    public double getDisplayRangeMin() {
        return this.converters.get(0).getMin();
    }

    @Override
    public double getDisplayRangeMax() {
        return this.converters.get(0).getMax();
    }

    @Override
    public ARGBType getColor() {
        return this.converters.get(0).getColor();
    }
}

