/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.transformation;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.render.DefaultMipmapOrdering;
import bdv.viewer.render.MipmapOrdering;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;

public class TransformedSource<T>
implements Source<T>,
MipmapOrdering {
    protected final Source<T> source;
    protected final MipmapOrdering sourceMipmapOrdering;
    protected final AffineTransform3D incrementalTransform;
    protected final AffineTransform3D fixedTransform;
    protected final AffineTransform3D sourceTransform;
    protected final AffineTransform3D composed;
    protected final String name;

    public TransformedSource(Source<T> source) {
        this(source, new AffineTransform3D(), new AffineTransform3D(), new AffineTransform3D(), null);
    }

    public TransformedSource(Source<T> source, String name) {
        this(source, new AffineTransform3D(), new AffineTransform3D(), new AffineTransform3D(), name);
    }

    public TransformedSource(Source<T> source, TransformedSource<?> shareTransform) {
        this(source, shareTransform.incrementalTransform, shareTransform.fixedTransform, shareTransform.sourceTransform, null);
    }

    public TransformedSource(Source<T> source, TransformedSource<?> shareTransform, String name) {
        this(source, shareTransform.incrementalTransform, shareTransform.fixedTransform, shareTransform.sourceTransform, name);
    }

    private TransformedSource(Source<T> source, AffineTransform3D incrementalTransform, AffineTransform3D fixedTransform, AffineTransform3D sourceTransform, String name) {
        this.source = source;
        this.name = name;
        this.sourceMipmapOrdering = MipmapOrdering.class.isInstance(source) ? (MipmapOrdering)((Object)source) : new DefaultMipmapOrdering(source);
        this.incrementalTransform = incrementalTransform;
        this.fixedTransform = fixedTransform;
        this.sourceTransform = sourceTransform;
        this.composed = new AffineTransform3D();
    }

    @Override
    public boolean doBoundingBoxCulling() {
        return this.source.doBoundingBoxCulling();
    }

    public synchronized void setFixedTransform(AffineTransform3D transform) {
        this.fixedTransform.set(transform);
        this.sourceTransform.set(this.incrementalTransform);
        this.sourceTransform.concatenate(this.fixedTransform);
    }

    public synchronized void getFixedTransform(AffineTransform3D transform) {
        transform.set(this.fixedTransform);
    }

    public synchronized void setIncrementalTransform(AffineTransform3D transform) {
        this.incrementalTransform.set(transform);
        this.sourceTransform.set(this.incrementalTransform);
        this.sourceTransform.concatenate(this.fixedTransform);
    }

    public synchronized void getIncrementalTransform(AffineTransform3D transform) {
        transform.set(this.incrementalTransform);
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.source.getSourceTransform(t, level, transform);
        transform.preConcatenate(this.sourceTransform);
    }

    @Override
    public boolean isPresent(int t) {
        return this.source.isPresent(t);
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return this.source.getSource(t, level);
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.source.getInterpolatedSource(t, level, method);
    }

    @Override
    public T getType() {
        return this.source.getType();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.source.getName();
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.source.getVoxelDimensions();
    }

    @Override
    public int getNumMipmapLevels() {
        return this.source.getNumMipmapLevels();
    }

    @Override
    public synchronized MipmapOrdering.MipmapHints getMipmapHints(AffineTransform3D screenTransform, int timepoint, int previousTimepoint) {
        this.composed.set(screenTransform);
        this.composed.concatenate(this.sourceTransform);
        return this.sourceMipmapOrdering.getMipmapHints(this.composed, timepoint, previousTimepoint);
    }

    public Source<T> getWrappedSource() {
        return this.source;
    }
}

