/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.settings.style;

import bdv.ui.settings.SelectAndEditProfileSettingsPage;
import bdv.ui.settings.style.Style;
import bdv.ui.settings.style.StyleManager;
import bdv.ui.settings.style.StyleProfile;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StyleProfileManager<M extends StyleManager<M, S>, S extends Style<S>>
implements SelectAndEditProfileSettingsPage.ProfileManager<StyleProfile<S>> {
    private final M styles;
    private final M styleManager;

    public StyleProfileManager(M styleManager, M editingStyleManager) {
        this.styleManager = styleManager;
        this.styles = editingStyleManager;
        this.styles.set(styleManager);
    }

    @Override
    public List<StyleProfile<S>> getProfiles() {
        return Stream.concat(this.styles.getBuiltinStyles().stream().map(style -> new StyleProfile<Style>((Style)style, true)), this.styles.getUserStyles().stream().map(style -> new StyleProfile<Style>((Style)style, false))).collect(Collectors.toList());
    }

    @Override
    public StyleProfile<S> getSelectedProfile() {
        Object style = this.styles.getSelectedStyle();
        boolean isBuiltin = this.styles.getBuiltinStyles().stream().anyMatch(s -> s.getName().equals(style.getName()));
        return new StyleProfile(style, isBuiltin);
    }

    @Override
    public void select(StyleProfile<S> profile) {
        this.styles.setSelectedStyle(profile.style);
    }

    @Override
    public StyleProfile<S> duplicate(StyleProfile<S> profile) {
        Object duplicate = this.styles.duplicate(profile.style);
        return new StyleProfile(duplicate, false);
    }

    @Override
    public void rename(StyleProfile<S> profile, String newName) {
        this.styles.rename(profile.style, newName);
    }

    @Override
    public void delete(StyleProfile<S> profile) {
        boolean wasSelected = ((StyleProfile)this.getSelectedProfile()).equals(profile);
        int newSelectedIndex = -1;
        if (wasSelected) {
            List<StyleProfile<S>> profiles = this.getProfiles();
            newSelectedIndex = Math.max(0, profiles.indexOf(profile) - 1);
        }
        this.styles.remove(profile.style);
        if (wasSelected) {
            this.select(this.getProfiles().get(newSelectedIndex));
        }
    }

    @Override
    public void apply() {
        this.styleManager.set(this.styles);
        this.styleManager.saveStyles();
    }

    @Override
    public void cancel() {
        this.styles.set(this.styleManager);
    }
}

