/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.sourcetable;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.WrappedList;
import bdv.viewer.ConverterSetups;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceToConverterSetupBimap;
import bdv.viewer.ViewerState;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import net.imglib2.type.numeric.ARGBType;

public class SourceTableModel
extends AbstractTableModel {
    private final ViewerState state;
    private final SourceToConverterSetupBimap converters;
    private StateModel model;
    public static final int NAME_COLUMN = 0;
    public static final int IS_CURRENT_COLUMN = 1;
    public static final int IS_ACTIVE_COLUMN = 2;
    public static final int COLOR_COLUMN = 3;
    private static final int NO_ENTRY_VALUE = -1;

    public SourceTableModel(ViewerState state, ConverterSetups converterSetups) {
        this.state = state;
        this.converters = converterSetups;
        this.model = new StateModel(state);
        converterSetups.listeners().add(converterSetup -> {
            SourceAndConverter<?> source = this.converters.getSource(converterSetup);
            if (source != null) {
                SourceModel sourceModel = new SourceModel(source, state);
                SwingUtilities.invokeLater(() -> {
                    int row = this.model.getSources().indexOf(sourceModel);
                    if (row != -1) {
                        this.fireTableRowsUpdated(row, row);
                    }
                });
            }
        });
        state.changeListeners().add(e -> {
            switch (e) {
                case CURRENT_SOURCE_CHANGED: 
                case SOURCE_ACTIVITY_CHANGED: 
                case NUM_SOURCES_CHANGED: {
                    StateModel model = new StateModel(state);
                    SwingUtilities.invokeLater(() -> this.analyzeChanges(model));
                }
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.model.getSources().size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "name";
            }
            case 2: {
                return "active";
            }
            case 1: {
                return "current";
            }
            case 3: {
                return "color";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SourceModel source = (SourceModel)this.model.getSources().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return source.getName();
            }
            case 2: {
                return source.isActive();
            }
            case 1: {
                return source.isCurrent();
            }
            case 3: {
                ConverterSetup c = this.converters.getConverterSetup(source.getSource());
                return c != null && c.supportsColor() ? c.getColor() : null;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return ARGBType.class;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public SourceModel getValueAt(int rowIndex) {
        return (SourceModel)this.model.getSources().get(rowIndex);
    }

    private void analyzeChanges(StateModel model) {
        StateModel previousModel = this.model;
        this.model = model;
        ArrayList<Object> removedSources = new ArrayList<Object>();
        for (Object source : previousModel.getSources()) {
            if (model.getSources().contains(source)) continue;
            removedSources.add(source);
        }
        ArrayList<Object> addedSources = new ArrayList<Object>();
        for (Object source : model.getSources()) {
            if (previousModel.getSources().contains(source)) continue;
            addedSources.add(source);
        }
        ArrayList<SourceModel> changedSources = new ArrayList<SourceModel>();
        for (SourceModel source : model.getSources()) {
            SourceModel previousSource = previousModel.getSources().get(source);
            if (previousSource == null || source.isCurrent() == previousSource.isCurrent() && source.isActive() == previousSource.isActive()) continue;
            changedSources.add(source);
        }
        if (!addedSources.isEmpty()) {
            int firstRow = model.getSources().indexOf(addedSources.get(0));
            int lastRow = model.getSources().indexOf(addedSources.get(addedSources.size() - 1));
            this.fireTableRowsInserted(firstRow, lastRow);
        } else if (!removedSources.isEmpty()) {
            int firstRow = previousModel.getSources().indexOf(removedSources.get(0));
            int lastRow = previousModel.getSources().indexOf(removedSources.get(removedSources.size() - 1));
            this.fireTableRowsDeleted(firstRow, lastRow);
        }
        if (!changedSources.isEmpty()) {
            int firstRow = model.getSources().indexOf(changedSources.get(0));
            int lastRow = model.getSources().indexOf(changedSources.get(changedSources.size() - 1));
            this.fireTableRowsUpdated(firstRow, lastRow);
        }
    }

    static class SourceModel {
        private final String name;
        private final boolean active;
        private final boolean current;
        private final SourceAndConverter<?> source;

        public SourceModel(SourceAndConverter<?> source, ViewerState state) {
            this.name = source.getSpimSource().getName();
            this.active = state.isSourceActive(source);
            this.current = state.isCurrentSource(source);
            this.source = source;
        }

        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public SourceAndConverter<?> getSource() {
            return this.source;
        }

        public boolean equals(Object o) {
            return o instanceof SourceModel && this.source.equals(((SourceModel)o).source);
        }

        public int hashCode() {
            return this.source.hashCode();
        }
    }

    static class StateModel {
        private final UnmodifiableSources sources;

        public StateModel(ViewerState state) {
            ArrayList<SourceModel> slist = new ArrayList<SourceModel>();
            TObjectIntHashMap sindices = new TObjectIntHashMap(10, 0.5f, -1);
            List<SourceAndConverter<?>> ssources = state.getSources();
            for (int i = 0; i < ssources.size(); ++i) {
                SourceModel sourceModel = new SourceModel(ssources.get(i), state);
                slist.add(sourceModel);
                sindices.put((Object)sourceModel, i);
            }
            this.sources = new UnmodifiableSources(slist, (TObjectIntMap<SourceModel>)sindices);
        }

        public UnmodifiableSources getSources() {
            return this.sources;
        }

        static class UnmodifiableSources
        extends WrappedList<SourceModel> {
            private final TObjectIntMap<SourceModel> sourceIndices;

            public UnmodifiableSources(List<SourceModel> sources, TObjectIntMap<SourceModel> sourceIndices) {
                super(Collections.unmodifiableList(sources));
                this.sourceIndices = sourceIndices;
            }

            public SourceModel get(SourceModel sourceModel) {
                int index = this.sourceIndices.get((Object)sourceModel);
                return index == -1 ? null : (SourceModel)this.get(index);
            }

            @Override
            public boolean contains(Object o) {
                return this.sourceIndices.containsKey(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.sourceIndices.keySet().containsAll(c);
            }

            @Override
            public int indexOf(Object o) {
                return this.sourceIndices.get(o);
            }

            @Override
            public int lastIndexOf(Object o) {
                return this.sourceIndices.get(o);
            }
        }
    }
}

