/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import bdv.ui.UIUtils;
import bdv.util.Prefs;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.ViewerState;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.List;
import mpicbg.spim.data.sequence.TimePoint;

public class SourceInfoOverlayRenderer {
    protected List<TimePoint> timePointsOrdered;
    protected String sourceName;
    protected String groupName;
    protected String timepointString;
    protected Prefs.OverlayPosition sourceNameOverlayPosition = Prefs.OverlayPosition.TOP_RIGHT;

    public synchronized void paint(Graphics2D g) {
        Font font = UIUtils.getFont("monospaced.small.font");
        g.setColor(Color.WHITE);
        g.setFont(font);
        UIUtils.drawString(g, UIUtils.TextPosition.TOP_RIGHT, 0, this.timepointString);
        switch (this.sourceNameOverlayPosition) {
            default: {
                UIUtils.drawString(g, UIUtils.TextPosition.TOP_CENTER, 0, this.sourceName);
                UIUtils.drawString(g, UIUtils.TextPosition.TOP_CENTER, 1, this.groupName);
                break;
            }
            case TOP_RIGHT: {
                UIUtils.drawString(g, UIUtils.TextPosition.TOP_RIGHT, 2, this.sourceName);
                UIUtils.drawString(g, UIUtils.TextPosition.TOP_RIGHT, 3, this.groupName);
            }
        }
    }

    public synchronized void setTimePointsOrdered(List<TimePoint> timePointsOrdered) {
        this.timePointsOrdered = timePointsOrdered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void setViewerState(bdv.viewer.state.ViewerState state) {
        bdv.viewer.state.ViewerState viewerState = state;
        synchronized (viewerState) {
            this.setViewerState(state.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setViewerState(ViewerState state) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            SourceAndConverter<?> currentSource = state.getCurrentSource();
            this.sourceName = currentSource != null ? currentSource.getSpimSource().getName() : "";
            SourceGroup currentGroup = state.getCurrentGroup();
            this.groupName = currentGroup != null && state.getDisplayMode().hasGrouping() ? state.getGroupName(currentGroup) : "";
            int t = state.getCurrentTimepoint();
            this.timepointString = this.timePointsOrdered != null && t >= 0 && t < this.timePointsOrdered.size() ? String.format("t = %s", this.timePointsOrdered.get(t).getName()) : String.format("t = %d", t);
        }
    }

    public void setSourceNameOverlayPosition(Prefs.OverlayPosition position) {
        this.sourceNameOverlayPosition = position;
    }
}

