/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import org.scijava.java3d.AmbientLightRetained;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.AppearanceRetained;
import org.scijava.java3d.AuralAttributes;
import org.scijava.java3d.Background;
import org.scijava.java3d.BackgroundRetained;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.CanvasViewCache;
import org.scijava.java3d.ColoringAttributesRetained;
import org.scijava.java3d.CompressedGeometryRetained;
import org.scijava.java3d.ConeSoundRetained;
import org.scijava.java3d.DepthComponentFloatRetained;
import org.scijava.java3d.DepthComponentIntRetained;
import org.scijava.java3d.DepthComponentNativeRetained;
import org.scijava.java3d.DirectionalLightRetained;
import org.scijava.java3d.Fog;
import org.scijava.java3d.FogRetained;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.HiResCoord;
import org.scijava.java3d.IllegalSharingException;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.ImageComponent2DRetained;
import org.scijava.java3d.ImageComponentRetained;
import org.scijava.java3d.IndexedGeometryArrayRetained;
import org.scijava.java3d.J3dDebug;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.Light;
import org.scijava.java3d.LightRetained;
import org.scijava.java3d.LightSet;
import org.scijava.java3d.LineAttributesRetained;
import org.scijava.java3d.MasterControl;
import org.scijava.java3d.MaterialRetained;
import org.scijava.java3d.ModelClip;
import org.scijava.java3d.ModelClipRetained;
import org.scijava.java3d.NodeComponentRetained;
import org.scijava.java3d.Pipeline;
import org.scijava.java3d.PointAttributesRetained;
import org.scijava.java3d.PointLightRetained;
import org.scijava.java3d.PointSoundRetained;
import org.scijava.java3d.PolygonAttributesRetained;
import org.scijava.java3d.Raster;
import org.scijava.java3d.RasterRetained;
import org.scijava.java3d.RenderBin;
import org.scijava.java3d.RenderingAttributesRetained;
import org.scijava.java3d.Shader;
import org.scijava.java3d.ShaderAppearance;
import org.scijava.java3d.ShaderAppearanceRetained;
import org.scijava.java3d.ShaderAttribute;
import org.scijava.java3d.ShaderAttributeRetained;
import org.scijava.java3d.ShaderAttributeSetRetained;
import org.scijava.java3d.ShaderProgramRetained;
import org.scijava.java3d.ShaderRetained;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.Sound;
import org.scijava.java3d.SoundRetained;
import org.scijava.java3d.SoundScheduler;
import org.scijava.java3d.SpotLightRetained;
import org.scijava.java3d.Text3DRetained;
import org.scijava.java3d.TextureRetained;
import org.scijava.java3d.TextureUnitStateRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransparencyAttributesRetained;
import org.scijava.java3d.View;
import org.scijava.java3d.ViewPlatform;
import org.scijava.java3d.ViewPlatformRetained;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3d;

public class GraphicsContext3D {
    public static final int STEREO_LEFT = 0;
    public static final int STEREO_RIGHT = 1;
    public static final int STEREO_BOTH = 2;
    Canvas3D canvas3d = null;
    private Background uBackground = null;
    private Fog uFog = null;
    private Appearance uAppearance = null;
    private Vector<Light> uLights = new Vector();
    private HiResCoord uHiRes = new HiResCoord();
    private Vector<Sound> uSounds = new Vector();
    private AuralAttributes uAuralAttributes = null;
    private boolean uBufferOverride = false;
    private boolean uFrontBufferRendering = false;
    private int uStereoMode = 2;
    private ModelClip uModelClip = null;
    Background background = null;
    BackgroundRetained black = new BackgroundRetained();
    Fog fog = null;
    ModelClip modelClip = null;
    Appearance appearance = null;
    AppearanceRetained defaultAppearanceRetained = new AppearanceRetained();
    Vector<Light> lights = new Vector();
    HiResCoord hiRes = new HiResCoord();
    Transform3D modelTransform = new Transform3D();
    Transform3D identityTransform = new Transform3D();
    Transform3D modelClipTransform = null;
    Transform3D normalTransform = null;
    boolean normalTransformNeedToUpdate = true;
    Vector<Sound> sounds = new Vector();
    AuralAttributes auralAttributes = null;
    LightSet ls = null;
    LightRetained[] lightlist = null;
    Color3f sceneAmbient = new Color3f(0.0f, 0.0f, 0.0f);
    int numLights = 0;
    Transform3D compTransform = new Transform3D();
    Transform3D drawTransform = new Transform3D();
    Transform3D vpcToEc;
    boolean lightsChanged = false;
    boolean soundsChanged = false;
    boolean bufferOverride = false;
    boolean frontBufferRendering = false;
    int stereoMode = 2;
    byte[] byteBuffer = new byte[1];
    float[] floatBuffer = new float[1];
    int[] intBuffer = new int[1];
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float dRed = 1.0f;
    float dGreen = 1.0f;
    float dBlue = 1.0f;
    float alpha = 0.0f;
    boolean visible = true;
    int polygonMode = 2;
    boolean lineAA = false;
    boolean pointAA = false;
    boolean enableLighting = false;
    private Appearance defaultAppearance = null;
    private boolean ignoreVertexColors = false;
    static final int CLEAR = 0;
    static final int DRAW = 1;
    static final int SWAP = 2;
    static final int READ_RASTER = 3;
    static final int SET_APPEARANCE = 4;
    static final int SET_BACKGROUND = 5;
    static final int SET_FOG = 6;
    static final int SET_LIGHT = 7;
    static final int INSERT_LIGHT = 8;
    static final int REMOVE_LIGHT = 9;
    static final int ADD_LIGHT = 10;
    static final int SET_HI_RES = 11;
    static final int SET_MODEL_TRANSFORM = 12;
    static final int MULTIPLY_MODEL_TRANSFORM = 13;
    static final int SET_SOUND = 14;
    static final int INSERT_SOUND = 15;
    static final int REMOVE_SOUND = 16;
    static final int ADD_SOUND = 17;
    static final int SET_AURAL_ATTRIBUTES = 18;
    static final int SET_BUFFER_OVERRIDE = 19;
    static final int SET_FRONT_BUFFER_RENDERING = 20;
    static final int SET_STEREO_MODE = 21;
    static final int FLUSH = 22;
    static final int FLUSH2D = 23;
    static final int DRAWANDFLUSH2D = 24;
    static final int SET_MODELCLIP = 25;
    static final int DISPOSE2D = 26;
    static final int NCOMMANDS = 27;
    private static Integer[] commands = new Integer[27];
    private static Integer[] stereoModes = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private static final int BUFFER_MODE = 1;
    private int dirtyMask = 0;
    private int numActiveTexUnit = 0;
    private int lastActiveTexUnitIndex = 0;
    private volatile boolean readRasterReady = false;
    private boolean gcReady = false;
    private int waiting = 0;

    GraphicsContext3D(Canvas3D canvas3d) {
        this.canvas3d = canvas3d;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas3d;
    }

    public void setAppearance(Appearance appearance) {
        if (appearance == null) {
            if (this.defaultAppearance == null) {
                this.defaultAppearance = new Appearance();
            }
            appearance = this.defaultAppearance;
        } else {
            AppearanceRetained appRetained = (AppearanceRetained)appearance.retained;
            if (appRetained.texture != null) {
                assert (appRetained.texUnitState == null);
                TextureRetained texRetained = appRetained.texture;
                ImageComponent[] images = texRetained.getImages();
                if (images != null) {
                    for (int i = 0; i < images.length; ++i) {
                        ImageComponentRetained imageRetained;
                        if (images[i] == null || !(imageRetained = (ImageComponentRetained)images[i].retained).getUsedByOffScreen()) continue;
                        throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D30"));
                    }
                }
            } else if (appRetained.texUnitState != null) {
                for (int j = 0; j < appRetained.texUnitState.length; ++j) {
                    TextureRetained texRetained = appRetained.texUnitState[j].texture;
                    ImageComponent[] images = texRetained.getImages();
                    if (images == null) continue;
                    for (int i = 0; i < images.length; ++i) {
                        ImageComponentRetained imageRetained;
                        if (images[i] == null || !(imageRetained = (ImageComponentRetained)images[i].retained).getUsedByOffScreen()) continue;
                        throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D30"));
                    }
                }
            }
        }
        this.uAppearance = appearance;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetAppearance(appearance);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 4, appearance, null);
        } else {
            this.sendRenderMessage(true, 4, appearance, null);
        }
    }

    void doSetAppearance(Appearance appearance) {
        int i;
        assert (appearance != null);
        NodeComponentRetained nc = ((AppearanceRetained)appearance.retained).material;
        if (nc != null) {
            nc.setInImmCtx(true);
            this.enableLighting = ((MaterialRetained)nc).lightingEnable;
            this.dRed = ((MaterialRetained)nc).diffuseColor.x;
            this.dGreen = ((MaterialRetained)nc).diffuseColor.y;
            this.dBlue = ((MaterialRetained)nc).diffuseColor.z;
        } else {
            this.enableLighting = false;
        }
        if (appearance instanceof ShaderAppearance) {
            ShaderAttributeSetRetained sasR;
            ShaderProgramRetained spR = ((ShaderAppearanceRetained)appearance.retained).shaderProgram;
            if (spR != null) {
                spR.setInImmCtx(true);
                Shader[] sArray = spR.getShaders();
                if (sArray != null) {
                    for (int i2 = 0; i2 < sArray.length; ++i2) {
                        if (sArray[i2] == null) continue;
                        ((ShaderRetained)sArray[i2].retained).setInImmCtx(true);
                    }
                }
            }
            if ((sasR = ((ShaderAppearanceRetained)appearance.retained).shaderAttributeSet) != null) {
                sasR.setInImmCtx(true);
                ShaderAttribute[] saArray = sasR.getAll();
                if (saArray != null) {
                    for (i = 0; i < saArray.length; ++i) {
                        if (saArray[i] == null) continue;
                        ((ShaderAttributeRetained)saArray[i].retained).setInImmCtx(true);
                    }
                }
            }
        }
        if (((AppearanceRetained)appearance.retained).texUnitState != null) {
            TextureUnitStateRetained[] texUnitState = ((AppearanceRetained)appearance.retained).texUnitState;
            for (int i3 = 0; i3 < texUnitState.length; ++i3) {
                if (texUnitState[i3] == null) continue;
                texUnitState[i3].setInImmCtx(true);
            }
        }
        if ((nc = ((AppearanceRetained)appearance.retained).texture) != null) {
            nc.setInImmCtx(true);
        }
        if ((nc = ((AppearanceRetained)appearance.retained).texCoordGeneration) != null) {
            nc.setInImmCtx(true);
        }
        if ((nc = ((AppearanceRetained)appearance.retained).textureAttributes) != null) {
            nc.setInImmCtx(true);
        }
        if ((nc = ((AppearanceRetained)appearance.retained).coloringAttributes) != null) {
            nc.setInImmCtx(true);
            this.red = ((ColoringAttributesRetained)nc).color.x;
            this.green = ((ColoringAttributesRetained)nc).color.y;
            this.blue = ((ColoringAttributesRetained)nc).color.z;
        } else {
            this.red = 1.0f;
            this.green = 1.0f;
            this.blue = 1.0f;
        }
        nc = ((AppearanceRetained)appearance.retained).transparencyAttributes;
        if (nc != null) {
            nc.setInImmCtx(true);
            this.alpha = 1.0f - ((TransparencyAttributesRetained)nc).transparency;
        } else {
            this.alpha = 1.0f;
        }
        nc = ((AppearanceRetained)appearance.retained).renderingAttributes;
        if (nc != null) {
            nc.setInImmCtx(true);
            this.visible = ((RenderingAttributesRetained)nc).visible;
        } else {
            this.visible = true;
        }
        nc = ((AppearanceRetained)appearance.retained).polygonAttributes;
        if (nc != null) {
            nc.setInImmCtx(true);
            this.polygonMode = ((PolygonAttributesRetained)nc).polygonMode;
        } else {
            this.polygonMode = 2;
        }
        nc = ((AppearanceRetained)appearance.retained).lineAttributes;
        if (nc != null) {
            nc.setInImmCtx(true);
            this.lineAA = ((LineAttributesRetained)nc).lineAntialiasing;
        } else {
            this.lineAA = false;
        }
        nc = ((AppearanceRetained)appearance.retained).pointAttributes;
        if (nc != null) {
            if (nc.source.isLive()) {
                nc.setInImmCtx(true);
            }
            this.pointAA = ((PointAttributesRetained)nc).pointAntialiasing;
        } else {
            this.pointAA = false;
        }
        if (this.appearance != null) {
            AppearanceRetained app = (AppearanceRetained)this.appearance.retained;
            app.setInImmCtx(false);
            if (app.material != null) {
                app.material.setInImmCtx(false);
            }
            if (app instanceof ShaderAppearanceRetained) {
                ShaderAttributeSetRetained sasR;
                ShaderProgramRetained spR = ((ShaderAppearanceRetained)app).shaderProgram;
                if (spR != null) {
                    spR.setInImmCtx(false);
                    Shader[] sArray = spR.getShaders();
                    if (sArray != null) {
                        for (i = 0; i < sArray.length; ++i) {
                            if (sArray[i] == null) continue;
                            ((ShaderRetained)sArray[i].retained).setInImmCtx(false);
                        }
                    }
                }
                if ((sasR = ((ShaderAppearanceRetained)app).shaderAttributeSet) != null) {
                    sasR.setInImmCtx(false);
                    ShaderAttribute[] saArray = sasR.getAll();
                    if (saArray != null) {
                        for (int i4 = 0; i4 < saArray.length; ++i4) {
                            if (saArray[i4] == null) continue;
                            ((ShaderAttributeRetained)saArray[i4].retained).setInImmCtx(false);
                        }
                    }
                }
            }
            if (app.texUnitState != null) {
                for (int i5 = 0; i5 < app.texUnitState.length; ++i5) {
                    if (app.texUnitState[0] == null) continue;
                    app.texUnitState[0].setInImmCtx(false);
                }
            }
            if (app.texture != null) {
                app.texture.setInImmCtx(false);
            }
            if (app.texCoordGeneration != null) {
                app.texCoordGeneration.setInImmCtx(false);
            }
            if (app.textureAttributes != null) {
                app.textureAttributes.setInImmCtx(false);
            }
            if (app.coloringAttributes != null) {
                app.coloringAttributes.setInImmCtx(false);
            }
            if (app.transparencyAttributes != null) {
                app.transparencyAttributes.setInImmCtx(false);
            }
            if (app.renderingAttributes != null) {
                app.renderingAttributes.setInImmCtx(false);
            }
            if (app.polygonAttributes != null) {
                app.polygonAttributes.setInImmCtx(false);
            }
            if (app.lineAttributes != null) {
                app.lineAttributes.setInImmCtx(false);
            }
            if (app.pointAttributes != null) {
                app.pointAttributes.setInImmCtx(false);
            }
        }
        ((AppearanceRetained)appearance.retained).setInImmCtx(true);
        this.appearance = appearance;
    }

    public Appearance getAppearance() {
        return this.uAppearance;
    }

    public void setBackground(Background background) {
        ImageComponent2DRetained imageRetained;
        if (background.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D11"));
        }
        BackgroundRetained bgRetained = (BackgroundRetained)background.retained;
        ImageComponent2D image = bgRetained.getImage();
        if (image != null && (imageRetained = (ImageComponent2DRetained)image.retained).getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D31"));
        }
        if (((BackgroundRetained)background.retained).geometryBranch != null) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D22"));
        }
        this.uBackground = background;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetBackground(background);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 5, background, null);
        } else {
            this.sendRenderMessage(true, 5, background, null);
        }
    }

    void doSetBackground(Background background) {
        BackgroundRetained bg;
        if (this.background != null) {
            bg = (BackgroundRetained)this.background.retained;
            bg.setInImmCtx(false);
        }
        bg = (BackgroundRetained)background.retained;
        bg.setInImmCtx(true);
        this.background = background;
    }

    public Background getBackground() {
        return this.uBackground;
    }

    public void setFog(Fog fog) {
        if (fog != null && fog.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D12"));
        }
        this.uFog = fog;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetFog(fog);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 6, fog, null);
        } else {
            this.sendRenderMessage(true, 6, fog, null);
        }
    }

    void doSetFog(Fog fog) {
        if (this.fog != null) {
            ((FogRetained)this.fog.retained).setInImmCtx(false);
        }
        this.fog = fog;
        if (fog != null) {
            ((FogRetained)fog.retained).setInImmCtx(true);
            this.updateFogState((FogRetained)fog.retained);
        }
    }

    public Fog getFog() {
        return this.uFog;
    }

    public void setModelClip(ModelClip modelClip) {
        if (modelClip != null && modelClip.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D25"));
        }
        this.uModelClip = modelClip;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetModelClip(modelClip);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 25, modelClip, null);
        } else {
            this.sendRenderMessage(true, 25, modelClip, null);
        }
    }

    void doSetModelClip(ModelClip modelClip) {
        ModelClipRetained mc = null;
        this.modelClip = modelClip;
        if (this.modelClip != null) {
            mc = (ModelClipRetained)this.modelClip.retained;
            mc.setInImmCtx(true);
            if (this.modelClipTransform == null) {
                this.modelClipTransform = new Transform3D();
            }
            this.modelClipTransform.set(this.compTransform);
        }
    }

    public ModelClip getModelClip() {
        return this.uModelClip;
    }

    public void setLight(Light light, int index) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.set(index, light);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetLight(light, index);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 7, light, new Integer(index));
        } else {
            this.sendRenderMessage(true, 7, light, new Integer(index));
        }
    }

    void doSetLight(Light light, int index) {
        Light oldlight = this.lights.get(index);
        if (oldlight != null) {
            ((LightRetained)oldlight.retained).setInImmCtx(false);
        }
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.set(index, light);
        this.lightsChanged = true;
    }

    public void insertLight(Light light, int index) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.add(index, light);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doInsertLight(light, index);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 8, light, new Integer(index));
        } else {
            this.sendRenderMessage(true, 8, light, new Integer(index));
        }
    }

    void doInsertLight(Light light, int index) {
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.add(index, light);
        this.lightsChanged = true;
    }

    public void removeLight(int index) {
        this.uLights.remove(index);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doRemoveLight(index);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 9, new Integer(index), null);
        } else {
            this.sendRenderMessage(true, 9, new Integer(index), null);
        }
    }

    void doRemoveLight(int index) {
        Light light = this.lights.get(index);
        ((LightRetained)light.retained).setInImmCtx(false);
        this.lights.remove(index);
        this.lightsChanged = true;
    }

    public Light getLight(int index) {
        return this.uLights.get(index);
    }

    public Enumeration<Light> getAllLights() {
        return this.uLights.elements();
    }

    public void addLight(Light light) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.addElement(light);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doAddLight(light);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 10, light, null);
        } else {
            this.sendRenderMessage(true, 10, light, null);
        }
    }

    void doAddLight(Light light) {
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.add(light);
        this.lightsChanged = true;
    }

    public int numLights() {
        return this.uLights.size();
    }

    private Transform3D getNormalTransform() {
        if (this.compTransform.isRigid()) {
            return this.compTransform;
        }
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D();
        }
        if (this.normalTransformNeedToUpdate) {
            this.normalTransform.invert(this.compTransform);
            this.normalTransform.transpose();
            this.normalTransformNeedToUpdate = false;
        }
        return this.normalTransform;
    }

    void updateFogState(FogRetained fogRet) {
        fogRet.setLocalToVworldScale(this.modelTransform.getDistanceScale());
    }

    void updateLightState(LightRetained light) {
        if (light instanceof DirectionalLightRetained) {
            DirectionalLightRetained dl = (DirectionalLightRetained)light;
            Transform3D xform = this.getNormalTransform();
            xform.transform(dl.direction, dl.xformDirection);
            dl.xformDirection.normalize();
        } else if (light instanceof SpotLightRetained) {
            SpotLightRetained sl = (SpotLightRetained)light;
            Transform3D xform = this.getNormalTransform();
            xform.transform(sl.direction, sl.xformDirection);
            sl.xformDirection.normalize();
            this.modelTransform.transform(sl.position, sl.xformPosition);
        } else if (light instanceof PointLightRetained) {
            PointLightRetained pl = (PointLightRetained)light;
            this.modelTransform.transform(pl.position, pl.xformPosition);
            pl.localToVworldScale = this.modelTransform.getDistanceScale();
        }
    }

    public void setHiRes(int[] x, int[] y, int[] z) {
        HiResCoord hiRes = new HiResCoord(x, y, z);
        this.setHiRes(hiRes);
    }

    public void setHiRes(HiResCoord hiRes) {
        this.uHiRes.setHiResCoord(hiRes);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetHiRes(hiRes);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 11, hiRes, null);
        } else {
            this.sendRenderMessage(true, 11, hiRes, null);
        }
    }

    void doSetHiRes(HiResCoord hiRes) {
        this.hiRes.setHiResCoord(hiRes);
        this.computeCompositeTransform();
    }

    public void getHiRes(HiResCoord hiRes) {
        this.uHiRes.getHiResCoord(hiRes);
    }

    public void setModelTransform(Transform3D t) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetModelTransform(t);
        } else {
            Transform3D uModelTransform = new Transform3D(t);
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 12, uModelTransform, null);
            } else {
                this.sendRenderMessage(true, 12, uModelTransform, null);
            }
        }
    }

    void doSetModelTransform(Transform3D t) {
        this.modelTransform.set(t);
        this.computeCompositeTransform();
        this.normalTransformNeedToUpdate = true;
    }

    public void multiplyModelTransform(Transform3D t) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doMultiplyModelTransform(t);
        } else {
            Transform3D tt = new Transform3D(t);
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 13, tt, null);
            } else {
                this.sendRenderMessage(true, 13, tt, null);
            }
        }
    }

    void doMultiplyModelTransform(Transform3D t) {
        this.modelTransform.mul(t);
        this.computeCompositeTransform();
        this.normalTransformNeedToUpdate = true;
    }

    public void getModelTransform(Transform3D t) {
        t.set(this.modelTransform);
    }

    public void setSound(Sound sound, int index) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.set(index, sound);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetSound(sound, index);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 14, sound, new Integer(index));
        } else {
            this.sendRenderMessage(true, 14, sound, new Integer(index));
        }
    }

    void doSetSound(Sound sound, int index) {
        Sound oldSound = this.sounds.get(index);
        ((SoundRetained)sound.retained).setInImmCtx(true);
        if (oldSound != null) {
            ((SoundRetained)oldSound.retained).setInImmCtx(false);
        }
        ((SoundRetained)sound.retained).setInImmCtx(true);
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.set(index, sound);
        this.soundsChanged = true;
        this.sendSoundMessage(14, sound, oldSound);
    }

    public void insertSound(Sound sound, int index) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.add(index, sound);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doInsertSound(sound, index);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 15, sound, new Integer(index));
        } else {
            this.sendRenderMessage(true, 15, sound, new Integer(index));
        }
    }

    void doInsertSound(Sound sound, int index) {
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.add(index, sound);
        this.soundsChanged = true;
        this.sendSoundMessage(15, sound, null);
    }

    public void removeSound(int index) {
        this.uSounds.remove(index);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doRemoveSound(index);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 16, new Integer(index), null);
        } else {
            this.sendRenderMessage(true, 16, new Integer(index), null);
        }
    }

    void doRemoveSound(int index) {
        Sound sound = this.sounds.get(index);
        SoundScheduler soundScheduler = this.getSoundScheduler();
        ((SoundRetained)sound.retained).setInImmCtx(false);
        this.sounds.remove(index);
        this.soundsChanged = true;
        this.sendSoundMessage(16, null, sound);
    }

    public Sound getSound(int index) {
        return this.uSounds.get(index);
    }

    public Enumeration<Sound> getAllSounds() {
        return this.uSounds.elements();
    }

    public void addSound(Sound sound) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.add(sound);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doAddSound(sound);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 17, sound, null);
        } else {
            this.sendRenderMessage(true, 17, sound, null);
        }
    }

    void doAddSound(Sound sound) {
        ((SoundRetained)sound.retained).setInImmCtx(true);
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.add(sound);
        this.soundsChanged = true;
        this.sendSoundMessage(17, sound, null);
    }

    public int numSounds() {
        return this.uSounds.size();
    }

    SoundScheduler getSoundScheduler() {
        if (this.canvas3d != null && this.canvas3d.view != null) {
            return this.canvas3d.view.soundScheduler;
        }
        return null;
    }

    void updateSoundState(SoundRetained sound) {
        SoundScheduler soundScheduler;
        View view = null;
        if (this.canvas3d != null) {
            view = this.canvas3d.view;
        }
        if (view == null || (soundScheduler = this.getSoundScheduler()) == null) {
            // empty if block
        }
        if (sound instanceof ConeSoundRetained) {
            ConeSoundRetained cs = (ConeSoundRetained)sound;
            this.modelTransform.transform(cs.direction, cs.xformDirection);
            cs.xformDirection.normalize();
            this.modelTransform.transform(cs.position, cs.xformPosition);
            cs.trans.setWithLock(this.drawTransform);
        } else if (sound instanceof PointSoundRetained) {
            PointSoundRetained ps = (PointSoundRetained)sound;
            this.modelTransform.transform(ps.position, ps.xformPosition);
            ps.trans.setWithLock(this.drawTransform);
        }
    }

    public boolean isSoundPlaying(int index) {
        Sound sound = this.sounds.get(index);
        return sound.isPlaying();
    }

    public void setAuralAttributes(AuralAttributes attributes) {
        this.uAuralAttributes = attributes;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetAuralAttributes(attributes);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 18, attributes, null);
        } else {
            this.sendRenderMessage(true, 18, attributes, null);
        }
    }

    void doSetAuralAttributes(AuralAttributes attributes) {
        this.auralAttributes = attributes;
        this.sendSoundMessage(18, attributes, null);
    }

    public AuralAttributes getAuralAttributes() {
        return this.uAuralAttributes;
    }

    public void setBufferOverride(boolean bufferOverride) {
        this.uBufferOverride = bufferOverride;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetBufferOverride(bufferOverride);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 19, new Boolean(bufferOverride), null);
        } else {
            this.sendRenderMessage(true, 19, new Boolean(bufferOverride), null);
        }
    }

    void doSetBufferOverride(boolean bufferOverride) {
        if (bufferOverride != this.bufferOverride) {
            this.bufferOverride = bufferOverride;
            this.dirtyMask |= 1;
        }
    }

    public boolean getBufferOverride() {
        return this.uBufferOverride;
    }

    public void setFrontBufferRendering(boolean frontBufferRendering) {
        this.uFrontBufferRendering = frontBufferRendering;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetFrontBufferRendering(frontBufferRendering);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 20, new Boolean(frontBufferRendering), null);
        } else {
            this.sendRenderMessage(true, 20, new Boolean(frontBufferRendering), null);
        }
    }

    void doSetFrontBufferRendering(boolean frontBufferRendering) {
        if (frontBufferRendering != this.frontBufferRendering) {
            this.frontBufferRendering = frontBufferRendering;
            this.dirtyMask |= 1;
        }
    }

    public boolean getFrontBufferRendering() {
        return this.uFrontBufferRendering;
    }

    public void setStereoMode(int stereoMode) {
        this.uStereoMode = stereoMode;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetStereoMode(stereoMode);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 21, stereoModes[stereoMode], null);
        } else {
            this.sendRenderMessage(true, 21, stereoModes[stereoMode], null);
        }
    }

    void doSetStereoMode(int stereoMode) {
        if (stereoMode != this.stereoMode) {
            this.stereoMode = stereoMode;
            this.dirtyMask |= 1;
        }
    }

    public int getStereoMode() {
        return this.uStereoMode;
    }

    public void clear() {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doClear();
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 0, null, null);
        } else {
            this.sendRenderMessage(true, 0, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClear() {
        block23: {
            if (!this.canvas3d.firstPaintCalled) {
                return;
            }
            RenderBin rb = this.canvas3d.view.renderBin;
            BackgroundRetained back = null;
            back = this.background != null ? (BackgroundRetained)this.background.retained : this.black;
            if (!this.canvas3d.isRunning) {
                this.updateViewCache(rb);
            }
            try {
                if (!this.canvas3d.offScreen) {
                    this.canvas3d.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
                }
                if (!this.canvas3d.drawingSurfaceObject.renderLock()) break block23;
                if (this.canvas3d.ctx == null) {
                    Object object = VirtualUniverse.mc.contextCreationLock;
                    synchronized (object) {
                        this.canvas3d.ctx = this.canvas3d.createNewContext(null, false);
                        if (this.canvas3d.ctx == null) {
                            this.canvas3d.drawingSurfaceObject.unLock();
                            return;
                        }
                        this.canvas3d.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                        this.canvas3d.screen.renderer.listOfCtxs.add(this.canvas3d.ctx);
                        this.canvas3d.screen.renderer.listOfCanvases.add(this.canvas3d);
                        if (this.canvas3d.graphics2D != null) {
                            this.canvas3d.graphics2D.init();
                        }
                        this.canvas3d.enableSeparateSpecularColor();
                    }
                    if (this.canvas3d.texUnitState == null) {
                        this.canvas3d.createTexUnitState();
                    }
                    this.canvas3d.drawingSurfaceObject.contextValidated();
                    this.canvas3d.screen.renderer.currentCtx = this.canvas3d.ctx;
                    this.canvas3d.screen.renderer.currentDrawable = this.canvas3d.drawable;
                    this.initializeState();
                    this.canvas3d.ctxChanged = true;
                    this.canvas3d.canvasDirty = 65535;
                    this.updateState(rb, 4);
                    this.canvas3d.currentLights = new LightRetained[this.canvas3d.getNumCtxLights(this.canvas3d.ctx)];
                    for (int j = 0; j < this.canvas3d.currentLights.length; ++j) {
                        this.canvas3d.currentLights[j] = null;
                    }
                }
                this.canvas3d.makeCtxCurrent();
                if ((this.dirtyMask & 1) != 0) {
                    if (this.bufferOverride) {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, this.stereoMode, this.canvas3d.useDoubleBuffer && !this.frontBufferRendering);
                    } else if (!this.canvas3d.isRunning) {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, 2, this.canvas3d.useDoubleBuffer);
                    }
                    this.dirtyMask &= 0xFFFFFFFE;
                }
                Dimension size = this.canvas3d.getSize();
                int winWidth = size.width;
                int winHeight = size.height;
                boolean isByRefBackgroundImage = false;
                if (back.image != null) {
                    if (back.image.isByReference()) {
                        back.image.geomLock.getLock();
                        isByRefBackgroundImage = true;
                    }
                    back.image.evaluateExtensions(this.canvas3d);
                }
                this.canvas3d.clear(back, winWidth, winHeight);
                if (isByRefBackgroundImage) {
                    back.image.geomLock.unLock();
                }
                if (!this.canvas3d.isRunning) {
                    CanvasViewCache cvCache = this.canvas3d.canvasViewCache;
                    this.canvas3d.setViewport(this.canvas3d.ctx, 0, 0, cvCache.getCanvasWidth(), cvCache.getCanvasHeight());
                    if (this.bufferOverride && this.stereoMode == 1) {
                        this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, cvCache.getRightProjection());
                        this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, cvCache.getRightVpcToEc().mat, rb.vworldToVpc);
                    } else {
                        this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, cvCache.getLeftProjection());
                        this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, cvCache.getLeftVpcToEc().mat, rb.vworldToVpc);
                    }
                }
                this.canvas3d.drawingSurfaceObject.unLock();
            }
            catch (NullPointerException ne) {
                this.canvas3d.drawingSurfaceObject.unLock();
                throw ne;
            }
        }
    }

    private void computeCompositeTransform() {
        ViewPlatform vp;
        if (this.canvas3d == null || this.canvas3d.view == null || (vp = this.canvas3d.view.getViewPlatform()) == null || (ViewPlatformRetained)vp.retained == null) {
            this.compTransform.set(this.modelTransform);
            return;
        }
        ViewPlatformRetained vpR = (ViewPlatformRetained)vp.retained;
        if (vpR == null || vpR.locale == null) {
            this.compTransform.set(this.modelTransform);
            return;
        }
        HiResCoord localeHiRes = vpR.locale.hiRes;
        if (localeHiRes.equals(this.hiRes)) {
            this.compTransform.set(this.modelTransform);
        } else {
            Transform3D trans = new Transform3D();
            Vector3d localeTrans = new Vector3d();
            localeHiRes.difference(this.hiRes, localeTrans);
            trans.setTranslation(localeTrans);
            this.compTransform.mul(trans, this.modelTransform);
        }
    }

    private void updateViewCache(RenderBin rb) {
        ViewPlatform vp = this.canvas3d.view.getViewPlatform();
        if (vp == null) {
            return;
        }
        ViewPlatformRetained vpR = (ViewPlatformRetained)vp.retained;
        if (!this.canvas3d.isRunning) {
            vpR.evaluateInitViewPlatformTransform();
        }
        rb.vpcToVworld = vpR.getVpcToVworld();
        rb.vworldToVpc = vpR.getVworldToVpc();
        this.canvas3d.updateViewCache(true, null, null, false);
    }

    void doDraw(Geometry geometry) {
        GeometryArrayRetained geoRetained = null;
        if (!this.canvas3d.firstPaintCalled || !this.visible) {
            return;
        }
        RenderBin rb = this.canvas3d.view.renderBin;
        if (this.canvas3d.ctx == null) {
            this.doClear();
        }
        if (J3dDebug.debug) {
            J3dDebug.doAssert(this.canvas3d.ctx != null, "canvas3d.ctx != null");
        }
        try {
            if (this.canvas3d.drawingSurfaceObject.renderLock()) {
                GeometryRetained drawGeo;
                this.canvas3d.makeCtxCurrent();
                if ((this.dirtyMask & 1) != 0) {
                    if (this.bufferOverride) {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, this.stereoMode, this.canvas3d.useDoubleBuffer && !this.frontBufferRendering);
                    } else {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, 2, this.canvas3d.useDoubleBuffer);
                    }
                    this.dirtyMask &= 0xFFFFFFFE;
                }
                CanvasViewCache cvCache = this.canvas3d.canvasViewCache;
                if (this.bufferOverride) {
                    switch (this.stereoMode) {
                        case 1: {
                            this.vpcToEc = cvCache.getRightVpcToEc();
                            this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, cvCache.getRightProjection());
                            break;
                        }
                        default: {
                            this.vpcToEc = cvCache.getLeftVpcToEc();
                            this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, cvCache.getLeftProjection());
                            break;
                        }
                    }
                } else {
                    this.vpcToEc = !this.canvas3d.isRunning || this.canvas3d.vpcToEc == null ? cvCache.getLeftVpcToEc() : this.canvas3d.vpcToEc;
                }
                boolean isNonUniformScale = !this.drawTransform.isCongruent();
                int geometryType = 0;
                block4 : switch (((GeometryRetained)geometry.retained).geoType) {
                    case 3: 
                    case 10: {
                        geometryType = 1;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: {
                        geometryType = 2;
                        break;
                    }
                    case 15: {
                        geometryType = 8;
                        break;
                    }
                    case 17: {
                        geometryType = 16;
                        switch (((CompressedGeometryRetained)geometry.retained).getBufferType()) {
                            case 0: {
                                geometryType |= 1;
                                break block4;
                            }
                            case 1: {
                                geometryType |= 2;
                                break block4;
                            }
                        }
                        geometryType |= 4;
                        break;
                    }
                    default: {
                        geometryType = 4;
                    }
                }
                boolean useAlpha = this.updateState(rb, geometryType);
                this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, rb.vworldToVpc);
                this.updateLightAndFog();
                this.updateModelClip(rb.vworldToVpc);
                this.drawTransform.mul(rb.vworldToVpc, this.compTransform);
                this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, this.drawTransform);
                if (geometry.retained instanceof GeometryArrayRetained) {
                    geoRetained = (GeometryArrayRetained)geometry.retained;
                    geoRetained.geomLock.getLock();
                    if ((geoRetained.vertexFormat & 0x80) != 0 && geoRetained.c4fAllocated == 0 && (geoRetained.vertexFormat & 4) != 0 && useAlpha) {
                        if ((geoRetained.vertexFormat & 0x100) != 0) {
                            geoRetained.setupMirrorInterleavedColorPointer(true);
                        } else {
                            geoRetained.setupMirrorColorPointer(geoRetained.vertexType & 0x3F0, true);
                        }
                    }
                    if (geometry.retained instanceof IndexedGeometryArrayRetained && (((GeometryArrayRetained)geometry.retained).vertexFormat & 0x200) == 0) {
                        if (geoRetained.dirtyFlag != 0) {
                            geoRetained.mirrorGeometry = ((IndexedGeometryArrayRetained)geoRetained).cloneNonIndexedGeometry();
                            geoRetained.dirtyFlag = 0;
                        }
                        drawGeo = geoRetained.mirrorGeometry;
                    } else {
                        drawGeo = geoRetained;
                    }
                    geoRetained.setVertexFormat(false, this.ignoreVertexColors, this.canvas3d.ctx);
                } else if (geometry.retained instanceof Text3DRetained) {
                    ((Text3DRetained)geometry.retained).setModelViewMatrix(this.vpcToEc, this.drawTransform);
                    drawGeo = (GeometryRetained)geometry.retained;
                } else if (geometry.retained instanceof RasterRetained) {
                    ImageComponent2DRetained img = ((RasterRetained)geometry.retained).image;
                    if (img != null) {
                        if (img.isByReference()) {
                            img.geomLock.getLock();
                            img.evaluateExtensions(this.canvas3d);
                            img.geomLock.unLock();
                        } else {
                            img.evaluateExtensions(this.canvas3d);
                        }
                    }
                    drawGeo = (GeometryRetained)geometry.retained;
                } else {
                    drawGeo = (GeometryRetained)geometry.retained;
                }
                drawGeo.execute(this.canvas3d, null, isNonUniformScale, false, this.alpha, this.canvas3d.screen.screen, this.ignoreVertexColors);
                if (geoRetained != null) {
                    geoRetained.geomLock.unLock();
                }
                this.canvas3d.drawingSurfaceObject.unLock();
            }
        }
        catch (NullPointerException ne) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw ne;
        }
    }

    public void draw(Geometry geometry) {
        ImageComponentRetained imageRetained;
        RasterRetained rasRetained;
        ImageComponent2D image;
        if (geometry != null && geometry instanceof Raster && (image = (rasRetained = (RasterRetained)geometry.retained).getImage()) != null && (imageRetained = (ImageComponentRetained)image.retained).getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D32"));
        }
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doDraw(geometry);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 1, geometry, null);
        } else {
            this.sendRenderMessage(true, 1, geometry, null);
        }
    }

    public void draw(Shape3D shape) {
        if (shape.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D26"));
        }
        ((Shape3DRetained)shape.retained).setInImmCtx(true);
        this.setAppearance(shape.getAppearance());
        this.draw(shape.getGeometry());
    }

    public void readRaster(Raster raster) {
        ImageComponent2D image;
        if (raster != null && raster.isLive() && (image = raster.getImage()) != null) {
            ImageComponent2DRetained imageRetained = (ImageComponent2DRetained)image.retained;
            if (image.getImageClass() != ImageComponent.ImageClass.BUFFERED_IMAGE) {
                throw new IllegalArgumentException(J3dI18N.getString("GraphicsContext3D33"));
            }
            if (image.isByReference() && image.getImage() == null) {
                throw new IllegalArgumentException(J3dI18N.getString("GraphicsContext3D34"));
            }
            if (imageRetained.getNumberOfComponents() < 3) {
                throw new IllegalArgumentException(J3dI18N.getString("GraphicsContext3D35"));
            }
            if (image.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D36"));
            }
            if (imageRetained.getInImmCtx() || imageRetained.getUsedByOffScreen()) {
                throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D37"));
            }
        }
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doReadRaster(raster);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.readRasterReady = false;
            this.sendRenderMessage(false, 3, raster, null);
            while (!this.readRasterReady) {
                MasterControl.threadYield();
            }
        } else {
            this.readRasterReady = false;
            this.sendRenderMessage(true, 3, raster, null);
            while (!this.readRasterReady) {
                MasterControl.threadYield();
            }
        }
    }

    void doReadRaster(Raster raster) {
        if (!this.canvas3d.firstPaintCalled) {
            this.readRasterReady = true;
            return;
        }
        RasterRetained ras = (RasterRetained)raster.retained;
        Dimension canvasSize = this.canvas3d.getSize();
        Dimension rasterSize = new Dimension();
        ImageComponent2DRetained image = ras.image;
        boolean format = false;
        if (this.canvas3d.ctx == null) {
            this.doClear();
        }
        if (J3dDebug.debug) {
            J3dDebug.doAssert(this.canvas3d.ctx != null, "canvas3d.ctx != null");
        }
        ras.getSize(rasterSize);
        if ((ras.type & 1) != 0 && (rasterSize.width > ras.image.width || rasterSize.height > ras.image.height)) {
            throw new RuntimeException(J3dI18N.getString("GraphicsContext3D27"));
        }
        if ((ras.type & 2) != 0) {
            int size = ras.depthComponent.height * ras.depthComponent.width;
            if (ras.depthComponent.type == 2) {
                if (this.floatBuffer.length < size) {
                    this.floatBuffer = new float[size];
                }
            } else if (this.intBuffer.length < size) {
                this.intBuffer = new int[size];
            }
            if (rasterSize.width > ras.depthComponent.width || rasterSize.height > ras.depthComponent.height) {
                throw new RuntimeException(J3dI18N.getString("GraphicsContext3D28"));
            }
        }
        if ((ras.type & 1) != 0) {
            if (image.isByReference()) {
                image.geomLock.getLock();
                image.evaluateExtensions(this.canvas3d);
                image.geomLock.unLock();
            } else if (image.imageData == null) {
                image.createBlankImageData();
            } else {
                image.evaluateExtensions(this.canvas3d);
            }
        }
        try {
            if (this.canvas3d.drawingSurfaceObject.renderLock()) {
                this.canvas3d.makeCtxCurrent();
                this.canvas3d.syncRender(this.canvas3d.ctx, true);
                Point rasterSrcOffset = new Point();
                ras.getSrcOffset(rasterSrcOffset);
                int depthType = 0;
                Object[] depthBuffer = null;
                if (ras.depthComponent != null) {
                    depthType = ras.depthComponent.type;
                    depthBuffer = depthType == 2 ? this.floatBuffer : (Object[])this.intBuffer;
                }
                int imageDataType = 0;
                int imageFormatType = 0;
                Object imageBuffer = null;
                if ((ras.type & 1) != 0) {
                    imageDataType = image.getImageDataTypeIntValue();
                    imageFormatType = image.getImageFormatTypeIntValue(false);
                    imageBuffer = image.imageData.get();
                }
                Pipeline.getPipeline().readRaster(this.canvas3d.ctx, ras.type, rasterSrcOffset.x, rasterSrcOffset.y, rasterSize.width, rasterSize.height, canvasSize.height, imageDataType, imageFormatType, imageBuffer, depthType, depthBuffer);
                this.canvas3d.drawingSurfaceObject.unLock();
            }
        }
        catch (NullPointerException ne) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw ne;
        }
        if ((ras.type & 2) != 0) {
            if (ras.depthComponent.type == 2) {
                ((DepthComponentFloatRetained)ras.depthComponent).retrieveDepth(this.floatBuffer, rasterSize.width, rasterSize.height);
            } else if (ras.depthComponent.type == 1) {
                ((DepthComponentIntRetained)ras.depthComponent).retrieveDepth(this.intBuffer, rasterSize.width, rasterSize.height);
            } else if (ras.depthComponent.type == 1) {
                ((DepthComponentNativeRetained)ras.depthComponent).retrieveDepth(this.intBuffer, rasterSize.width, rasterSize.height);
            }
        }
        this.readRasterReady = true;
    }

    public void flush(boolean wait) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doFlush(wait);
        } else {
            Boolean waitArg;
            Boolean bl = waitArg = wait ? Boolean.TRUE : Boolean.FALSE;
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 22, waitArg, null);
            } else {
                this.sendRenderMessage(true, 22, waitArg, null);
            }
            if (wait && this.canvas3d.active && this.canvas3d.isRunningStatus && !this.canvas3d.manualRendering) {
                this.runMonitor(0);
            }
        }
    }

    void doFlush(boolean wait) {
        try {
            if (this.canvas3d.drawingSurfaceObject.renderLock()) {
                this.canvas3d.syncRender(this.canvas3d.ctx, wait);
                this.canvas3d.drawingSurfaceObject.unLock();
                if (wait) {
                    this.runMonitor(2);
                }
            }
        }
        catch (NullPointerException ne) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw ne;
        }
    }

    void updateLightAndFog() {
        int enableMask = 0;
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        int n = 0;
        int nLight = this.lights.size();
        for (int i = 0; i < nLight; ++i) {
            LightRetained lt = (LightRetained)this.lights.get((int)i).retained;
            if (lt instanceof AmbientLightRetained) {
                this.sceneAmbient.x += lt.color.x;
                this.sceneAmbient.y += lt.color.y;
                this.sceneAmbient.z += lt.color.z;
                continue;
            }
            lt.update(this.canvas3d.ctx, n, this.canvas3d.canvasViewCache.getVworldToCoexistenceScale());
            if (lt.lightOn) {
                enableMask |= 1 << n;
            }
            ++n;
        }
        if (this.sceneAmbient.x > 1.0f) {
            this.sceneAmbient.x = 1.0f;
        }
        if (this.sceneAmbient.y > 1.0f) {
            this.sceneAmbient.y = 1.0f;
        }
        if (this.sceneAmbient.z > 1.0f) {
            this.sceneAmbient.z = 1.0f;
        }
        this.canvas3d.setSceneAmbient(this.canvas3d.ctx, this.sceneAmbient.x, this.sceneAmbient.y, this.sceneAmbient.z);
        this.canvas3d.canvasDirty |= 0x100;
        this.canvas3d.sceneAmbient.set((Tuple3f)this.sceneAmbient);
        if (this.canvas3d.enableMask != (long)enableMask) {
            this.canvas3d.canvasDirty |= 0x80;
            this.canvas3d.setLightEnables(this.canvas3d.ctx, enableMask, 32);
            this.canvas3d.enableMask = enableMask;
        }
        this.canvas3d.lightBin = null;
        this.canvas3d.environmentSet = null;
        if (this.fog != null) {
            if (this.fog.retained != this.canvas3d.fog) {
                ((FogRetained)this.fog.retained).update(this.canvas3d.ctx, this.canvas3d.canvasViewCache.getVworldToCoexistenceScale());
                this.canvas3d.fog = (FogRetained)this.fog.retained;
                this.canvas3d.canvasDirty |= 0x2000;
            }
        } else if (this.canvas3d.fog != null) {
            this.canvas3d.setFogEnableFlag(this.canvas3d.ctx, false);
            this.canvas3d.fog = null;
            this.canvas3d.canvasDirty |= 0x2000;
        }
    }

    void updateModelClip(Transform3D vworldToVpc) {
        if (this.modelClip != null) {
            int enableMask = 0;
            for (int i = 0; i < 6; ++i) {
                if (!((ModelClipRetained)this.modelClip.retained).enables[i]) continue;
                enableMask |= 1 << i;
            }
            if (enableMask != 0) {
                this.drawTransform.mul(vworldToVpc, this.modelClipTransform);
                this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, this.drawTransform);
            }
            ((ModelClipRetained)this.modelClip.retained).update(this.canvas3d.ctx, enableMask, this.drawTransform);
            this.canvas3d.canvasDirty |= 0x4000;
            this.canvas3d.modelClip = (ModelClipRetained)this.modelClip.retained;
        } else if (this.canvas3d.modelClip != null) {
            this.canvas3d.disableModelClip(this.canvas3d.ctx);
            this.canvas3d.modelClip = null;
            this.canvas3d.canvasDirty |= 0x4000;
        }
        this.canvas3d.environmentSet = null;
    }

    boolean updateState(RenderBin rb, int geometryType) {
        boolean useAlpha = false;
        this.numActiveTexUnit = 0;
        this.lastActiveTexUnitIndex = 0;
        if (this.appearance != null) {
            AppearanceRetained app = (AppearanceRetained)this.appearance.retained;
            if (app.material != null) {
                app.material.updateNative(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                this.canvas3d.material = app.material;
                this.canvas3d.canvasDirty |= 8;
            } else if (this.canvas3d.material != null) {
                this.canvas3d.updateMaterial(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha);
                this.canvas3d.material = null;
                this.canvas3d.canvasDirty |= 8;
            }
            boolean useShaders = false;
            if (app instanceof ShaderAppearanceRetained) {
                ShaderProgramRetained spR = ((ShaderAppearanceRetained)app).shaderProgram;
                if (spR != null) {
                    spR.updateNative(this.canvas3d, true);
                    ShaderAttributeSetRetained sasR = ((ShaderAppearanceRetained)app).shaderAttributeSet;
                    if (sasR != null) {
                        sasR.updateNative(this.canvas3d, spR);
                    }
                    this.canvas3d.shaderProgram = spR;
                    useShaders = true;
                }
            } else if (this.canvas3d.shaderProgram != null) {
                this.canvas3d.shaderProgram.updateNative(this.canvas3d, false);
                this.canvas3d.shaderProgram = null;
                useShaders = false;
            }
            int availableTextureUnits = useShaders ? this.canvas3d.maxTextureImageUnits : this.canvas3d.maxTextureUnits;
            int prevNumActiveTexUnit = this.canvas3d.getNumActiveTexUnit();
            if (app.texUnitState != null) {
                int i;
                for (i = 0; i < app.texUnitState.length; ++i) {
                    TextureUnitStateRetained tus = app.texUnitState[i];
                    if (tus == null || !tus.isTextureEnabled()) continue;
                    this.lastActiveTexUnitIndex = i;
                    this.numActiveTexUnit = i + 1;
                    if (tus.texAttrs == null) continue;
                    useAlpha = useAlpha || tus.texAttrs.textureMode == 4;
                }
                if (this.numActiveTexUnit <= availableTextureUnits) {
                    for (i = 0; i < app.texUnitState.length && i < availableTextureUnits; ++i) {
                        if (app.texUnitState[i] != null && app.texUnitState[i].isTextureEnabled()) {
                            app.texUnitState[i].updateNative(i, this.canvas3d, false, false);
                            continue;
                        }
                        this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    }
                    for (i = app.texUnitState.length; i < prevNumActiveTexUnit; ++i) {
                        this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    }
                    this.canvas3d.setNumActiveTexUnit(this.numActiveTexUnit);
                } else {
                    for (i = 0; i < prevNumActiveTexUnit; ++i) {
                        this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    }
                    this.canvas3d.setNumActiveTexUnit(0);
                }
                this.canvas3d.activeTextureUnit(this.canvas3d.ctx, 0);
            } else {
                if (this.canvas3d.multiTexAccelerated) {
                    if (this.canvas3d.texUnitState != null) {
                        for (int i = 0; i < prevNumActiveTexUnit; ++i) {
                            TextureUnitStateRetained tur = this.canvas3d.texUnitState[i];
                            if (tur == null || tur.texture == null) continue;
                            this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                            this.canvas3d.texUnitState[i].texture = null;
                        }
                    }
                    this.canvas3d.activeTextureUnit(this.canvas3d.ctx, 0);
                }
                if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null && this.canvas3d.texUnitState[0].texture != app.texture) {
                    if (app.texture != null) {
                        app.texture.updateNative(this.canvas3d);
                        this.canvas3d.canvasDirty |= 0xC00;
                        this.numActiveTexUnit = 1;
                        this.lastActiveTexUnitIndex = 0;
                    } else {
                        this.numActiveTexUnit = 0;
                        this.canvas3d.resetTexture(this.canvas3d.ctx, -1);
                        this.canvas3d.canvasDirty |= 0xC00;
                    }
                    this.canvas3d.texUnitState[0].texture = app.texture;
                }
                this.canvas3d.setNumActiveTexUnit(this.numActiveTexUnit);
                if (app.texCoordGeneration != null) {
                    app.texCoordGeneration.updateNative(this.canvas3d);
                    this.canvas3d.canvasDirty |= 0xC00;
                    if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null) {
                        this.canvas3d.texUnitState[0].texGen = app.texCoordGeneration;
                    }
                } else if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null && this.canvas3d.texUnitState[0].texGen != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 0xC00;
                    this.canvas3d.texUnitState[0].texGen = app.texCoordGeneration;
                }
                if (app.textureAttributes != null) {
                    if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null) {
                        if (this.canvas3d.texUnitState[0].texture != null) {
                            app.textureAttributes.updateNative(this.canvas3d, false, this.canvas3d.texUnitState[0].texture.format);
                        } else {
                            app.textureAttributes.updateNative(this.canvas3d, false, 6);
                        }
                        this.canvas3d.canvasDirty |= 0xC00;
                        this.canvas3d.texUnitState[0].texAttrs = app.textureAttributes;
                    }
                } else if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null && this.canvas3d.texUnitState[0].texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 0xC00;
                    this.canvas3d.texUnitState[0].texAttrs = null;
                }
            }
            if (app.coloringAttributes != null) {
                app.coloringAttributes.updateNative(this.canvas3d.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
                this.canvas3d.canvasDirty |= 0x20;
                this.canvas3d.coloringAttributes = app.coloringAttributes;
            } else if (this.canvas3d.coloringAttributes != null) {
                this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                this.canvas3d.canvasDirty |= 0x20;
                this.canvas3d.coloringAttributes = null;
            }
            if (app.transparencyAttributes != null) {
                app.transparencyAttributes.updateNative(this.canvas3d.ctx, this.alpha, geometryType, this.polygonMode, this.lineAA, this.pointAA);
                this.canvas3d.canvasDirty |= 0x10;
                this.canvas3d.transparency = app.transparencyAttributes;
                if (!useAlpha) {
                    useAlpha = TransparencyAttributesRetained.useAlpha(app.transparencyAttributes);
                }
            } else {
                this.canvas3d.resetTransparency(this.canvas3d.ctx, geometryType, this.polygonMode, this.lineAA, this.pointAA);
                this.canvas3d.canvasDirty |= 0x10;
                this.canvas3d.transparency = null;
            }
            if (app.renderingAttributes != null) {
                this.ignoreVertexColors = app.renderingAttributes.ignoreVertexColors;
                app.renderingAttributes.updateNative(this.canvas3d, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
                this.canvas3d.canvasDirty |= 0xA00;
                this.canvas3d.renderingAttrs = app.renderingAttributes;
                useAlpha = useAlpha || app.renderingAttributes.alphaTestFunction != 0;
            } else {
                this.ignoreVertexColors = false;
                if (this.canvas3d.renderingAttrs != null) {
                    this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
                    this.canvas3d.canvasDirty |= 0xA00;
                    this.canvas3d.renderingAttrs = null;
                }
            }
            if (app.polygonAttributes != null) {
                app.polygonAttributes.updateNative(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 1;
                this.canvas3d.polygonAttributes = app.polygonAttributes;
            } else if (this.canvas3d.polygonAttributes != null) {
                this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 1;
                this.canvas3d.polygonAttributes = null;
            }
            if (app.lineAttributes != null) {
                app.lineAttributes.updateNative(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 2;
                this.canvas3d.lineAttributes = app.lineAttributes;
            } else if (this.canvas3d.lineAttributes != null) {
                this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 2;
                this.canvas3d.lineAttributes = null;
            }
            if (app.pointAttributes != null) {
                app.pointAttributes.updateNative(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 4;
                this.canvas3d.pointAttributes = app.pointAttributes;
            } else if (this.canvas3d.pointAttributes != null) {
                this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 4;
                this.canvas3d.pointAttributes = null;
            }
            this.canvas3d.appearance = app;
        } else if (this.canvas3d.appearance != null) {
            this.resetAppearance();
            this.canvas3d.appearance = null;
        }
        return useAlpha;
    }

    void initializeState() {
        int prevNumActiveTexUnit;
        this.canvas3d.setSceneAmbient(this.canvas3d.ctx, 0.0f, 0.0f, 0.0f);
        this.canvas3d.disableFog(this.canvas3d.ctx);
        this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, false, false);
        if (this.canvas3d.shaderProgram != null) {
            this.canvas3d.shaderProgram.updateNative(this.canvas3d, false);
            this.canvas3d.shaderProgram = null;
        }
        if ((prevNumActiveTexUnit = this.canvas3d.getNumActiveTexUnit()) > 0) {
            for (int i = 0; i < prevNumActiveTexUnit; ++i) {
                if (this.canvas3d.texUnitState[i].texture != null) {
                    this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    this.canvas3d.texUnitState[i].texture = null;
                }
                if (this.canvas3d.texUnitState[i].texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texAttrs = null;
                }
                if (this.canvas3d.texUnitState[i].texGen != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texGen = null;
                }
                this.canvas3d.texUnitState[i].mirror = null;
            }
            this.canvas3d.setNumActiveTexUnit(0);
        }
        this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
        this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
        this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
        this.canvas3d.resetTransparency(this.canvas3d.ctx, 4, 2, false, false);
        this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.canvas3d.updateMaterial(this.canvas3d.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    void resetAppearance() {
        int prevNumActiveTexUnit;
        if (this.canvas3d.material != null) {
            this.canvas3d.updateMaterial(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha);
            this.canvas3d.material = null;
            this.canvas3d.canvasDirty |= 8;
        }
        if (this.canvas3d.shaderProgram != null) {
            this.canvas3d.shaderProgram.updateNative(this.canvas3d, false);
            this.canvas3d.shaderProgram = null;
        }
        if ((prevNumActiveTexUnit = this.canvas3d.getNumActiveTexUnit()) > 0) {
            for (int i = 0; i < prevNumActiveTexUnit; ++i) {
                if (this.canvas3d.texUnitState[i].texture != null) {
                    this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    this.canvas3d.texUnitState[i].texture = null;
                }
                if (this.canvas3d.texUnitState[i].texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texAttrs = null;
                }
                if (this.canvas3d.texUnitState[i].texGen != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texGen = null;
                }
                this.canvas3d.texUnitState[i].mirror = null;
            }
            this.canvas3d.canvasDirty |= 0xC00;
            this.canvas3d.setNumActiveTexUnit(0);
        }
        if (this.canvas3d.coloringAttributes != null) {
            this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            this.canvas3d.coloringAttributes = null;
            this.canvas3d.canvasDirty |= 0x20;
        }
        if (this.canvas3d.transparency != null) {
            this.canvas3d.resetTransparency(this.canvas3d.ctx, 4, 2, this.lineAA, this.pointAA);
            this.canvas3d.transparency = null;
            this.canvas3d.canvasDirty |= 0x10;
        }
        if (this.canvas3d.renderingAttrs != null) {
            this.ignoreVertexColors = false;
            this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
            this.canvas3d.renderingAttrs = null;
            this.canvas3d.canvasDirty |= 0xA00;
        }
        if (this.canvas3d.polygonAttributes != null) {
            this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
            this.canvas3d.polygonAttributes = null;
            this.canvas3d.canvasDirty |= 1;
        }
        if (this.canvas3d.lineAttributes != null) {
            this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
            this.canvas3d.lineAttributes = null;
            this.canvas3d.canvasDirty |= 2;
        }
        if (this.canvas3d.pointAttributes != null) {
            this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
            this.canvas3d.pointAttributes = null;
            this.canvas3d.canvasDirty |= 4;
        }
    }

    void sendRenderMessage(boolean renderRun, int command, Object arg1, Object arg2) {
        J3dMessage renderMessage = new J3dMessage();
        renderMessage.threads = 16;
        renderMessage.type = 44;
        renderMessage.universe = null;
        renderMessage.view = null;
        renderMessage.args[0] = this.canvas3d;
        renderMessage.args[1] = GraphicsContext3D.getImmCommand(command);
        renderMessage.args[2] = arg1;
        renderMessage.args[3] = arg2;
        while (!this.canvas3d.view.inRenderThreadData) {
            MasterControl.threadYield();
        }
        this.canvas3d.screen.renderer.rendererStructure.addMessage(renderMessage);
        if (renderRun) {
            VirtualUniverse.mc.sendRunMessage(this.canvas3d.view, 16);
        } else {
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    void sendSoundMessage(int command, Object arg1, Object arg2) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null) {
            return;
        }
        J3dMessage soundMessage = new J3dMessage();
        soundMessage.threads = 2;
        soundMessage.type = 44;
        soundMessage.universe = this.canvas3d.view.universe;
        soundMessage.view = this.canvas3d.view;
        soundMessage.args[0] = GraphicsContext3D.getImmCommand(command);
        soundMessage.args[1] = arg1;
        soundMessage.args[2] = arg2;
        VirtualUniverse.mc.processMessage(soundMessage);
    }

    static Integer getImmCommand(int command) {
        if (commands[command] == null) {
            GraphicsContext3D.commands[command] = new Integer(command);
        }
        return commands[command];
    }

    synchronized void runMonitor(int action) {
        if (action == 0) {
            while (!this.gcReady) {
                ++this.waiting;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waiting;
            }
            this.gcReady = false;
        } else {
            this.gcReady = true;
            if (this.waiting > 0) {
                this.notify();
            }
        }
    }
}

