/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadataGroup;

public abstract class MultiscaleMetadata<T extends N5DatasetMetadata & SpatialMetadata>
implements SpatialMetadataGroup<T> {
    static final Predicate<String> scaleLevelPredicate = Pattern.compile("^s\\d+$").asPredicate();
    protected final String basePath;
    private final String[] paths;
    private final String[] units;
    protected final transient T[] childrenMetadata;

    public MultiscaleMetadata(String basePath, T[] childrenMetadata) {
        Objects.requireNonNull(basePath);
        Objects.requireNonNull(childrenMetadata);
        this.basePath = basePath;
        this.childrenMetadata = childrenMetadata;
        int N = childrenMetadata.length;
        this.paths = new String[N];
        this.units = new String[N];
        int i = 0;
        for (T meta : childrenMetadata) {
            Objects.requireNonNull(meta);
            this.paths[i] = meta.getPath();
            this.units[i] = ((SpatialMetadata)meta).unit();
            ++i;
        }
    }

    @Override
    public String getPath() {
        return this.basePath;
    }

    @Override
    public String[] getPaths() {
        return this.paths;
    }

    @Override
    public T[] getChildrenMetadata() {
        return this.childrenMetadata;
    }

    @Override
    public String[] units() {
        return this.units;
    }

    public static <T extends N5DatasetMetadata> boolean sortScaleMetadata(T[] metadataToBeSorted) {
        boolean allAreScaleSets = Arrays.stream(metadataToBeSorted).allMatch(x -> x.getName().matches("^s\\d+$"));
        if (!allAreScaleSets) {
            return false;
        }
        Arrays.sort(metadataToBeSorted, Comparator.comparingInt(s -> Integer.parseInt(s.getName().replaceAll("[^\\d]", ""))));
        return true;
    }
}

