/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.io.FileOutputStream;
import java.io.IOException;

public class LSS16_Writer
implements PlugIn {
    protected int lastNybble = -1;

    public void run(String arg) {
        int i;
        ImagePlus image = WindowManager.getCurrentImage();
        if (image == null) {
            IJ.error((String)"No image is open");
            return;
        }
        byte[] pixels = null;
        try {
            pixels = (byte[])image.getProcessor().getPixels();
        }
        catch (ClassCastException e) {
            IJ.error((String)"Can only handle 8-bit images");
            return;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        byte[] colors = new byte[256];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            colors[i2] = -1;
        }
        int currentColor = 0;
        for (i = 0; i < w * h; ++i) {
            int value = pixels[i] & 0xFF;
            if (colors[value] >= 0) continue;
            if (currentColor > 15) {
                IJ.error((String)"This image needs more than 16 colors.\nPlease convert to RGB and then to 8-bit Color, reducing the number of colors.");
                return;
            }
            colors[value] = (byte)currentColor++;
        }
        currentColor = 0;
        for (i = 0; i < colors.length; ++i) {
            if (colors[i] < 0) continue;
            colors[i] = (byte)currentColor++;
        }
        String name = image.getTitle();
        String path = arg;
        if (path == null || path.length() < 1) {
            SaveDialog sd = new SaveDialog("Save as LSS16", name, ".lss");
            String directory = sd.getDirectory();
            if (directory == null) {
                return;
            }
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            name = sd.getFileName();
            path = directory + name;
        }
        try {
            FileOutputStream out = new FileOutputStream(path);
            this.writeIntLE(out, 336851773);
            this.writeShortLE(out, w);
            this.writeShortLE(out, h);
            this.writeColorTable(out, colors, image.createLut());
            this.writeImage(out, w, h, pixels, colors);
            out.close();
        }
        catch (IOException e) {
            IJ.error((String)("Could not write to '" + path + "'"));
        }
    }

    protected void writeIntLE(FileOutputStream out, int i) throws IOException {
        out.write(i & 0xFF);
        out.write((i & 0xFF00) >> 8);
        out.write((i & 0xFF0000) >> 16);
        out.write((i & 0xFF000000) >> 24);
    }

    protected void writeShortLE(FileOutputStream out, int s) throws IOException {
        out.write(s & 0xFF);
        out.write((s & 0xFF00) >> 8);
    }

    protected void writeByte(FileOutputStream out, byte b) throws IOException {
        out.write(b & 0xFF);
    }

    protected void writeColor(FileOutputStream out, byte color) throws IOException {
        this.writeByte(out, (byte)((color & 0xFF) * 63 / 255));
    }

    protected void writeNybble(FileOutputStream out, int n) throws IOException {
        if (this.lastNybble < 0) {
            this.lastNybble = n;
            return;
        }
        this.writeByte(out, (byte)(n << 4 | this.lastNybble));
        this.lastNybble = -1;
    }

    protected void flushNybble(FileOutputStream out) throws IOException {
        if (this.lastNybble >= 0) {
            this.writeNybble(out, 0);
        }
    }

    protected void writeColorTable(FileOutputStream out, byte[] colors, LookUpTable lut) throws IOException {
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        int count = 0;
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] < 0) continue;
            this.writeColor(out, reds[i]);
            this.writeColor(out, greens[i]);
            this.writeColor(out, blues[i]);
            ++count;
        }
        while (count++ < 16) {
            this.writeByte(out, (byte)0);
            this.writeByte(out, (byte)0);
            this.writeByte(out, (byte)0);
        }
    }

    protected void writeImage(FileOutputStream out, int w, int h, byte[] pixels, byte[] colors) throws IOException {
        int k = 0;
        for (int j = 0; j < h; ++j) {
            byte last = 0;
            for (int i = 0; i < w; ++i) {
                int count;
                byte value = colors[pixels[k]];
                this.writeNybble(out, value);
                if (value != last) {
                    last = value;
                    ++k;
                    continue;
                }
                for (count = 1; i < w && colors[pixels[k++]] == value && count < 271; ++i, ++count) {
                }
                if (count < 16) {
                    this.writeNybble(out, count);
                    continue;
                }
                this.writeNybble(out, 0);
                this.writeNybble(out, (count -= 16) & 0xF);
                this.writeNybble(out, (count & 0xF0) >> 4);
            }
            this.flushNybble(out);
        }
    }
}

