/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;

public class N5SwingTreeNode
extends N5TreeNode
implements MutableTreeNode {
    private N5SwingTreeNode parent;
    private DefaultTreeModel treeModel;

    public N5SwingTreeNode(String path) {
        super(path);
    }

    public N5SwingTreeNode(String path, DefaultTreeModel model) {
        super(path);
        this.treeModel = model;
    }

    public N5SwingTreeNode(String path, N5SwingTreeNode parent) {
        super(path);
        this.parent = parent;
    }

    public N5SwingTreeNode(String path, N5SwingTreeNode parent, DefaultTreeModel model) {
        super(path);
        this.parent = parent;
        this.treeModel = model;
    }

    public Enumeration children() {
        return Collections.enumeration(this.childrenList());
    }

    public void add(N5SwingTreeNode child) {
        this.childrenList().add(child);
    }

    public N5SwingTreeNode addPath(String path) {
        String normPath = N5SwingTreeNode.removeLeadingSlash((String)path);
        if (!this.getPath().isEmpty() && !normPath.startsWith(this.getPath())) {
            return null;
        }
        if (this.getPath().equals(normPath)) {
            return this;
        }
        String relativePath = N5SwingTreeNode.removeLeadingSlash((String)normPath.replaceAll("^" + this.getPath(), ""));
        int sepIdx = relativePath.indexOf("/");
        String childName = sepIdx < 0 ? relativePath : relativePath.substring(0, sepIdx);
        N5TreeNode child = null;
        Stream<N5TreeNode> cs = this.childrenList().stream().filter(n -> n.getNodeName().equals(childName));
        Optional<N5TreeNode> copt = cs.findFirst();
        if (copt.isPresent()) {
            child = copt.get();
        } else {
            child = new N5SwingTreeNode(this.getPath().isEmpty() ? childName : this.getPath() + "/" + childName, this, this.treeModel);
            this.add(child);
            if (this.treeModel != null) {
                this.treeModel.nodesWereInserted(this, new int[]{this.childrenList().size() - 1});
            }
        }
        return (N5SwingTreeNode)child.addPath(normPath);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public N5SwingTreeNode getChildAt(int i) {
        return (N5SwingTreeNode)this.childrenList().get(i);
    }

    @Override
    public int getChildCount() {
        return this.childrenList().size();
    }

    @Override
    public int getIndex(TreeNode n) {
        return this.childrenList().indexOf(n);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() < 1;
    }

    public static void fromFlatList(N5SwingTreeNode root, String[] pathList, String groupSeparator) {
        HashMap<String, N5SwingTreeNode> pathToNode = new HashMap<String, N5SwingTreeNode>();
        String normalizedBase = N5SwingTreeNode.normalDatasetName(root.getPath(), groupSeparator);
        pathToNode.put(normalizedBase, root);
        Arrays.sort(pathList);
        String prefix = normalizedBase == groupSeparator ? "" : normalizedBase;
        for (String datasetPath : pathList) {
            String fullPath = prefix + groupSeparator + datasetPath;
            String parentPath = fullPath.substring(0, fullPath.lastIndexOf(groupSeparator));
            N5SwingTreeNode parent = (N5SwingTreeNode)pathToNode.get(parentPath);
            if (parent == null) {
                parent = new N5SwingTreeNode(parentPath);
                pathToNode.put(parentPath, parent);
            }
            N5SwingTreeNode node = new N5SwingTreeNode(fullPath, parent);
            pathToNode.put(fullPath, node);
            parent.add(node);
        }
    }

    private static String normalDatasetName(String fullPath, String groupSeparator) {
        return fullPath.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (child instanceof N5SwingTreeNode) {
            this.childrenList().add(index, (N5SwingTreeNode)child);
        }
    }

    @Override
    public void remove(int index) {
        this.childrenList().remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.childrenList().remove(node);
    }

    @Override
    public void removeFromParent() {
        this.parent.childrenList().remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        if (newParent instanceof N5SwingTreeNode) {
            this.parent = (N5SwingTreeNode)newParent;
        }
    }

    @Override
    public void setUserObject(Object object) {
    }
}

