/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jpedal.utils.LogWriter;

public class StatusBar {
    private int debug_level = 0;
    private int progress_size = 0;
    private String current = "";
    private int progress_max_size = 100;
    private JProgressBar status = null;
    private boolean showMessages = false;
    public float percentageDone = 0.0f;
    private Color masterColor = null;
    private Color childColor = null;

    public StatusBar() {
        this.initialiseStatus("");
    }

    public StatusBar(Color color) {
        this.masterColor = color;
        this.initialiseStatus("");
    }

    public final void initialiseStatus(String string) {
        this.progress_size = 0;
        this.status = new JProgressBar();
        if (this.masterColor != null) {
            this.status.setForeground(this.masterColor);
        }
        this.status.setStringPainted(true);
        this.status.setMaximum(this.progress_max_size);
        this.status.setMinimum(0);
        this.updateStatus(string, 4);
    }

    public final void updateStatus(String string, int n) {
        this.current = string;
        if (this.showMessages) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setString(StatusBar.this.current);
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
        if (this.debug_level > n) {
            LogWriter.writeLog(string);
        }
    }

    public final Component getStatusObject() {
        return this.status;
    }

    public final void setProgress(int n) {
        if (this.status != null) {
            if (n == 0) {
                this.progress_size = 0;
            }
            if (this.progress_size < n) {
                this.progress_size = n;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
    }

    public final void resetStatus(String string) {
        this.progress_size = 0;
        this.updateStatus(string, 4);
    }

    public final void setClientDisplay() {
        this.showMessages = true;
    }

    public void inSubroutine(boolean bl) {
        if (this.status != null) {
            if (bl) {
                if (this.childColor != null) {
                    this.status.setForeground(this.childColor);
                }
                this.resetStatus("Subroutine");
            } else {
                if (this.masterColor != null) {
                    this.status.setForeground(this.masterColor);
                }
                this.resetStatus("");
            }
        }
    }

    public void setColorForSubroutines(Color color) {
        this.childColor = color;
    }
}

