/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;

public abstract class LinkedAttributePathToken<T extends JsonElement>
implements Iterator<LinkedAttributePathToken<?>> {
    protected T parentJson;
    protected LinkedAttributePathToken<?> childToken;

    public abstract T getJsonType();

    public abstract JsonElement getOrCreateChildElement();

    public JsonElement writeChild(Gson gson, Object value) {
        if (this.childToken != null) {
            return this.getOrCreateChildElement();
        }
        this.writeValue(gson, value);
        return this.getChildElement();
    }

    public boolean jsonCompatible(JsonElement json) {
        return json == null || json.getClass() == this.getJsonType().getClass();
    }

    protected abstract void writeValue(Gson var1, Object var2);

    protected abstract void writeChildElement();

    protected abstract JsonElement getChildElement();

    protected JsonElement setAndCreateParentElement(JsonElement json) {
        this.parentJson = json == null || !this.jsonCompatible(json) ? ((JsonElement)this.getJsonType()).deepCopy() : json;
        return this.parentJson;
    }

    @Override
    public boolean hasNext() {
        return this.childToken != null;
    }

    @Override
    public LinkedAttributePathToken<?> next() {
        return this.childToken;
    }

    public static class ArrayAttributeToken
    extends LinkedAttributePathToken<JsonArray> {
        private static final JsonArray JSON_ARRAY = new JsonArray();
        private final int index;

        public ArrayAttributeToken(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "[" + this.getIndex() + "]";
        }

        @Override
        public JsonArray getJsonType() {
            return JSON_ARRAY;
        }

        @Override
        public JsonElement getOrCreateChildElement() {
            if (this.index >= ((JsonArray)this.parentJson).size() || this.childToken != null && !this.childToken.jsonCompatible(((JsonArray)this.parentJson).get(this.index))) {
                this.writeChildElement();
            }
            return ((JsonArray)this.parentJson).get(this.index);
        }

        @Override
        protected void writeChildElement() {
            if (this.childToken != null) {
                ArrayAttributeToken.fillArrayToIndex((JsonArray)this.parentJson, this.index, null);
                ((JsonArray)this.parentJson).set(this.index, ((JsonElement)this.childToken.getJsonType()).deepCopy());
            }
        }

        @Override
        protected JsonElement getChildElement() {
            return ((JsonArray)this.parentJson).get(this.index);
        }

        @Override
        protected void writeValue(Gson gson, Object value) {
            ArrayAttributeToken.fillArrayToIndex((JsonArray)this.parentJson, this.index, value);
            ((JsonArray)this.parentJson).set(this.index, gson.toJsonTree(value));
        }

        private static void fillArrayToIndex(JsonArray array, int index, Object value) {
            JsonElement fillValue = ArrayAttributeToken.valueRepresentsANumber(value) ? new JsonPrimitive(0) : JsonNull.INSTANCE;
            for (int i = array.size(); i <= index; ++i) {
                array.add(fillValue);
            }
        }

        private static boolean valueRepresentsANumber(Object value) {
            return value instanceof Number || value instanceof JsonPrimitive && ((JsonPrimitive)value).isNumber();
        }
    }

    public static class ObjectAttributeToken
    extends LinkedAttributePathToken<JsonObject> {
        private static final JsonObject JSON_OBJECT = new JsonObject();
        private final String key;

        public ObjectAttributeToken(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }

        @Override
        public JsonObject getJsonType() {
            return JSON_OBJECT;
        }

        @Override
        public JsonElement getOrCreateChildElement() {
            JsonElement childElement = ((JsonObject)this.parentJson).getAsJsonObject().get(this.key);
            if (!((JsonObject)this.parentJson).has(this.key) || this.childToken != null && !this.childToken.jsonCompatible(childElement)) {
                this.writeChildElement();
            }
            return this.getChildElement();
        }

        @Override
        protected JsonElement getChildElement() {
            return ((JsonObject)this.parentJson).get(this.key);
        }

        @Override
        protected void writeValue(Gson gson, Object value) {
            ((JsonObject)this.parentJson).add(this.key, gson.toJsonTree(value));
        }

        @Override
        protected void writeChildElement() {
            if (this.childToken != null) {
                ((JsonObject)this.parentJson).add(this.key, ((JsonElement)this.childToken.getJsonType()).deepCopy());
            }
        }
    }
}

