/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.widget;

import java.awt.Component;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.scijava.plugin.Plugin;
import org.scijava.ui.awt.widget.AWTInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.TextWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class AWTTextWidget
extends AWTInputWidget<String>
implements TextWidget<Panel>,
TextListener {
    private TextField textField;

    public String getValue() {
        return this.textField.getText();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        int columns = model.getItem().getColumnCount();
        this.textField = new TextField("", columns);
        this.textField.addTextListener(this);
        this.getComponent().add((Component)this.textField, "Center");
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isText() && !model.isMultipleChoice() && !model.isMessage();
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.updateModel();
    }

    public void doRefresh() {
        this.textField.setText(this.get().getValue().toString());
    }
}

