/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.List;

public class Chart
extends Component {
    private static final long serialVersionUID = 1L;
    private List<Point2D> data;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private boolean minXFixed;
    private boolean minYFixed;
    private boolean maxXFixed;
    private boolean maxYFixed;
    private double[] tickX = new double[20];
    private double[] tickY = new double[10];
    public static final int LEFT_OFFSET = 0;
    public static final int RIGHT_OFFSET = 0;
    public static final int TOP_OFFSET = 15;
    public static final int BOTTOM_OFFSET = 21;
    public static final int NO_TICKS_Y = 10;
    public static final int NO_TICKS_X = 20;
    public static final int TICK_SIZE = 2;
    public static final int DATA_PT_SIZE = 3;

    Point2D[] getMappedPoints(List<Point2D> data, int x, int y, int width, int height) {
        Point2D[] mappedPoints = new Point2D.Double[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            mappedPoints[i] = this.maxX - this.minX != 0.0 ? new Point2D.Double((double)x + (data.get(i).getX() - this.minX) / ((this.maxX - this.minX) * 1.0) * (double)width, (double)y + (1.0 - (data.get(i).getY() - this.minY) / ((this.maxY - this.minY) * 1.0)) * (double)height) : new Point2D.Double(x, (double)y + (1.0 - (data.get(i).getY() - this.minY) / ((this.maxY - this.minY) * 1.0)) * (double)height);
        }
        return mappedPoints;
    }

    public void setData(List<Point2D> data) {
        int i;
        this.data = data;
        if (data.size() != 0) {
            if (!this.minXFixed) {
                this.minX = this.data.get(0).getX();
            }
            if (!this.maxXFixed) {
                this.maxX = this.data.get(0).getX();
            }
            if (!this.minYFixed) {
                this.minY = 0.0;
            }
            if (!this.maxYFixed) {
                this.maxY = this.data.get(0).getY();
            }
            if (!(this.minXFixed && this.maxXFixed && this.maxYFixed)) {
                for (Point2D p : this.data) {
                    if (!this.minXFixed && p.getX() < this.minX) {
                        this.minX = p.getX();
                    } else if (!this.maxXFixed && p.getX() > this.maxX) {
                        this.maxX = p.getX();
                    }
                    if (this.maxYFixed || !(p.getY() > this.maxY)) continue;
                    this.maxY = p.getY();
                }
            }
        }
        double incY = (this.maxY - this.minY) / 9.0;
        double incX = (this.maxX - this.minX) / 19.0;
        double y = this.minY;
        double x = this.minX;
        for (i = 0; i < 10; ++i) {
            this.tickY[i] = (int)y;
            y += incY;
        }
        for (i = 0; i < 20; ++i) {
            this.tickX[i] = (int)x;
            x += incX;
        }
        this.tickX[19] = this.maxX;
        this.tickY[9] = this.maxY;
    }

    public Chart(List<Point2D> data) {
        this.setData(data);
    }

    public void draw(int x, int y, int width, int height, Graphics g, Color color) {
        if (this.isVisible()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle c = new Rectangle(x + 0, y + 15, width - 0 - 0, height - 15 - 21);
            g.drawLine(c.x, c.y - 20, c.x, c.y + c.height);
            g.drawLine(c.x, c.y + c.height, c.x + c.width, c.y + c.height);
            for (double dy = (double)(c.y + c.height); dy >= (double)(c.y - 1); dy -= (double)c.height / 10.0) {
                g.drawLine(c.x, (int)dy, c.x + 2, (int)dy);
            }
            for (double dx = (double)c.x; dx <= (double)(c.x + c.width + 1); dx += (double)c.width / 20.0) {
                g.drawLine((int)dx, c.y + c.height - 2, (int)dx, c.y + c.height);
            }
            if (this.data.size() != 0) {
                Point2D[] mappedPoints = this.getMappedPoints(this.data, c.x, c.y, c.width, c.height);
                g.setColor(color);
                for (int i = 0; i < mappedPoints.length - 1; ++i) {
                    g.drawLine((int)mappedPoints[i].getX(), (int)mappedPoints[i].getY(), (int)mappedPoints[i + 1].getX(), (int)mappedPoints[i + 1].getY());
                }
                g.setColor(Color.BLACK);
            }
        }
    }

    public void setMinX(double minX) {
        this.minX = minX;
        this.minXFixed = true;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
        this.maxXFixed = true;
    }

    public void setMinY(double minY) {
        this.minY = minY;
        this.minYFixed = true;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
        this.maxYFixed = true;
    }
}

