/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.calculator;

import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.operator.CalculatorOp;
import net.imagej.operator.CalculatorService;
import net.imagej.space.SpaceUtils;
import net.imagej.space.TypedSpace;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, iconPath="/icons/commands/calculator.png", menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Image Calculator...", weight=22.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class ImageCalculator<U extends RealType<U>, V extends RealType<V>>
extends ContextCommand {
    @Parameter
    private CalculatorService calculatorService;
    @Parameter
    private DatasetService datasetService;
    @Parameter(type=ItemIO.BOTH)
    private Dataset input1;
    @Parameter
    private Dataset input2;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset output;
    @Parameter(label="Operation to do between the two input images")
    private CalculatorOp<U, V> op;
    @Parameter(label="Create new window")
    private boolean newWindow = true;
    @Parameter(label="Floating point result")
    private boolean wantDoubles = false;

    public void run() {
        Img img = null;
        try {
            ImgPlus img1 = this.input1.getImgPlus();
            ImgPlus img2 = this.input2.getImgPlus();
            img = this.calculatorService.combine((Img)img1, (Img)img2, this.op);
        }
        catch (IllegalArgumentException e) {
            this.cancel(e.toString());
            return;
        }
        long[] span = new long[img.numDimensions()];
        img.dimensions(span);
        if (!this.wantDoubles && !this.newWindow) {
            this.output = null;
            this.copyDataInto((Img<? extends RealType<?>>)this.input1.getImgPlus(), (Img<? extends RealType<?>>)img, span);
            this.input1.update();
        } else {
            int bits = this.input1.getType().getBitsPerPixel();
            boolean floating = !this.input1.isInteger();
            boolean signed = this.input1.isSigned();
            if (this.wantDoubles) {
                bits = 64;
                floating = true;
                signed = true;
            }
            this.output = this.datasetService.create(span, "Result of operation", SpaceUtils.getAxisTypes((TypedSpace)this.input1), bits, signed, floating);
            this.copyDataInto((Img<? extends RealType<?>>)this.output.getImgPlus(), (Img<? extends RealType<?>>)img, span);
            this.output.update();
        }
    }

    public Dataset getInput1() {
        return this.input1;
    }

    public void setInput1(Dataset input1) {
        this.input1 = input1;
    }

    public Dataset getInput2() {
        return this.input2;
    }

    public void setInput2(Dataset input2) {
        this.input2 = input2;
    }

    public Dataset getOutput() {
        return this.output;
    }

    public CalculatorOp<U, V> getOperation() {
        return this.op;
    }

    public void setOperation(CalculatorOp<U, V> operation) {
        this.op = operation;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }

    public boolean isDoubleOutput() {
        return this.wantDoubles;
    }

    public void setDoubleOutput(boolean wantDoubles) {
        this.wantDoubles = wantDoubles;
    }

    private void copyDataInto(Img<? extends RealType<?>> out, Img<? extends RealType<?>> in, long[] span) {
        RandomAccess src = in.randomAccess();
        RandomAccess dst = out.randomAccess();
        HyperVolumePointSet ps = new HyperVolumePointSet(span);
        PointSetIterator iter = ps.iterator();
        long[] pos = null;
        while (iter.hasNext()) {
            pos = (long[])iter.next();
            src.setPosition(pos);
            dst.setPosition(pos);
            double value = ((RealType)src.get()).getRealDouble();
            ((RealType)dst.get()).setReal(value);
        }
    }
}

