/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Color;
import java.awt.Shape;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayService;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.OverlaySettings;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.scijava.display.Display;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.ui.awt.AWTColors;
import org.scijava.util.ColorRGB;
import org.scijava.util.IntCoords;
import org.scijava.util.MiscUtils;
import org.scijava.util.RealCoords;

public abstract class AbstractJHotDrawAdapter<O extends Overlay, F extends Figure>
extends AbstractRichPlugin
implements JHotDrawAdapter<F> {
    protected static final double[] SOLID_LINE_STYLE = null;
    protected static final double[] DASH_LINE_STYLE = new double[]{4.0, 4.0};
    protected static final double[] DOT_LINE_STYLE = new double[]{1.0, 2.0};
    protected static final double[] DOT_DASH_LINE_STYLE = new double[]{6.0, 2.0, 1.0, 2.0};
    @Parameter
    private OverlayService overlayService;
    private RealCoords down;
    private RealCoords drag;

    public abstract Shape toShape(F var1);

    @Override
    public void updateFigure(OverlayView view, F figure) {
        Overlay overlay = view.getData();
        ColorRGB lineColor = overlay.getLineColor();
        if (overlay.getLineStyle() != Overlay.LineStyle.NONE) {
            double[] dash_pattern;
            this.set(figure, AttributeKeys.STROKE_COLOR, AWTColors.getColor((ColorRGB)lineColor));
            this.set(figure, AttributeKeys.STROKE_WIDTH, overlay.getLineWidth());
            switch (overlay.getLineStyle()) {
                case SOLID: {
                    dash_pattern = SOLID_LINE_STYLE;
                    break;
                }
                case DASH: {
                    dash_pattern = DASH_LINE_STYLE;
                    break;
                }
                case DOT: {
                    dash_pattern = DOT_LINE_STYLE;
                    break;
                }
                case DOT_DASH: {
                    dash_pattern = DOT_DASH_LINE_STYLE;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported line style: " + (Object)((Object)overlay.getLineStyle()));
                }
            }
            this.set(figure, AttributeKeys.STROKE_DASHES, dash_pattern);
        } else {
            this.set(figure, AttributeKeys.STROKE_COLOR, new Color(0, 0, 0, 0));
        }
        ColorRGB fillColor = overlay.getFillColor();
        int alpha = overlay.getAlpha();
        this.set(figure, AttributeKeys.FILL_COLOR, AWTColors.getColor((ColorRGB)fillColor, (int)alpha));
        switch (overlay.getLineStartArrowStyle()) {
            case ARROW: {
                this.set(figure, AttributeKeys.START_DECORATION, new ArrowTip());
                break;
            }
            case NONE: {
                this.set(figure, AttributeKeys.START_DECORATION, null);
            }
        }
        switch (overlay.getLineEndArrowStyle()) {
            case ARROW: {
                this.set(figure, AttributeKeys.END_DECORATION, new ArrowTip());
                break;
            }
            case NONE: {
                this.set(figure, AttributeKeys.END_DECORATION, null);
            }
        }
    }

    @Override
    public void updateOverlay(F figure, OverlayView view) {
        Color strokeColor = (Color)figure.get(AttributeKeys.STROKE_COLOR);
        Overlay overlay = view.getData();
        overlay.setLineColor(AWTColors.getColorRGB((Color)strokeColor));
        overlay.setLineWidth((Double)figure.get(AttributeKeys.STROKE_WIDTH));
        Color fillColor = (Color)figure.get(AttributeKeys.FILL_COLOR);
        overlay.setFillColor(AWTColors.getColorRGB((Color)fillColor));
        overlay.setAlpha(fillColor.getAlpha());
    }

    @Override
    public void mouseDown(Display<?> d, int x, int y) {
        this.down = this.getDataCoords(d, x, y);
    }

    @Override
    public void mouseDrag(Display<?> d, int x, int y) {
        this.drag = this.getDataCoords(d, x, y);
        this.report(this.down, this.drag);
    }

    @Override
    public void report(RealCoords p1, RealCoords p2) {
    }

    protected void initDefaultSettings(F figure) {
        OverlaySettings settings = this.overlayService.getDefaultSettings();
        this.set(figure, AttributeKeys.STROKE_WIDTH, this.getDefaultLineWidth(settings));
        this.set(figure, AttributeKeys.FILL_COLOR, this.getDefaultFillColor(settings));
        this.set(figure, AttributeKeys.STROKE_COLOR, this.getDefaultStrokeColor(settings));
        this.set(figure, AttributeKeys.IS_STROKE_MITER_LIMIT_FACTOR, false);
    }

    private double getDefaultLineWidth(OverlaySettings settings) {
        return settings.getLineWidth();
    }

    private Color getDefaultStrokeColor(OverlaySettings settings) {
        ColorRGB color = settings.getLineColor();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b, 255);
    }

    private Color getDefaultFillColor(OverlaySettings settings) {
        ColorRGB color = settings.getFillColor();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = settings.getAlpha();
        return new Color(r, g, b, a);
    }

    private RealCoords getDataCoords(Display<?> d, int x, int y) {
        if (!(d instanceof ImageDisplay)) {
            return null;
        }
        ImageDisplay imageDisplay = (ImageDisplay)d;
        ImageCanvas canvas = imageDisplay.getCanvas();
        return canvas.panelToDataCoords(new IntCoords(x, y));
    }

    private <T> void set(F fig, AttributeKey<T> key, T value) {
        if (MiscUtils.equal(value, (Object)fig.get(key))) {
            return;
        }
        fig.set(key, value);
    }
}

