/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.listeners;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.scijava.listeners.ChangeListener;
import org.scijava.listeners.DefaultListenableVar;
import org.scijava.listeners.Listeners;

public interface ListenableVar<T, L> {
    public T get();

    public void set(T var1);

    public Listeners<L> listeners();

    public static <T> ListenableVar<T, ChangeListener> create(T value) {
        return new DefaultListenableVar<T, ChangeListener>(value, ChangeListener::valueChanged);
    }

    public static <T> ListenableVar<T, ChangeListener> create(T value, boolean notifyWhenSet) {
        return new DefaultListenableVar<T, ChangeListener>(value, ChangeListener::valueChanged, notifyWhenSet);
    }

    public static <T, L> ListenableVar<T, L> create(T value, Consumer<L> notify) {
        return new DefaultListenableVar<T, L>(value, notify);
    }

    public static <T, L> ListenableVar<T, L> create(T value, BiConsumer<L, T> notify) {
        return new DefaultListenableVar<T, L>(value, notify, false);
    }

    public static <T, L> ListenableVar<T, L> create(T value, Consumer<L> notify, boolean notifyWhenSet) {
        return new DefaultListenableVar<T, L>(value, notify, notifyWhenSet);
    }

    public static <T, L> ListenableVar<T, L> create(T value, BiConsumer<L, T> notify, boolean notifyWhenSet) {
        return new DefaultListenableVar<T, L>(value, notify, notifyWhenSet);
    }
}

