/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import mpicbg.models.NoninvertibleModelException;
import mpicbg.panorama.PanoramaCamera;
import mpicbg.panorama.Util;

public class EquirectangularProjection
extends PanoramaCamera<EquirectangularProjection> {
    private double lambdaPiScale = 0.0;
    private double phiPiScale = 0.0;
    private double minLambda = 0.0;
    private double minPhi = 0.0;

    public final double getLambdaPiScale() {
        return this.lambdaPiScale;
    }

    public final void setLambdaPiScale(double lambdaPiScale) {
        this.lambdaPiScale = lambdaPiScale;
    }

    public final double getPhiPiScale() {
        return this.phiPiScale;
    }

    public final void setPhiPiScale(double phiPiScale) {
        this.phiPiScale = phiPiScale;
    }

    public final double getMinLambda() {
        return this.minLambda;
    }

    public final void setMinLambda(double minLambda) {
        this.minLambda = minLambda;
    }

    public final double getMinPhi() {
        return this.minPhi;
    }

    public final void setMinPhi(double minPhi) {
        this.minPhi = minPhi;
    }

    public final double[] apply(double[] point) {
        assert (point.length == 2) : "2d projections can be applied to 2d points only.";
        double[] t = (double[])point.clone();
        this.applyInPlace(t);
        return t;
    }

    public final void applyInPlace(double[] point) {
        assert (point.length == 2) : "2d projections can be applied to 2d points only.";
        System.err.println("Not yet implemented.  Please feel free to do it yourself.");
    }

    public final double[] applyInverse(double[] point) throws NoninvertibleModelException {
        assert (point.length == 2) : "2d projections can be applied to 2d points only.";
        double[] t = (double[])point.clone();
        this.applyInPlace(t);
        return null;
    }

    public final void applyInverseInPlace(double[] point) throws NoninvertibleModelException {
        assert (point.length == 2) : "2d projections can be applied to 2d points only.";
        double x = (point[0] - 0.5 * this.targetWidth) / this.targetMaxSize;
        double y = (point[1] - 0.5 * this.targetHeight) / this.targetMaxSize;
        double t = 1.0 / Math.sqrt(x * x + y * y + this.f * this.f);
        double tx = t * x;
        double ty = t * y;
        double tz = t * this.f;
        double rx = this.i.m00 * tx + this.i.m01 * ty + this.i.m02 * tz;
        double ry = this.i.m10 * tx + this.i.m11 * ty + this.i.m12 * tz;
        double rz = this.i.m20 * tx + this.i.m21 * ty + this.i.m22 * tz;
        double tLambda = rz < 0.0 ? (Math.asin(-rx / Math.sqrt(rx * rx + rz * rz)) + Math.PI - this.minLambda) / Math.PI : (Math.asin(rx / Math.sqrt(rx * rx + rz * rz)) - this.minLambda) / Math.PI;
        point[0] = Util.mod(tLambda, 2.0);
        point[1] = (Math.asin(ry) - this.minPhi) / Math.PI + 0.5;
        point[0] = point[0] * this.lambdaPiScale;
        point[1] = point[1] * this.phiPiScale;
    }

    @Override
    public final EquirectangularProjection clone() {
        EquirectangularProjection c = new EquirectangularProjection();
        c.set(this);
        return c;
    }

    @Override
    public final void set(EquirectangularProjection e) {
        super.set(e);
        this.lambdaPiScale = e.lambdaPiScale;
        this.minLambda = e.minLambda;
        this.minPhi = e.minPhi;
        this.phiPiScale = e.phiPiScale;
    }

    public final String toString() {
        return "";
    }

    public final EquirectangularProjection createInverse() {
        EquirectangularProjection ict = new EquirectangularProjection();
        return ict;
    }
}

