/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.read.ConvertedRandomAccessible;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.MixedTransformView;

interface ViewNode {
    public ViewType viewType();

    public RandomAccessible<?> view();

    public Interval interval();

    default public BoundingBox bbox() {
        return this.interval() == null ? null : new BoundingBox(this.interval());
    }

    public static class ConverterViewNode<A, B>
    extends AbstractViewNode<RandomAccessible<B>> {
        private final Supplier<? extends B> destinationSupplier;
        private final Supplier<Converter<? super A, ? super B>> converterSupplier;

        ConverterViewNode(ConvertedRandomAccessibleInterval<A, B> view) {
            super(ViewType.CONVERTER, view);
            this.converterSupplier = view.getConverterSupplier();
            this.destinationSupplier = view.getDestinationSupplier();
        }

        ConverterViewNode(ConvertedRandomAccessible<A, B> view) {
            super(ViewType.CONVERTER, view);
            this.converterSupplier = view.getConverterSupplier();
            this.destinationSupplier = view.getDestinationSupplier();
        }

        public Supplier<? extends B> getDestinationSupplier() {
            return this.destinationSupplier;
        }

        public Supplier<Converter<? super A, ? super B>> getConverterSupplier() {
            return this.converterSupplier;
        }

        public String toString() {
            return "ConverterViewNode{viewType=" + (Object)((Object)this.viewType) + ", view=" + this.view + ", interval=" + this.interval + '}';
        }
    }

    public static class ExtensionViewNode
    extends AbstractViewNode<ExtendedRandomAccessibleInterval<?, ?>> {
        ExtensionViewNode(ExtendedRandomAccessibleInterval<?, ?> view) {
            super(ViewType.EXTENSION, view);
        }

        public OutOfBoundsFactory<?, ?> getOutOfBoundsFactory() {
            return ((ExtendedRandomAccessibleInterval)this.view).getOutOfBoundsFactory();
        }

        public String toString() {
            return "ExtensionViewNode{viewType=" + (Object)((Object)this.viewType) + ", view=" + this.view + ", interval=" + this.interval + ", oobFactory=" + this.getOutOfBoundsFactory() + '}';
        }
    }

    public static class MixedTransformViewNode
    extends AbstractViewNode<MixedTransformView<?>> {
        MixedTransformViewNode(MixedTransformView<?> view) {
            super(ViewType.MIXED_TRANSFORM, view);
        }

        public MixedTransform getTransformToSource() {
            return ((MixedTransformView)this.view).getTransformToSource();
        }

        public String toString() {
            return "MixedTransformViewNode{viewType=" + (Object)((Object)this.viewType) + ", view=" + this.view + ", interval=" + this.interval + ", transformToSource=" + this.getTransformToSource() + '}';
        }
    }

    public static class DefaultViewNode
    extends AbstractViewNode<RandomAccessible<?>> {
        DefaultViewNode(ViewType viewType, RandomAccessible<?> view) {
            super(viewType, view);
        }

        public String toString() {
            return "DefaultViewNode{viewType=" + (Object)((Object)this.viewType) + ", view=" + this.view + ", interval=" + this.interval + '}';
        }
    }

    public static abstract class AbstractViewNode<V extends RandomAccessible<?>>
    implements ViewNode {
        final ViewType viewType;
        final V view;
        final Interval interval;

        AbstractViewNode(ViewType viewType, V view) {
            this.viewType = viewType;
            this.view = view;
            this.interval = view instanceof Interval ? (Interval)view : null;
        }

        @Override
        public ViewType viewType() {
            return this.viewType;
        }

        @Override
        public RandomAccessible<?> view() {
            return this.view;
        }

        @Override
        public Interval interval() {
            return this.interval;
        }
    }

    public static enum ViewType {
        NATIVE_IMG,
        IDENTITY,
        INTERVAL,
        CONVERTER,
        MIXED_TRANSFORM,
        EXTENSION;

    }
}

