/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter.readwrite;

import java.util.function.Function;
import net.imglib2.Sampler;
import net.imglib2.converter.ColorChannelOrder;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.composite.Composite;

public class CompositeARGBSamplerConverter
implements SamplerConverter<Composite<UnsignedByteType>, ARGBType> {
    private final Function<Sampler<? extends Composite<UnsignedByteType>>, ? extends IntAccess> factory;

    public CompositeARGBSamplerConverter(ColorChannelOrder order) {
        this.factory = this.getAccessFactory(order);
    }

    private Function<Sampler<? extends Composite<UnsignedByteType>>, ? extends IntAccess> getAccessFactory(ColorChannelOrder order) {
        switch (order) {
            case ARGB: {
                return CompositeARGBAccess::new;
            }
            case RGB: {
                return CompositeRGBAccess::new;
            }
        }
        throw new IllegalArgumentException("Converter only supports ARGB and RGB channel order.");
    }

    @Override
    public ARGBType convert(Sampler<? extends Composite<UnsignedByteType>> sampler) {
        return new ARGBType(this.factory.apply(sampler));
    }

    private static final class CompositeRGBAccess
    implements IntAccess {
        private final Sampler<? extends Composite<UnsignedByteType>> sampler;

        public CompositeRGBAccess(Sampler<? extends Composite<UnsignedByteType>> sampler) {
            this.sampler = sampler;
        }

        @Override
        public int getValue(int index) {
            Composite<UnsignedByteType> composite = this.sampler.get();
            return -16777216 + (composite.get(0L).get() << 16) + (composite.get(1L).get() << 8) + composite.get(2L).get();
        }

        @Override
        public void setValue(int index, int value) {
            Composite<UnsignedByteType> composite = this.sampler.get();
            composite.get(0L).set(value >> 16);
            composite.get(1L).set(value >> 8);
            composite.get(2L).set(value);
        }
    }

    private static final class CompositeARGBAccess
    implements IntAccess {
        private final Sampler<? extends Composite<UnsignedByteType>> sampler;

        public CompositeARGBAccess(Sampler<? extends Composite<UnsignedByteType>> sampler) {
            this.sampler = sampler;
        }

        @Override
        public int getValue(int index) {
            Composite<UnsignedByteType> composite = this.sampler.get();
            return (composite.get(0L).get() << 24) + (composite.get(1L).get() << 16) + (composite.get(2L).get() << 8) + composite.get(3L).get();
        }

        @Override
        public void setValue(int index, int value) {
            Composite<UnsignedByteType> composite = this.sampler.get();
            composite.get(0L).set(value >> 24);
            composite.get(1L).set(value >> 16);
            composite.get(2L).set(value >> 8);
            composite.get(3L).set(value);
        }
    }
}

