/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.histogram;

import java.util.ArrayList;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.HistogramNd;
import net.imglib2.type.numeric.RealType;

public class Real1dBinMapper<T extends RealType<T>>
implements BinMapper1d<T> {
    private final long bins;
    private final double minVal;
    private final double maxVal;
    private final boolean tailBins;
    private final double binWidth;
    private final long interiorBins;

    public Real1dBinMapper(double minVal, double maxVal, long numBins, boolean tailBins) {
        this.bins = numBins;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.tailBins = tailBins;
        if (numBins <= 0L || tailBins && numBins <= 2L) {
            throw new IllegalArgumentException("invalid Real1dBinMapper: no data bins specified");
        }
        if (minVal > maxVal) {
            throw new IllegalArgumentException("invalid Real1dBinMapper: invalid data range specified (min > max)");
        }
        this.interiorBins = tailBins ? this.bins - 2L : this.bins;
        this.binWidth = minVal == maxVal ? 1.0 / (double)this.interiorBins : (maxVal - minVal) / (double)this.interiorBins;
    }

    @Override
    public long getBinCount() {
        return this.bins;
    }

    @Override
    public long map(T value) {
        long pos;
        double val = value.getRealDouble();
        if (val >= this.minVal && val <= this.maxVal) {
            double bin = (val - this.minVal) / this.binWidth;
            pos = (long)Math.floor(bin);
            if (pos >= this.interiorBins) {
                pos = this.interiorBins - 1L;
            }
            if (this.tailBins) {
                ++pos;
            }
        } else {
            pos = this.tailBins ? (val < this.minVal ? 0L : this.bins - 1L) : (val < this.minVal ? Long.MIN_VALUE : Long.MAX_VALUE);
        }
        return pos;
    }

    @Override
    public void getCenterValue(long binPos, T value) {
        value.setReal(this.center(binPos));
    }

    @Override
    public void getLowerBound(long binPos, T value) {
        value.setReal(this.min(binPos));
    }

    @Override
    public void getUpperBound(long binPos, T value) {
        value.setReal(this.max(binPos));
    }

    @Override
    public boolean includesLowerBound(long binPos) {
        return !this.tailBins || binPos != this.bins - 1L;
    }

    @Override
    public boolean includesUpperBound(long binPos) {
        return this.tailBins ? binPos >= this.bins - 2L : binPos == this.bins - 1L;
    }

    @Override
    public boolean hasTails() {
        return this.tailBins;
    }

    @Override
    public Real1dBinMapper<T> copy() {
        return new Real1dBinMapper<T>(this.minVal, this.maxVal, this.bins, this.tailBins);
    }

    public static <K extends RealType<K>> HistogramNd<K> histogramNd(double[] minVals, double[] maxVals, long[] numBins, boolean[] tailBins) {
        if (minVals.length != numBins.length || minVals.length != tailBins.length) {
            throw new IllegalArgumentException("multiDimMappers: differing input array sizes");
        }
        ArrayList binMappers = new ArrayList();
        for (int i = 0; i < minVals.length; ++i) {
            Real1dBinMapper mapper = new Real1dBinMapper(minVals[i], maxVals[i], numBins[i], tailBins[i]);
            binMappers.add(mapper);
        }
        return new HistogramNd(binMappers);
    }

    private double min(long pos) {
        if (pos < 0L || pos > this.bins - 1L) {
            throw new IllegalArgumentException("invalid bin position specified");
        }
        if (this.tailBins) {
            if (pos == 0L) {
                return Double.NEGATIVE_INFINITY;
            }
            if (pos == this.bins - 1L) {
                return this.maxVal;
            }
            return this.minVal + 1.0 * (double)(pos - 1L) / (double)(this.bins - 2L) * (this.maxVal - this.minVal);
        }
        return this.minVal + 1.0 * (double)pos / (double)this.bins * (this.maxVal - this.minVal);
    }

    private double max(long pos) {
        if (pos < 0L || pos > this.bins - 1L) {
            throw new IllegalArgumentException("invalid bin position specified");
        }
        if (this.tailBins) {
            if (pos == 0L) {
                return this.minVal;
            }
            if (pos == this.bins - 1L) {
                return Double.POSITIVE_INFINITY;
            }
            return this.minVal + 1.0 * (double)pos / (double)(this.bins - 2L) * (this.maxVal - this.minVal);
        }
        return this.minVal + 1.0 * (double)(pos + 1L) / (double)this.bins * (this.maxVal - this.minVal);
    }

    private double center(long pos) {
        return (this.min(pos) + this.max(pos)) / 2.0;
    }
}

