/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.neighborsearch;

import java.util.function.DoubleUnaryOperator;
import net.imglib2.KDTree;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.neighborsearch.RadialKDTreeInterpolator;
import net.imglib2.type.numeric.NumericType;

public class RadialKDTreeInterpolatorFactory<T extends NumericType<T>>
implements InterpolatorFactory<T, KDTree<T>> {
    protected final double maxRadius;
    protected final DoubleUnaryOperator squaredRadiusFunction;
    protected final T val;

    public RadialKDTreeInterpolatorFactory(DoubleUnaryOperator squaredRadiusFunction, double maxRadius, T t) {
        this.maxRadius = maxRadius;
        this.squaredRadiusFunction = squaredRadiusFunction;
        this.val = t;
    }

    @Override
    public RadialKDTreeInterpolator<T> create(KDTree<T> tree) {
        return new RadialKDTreeInterpolator<T>(tree, this.squaredRadiusFunction, this.maxRadius, this.val);
    }

    @Override
    public RealRandomAccess<T> create(KDTree<T> tree, RealInterval interval) {
        return this.create(tree);
    }
}

