/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.stack;

import java.lang.reflect.Array;
import java.util.List;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.util.Cast;

public class NearestNeighborRealRandomAccessibleStackInterpolator<T>
extends AbstractEuclideanSpace
implements RealRandomAccess<T> {
    protected final double[] position;
    protected final int sd = this.n - 1;
    protected RealRandomAccess<T> sliceAccess;
    protected final RealRandomAccessible<T>[] slices;
    protected final RealRandomAccess<T>[] sliceAccesses;
    protected int sliceIndex = 0;
    protected final int lastSliceIndex;

    public NearestNeighborRealRandomAccessibleStackInterpolator(RealRandomAccessible<T>[] slices) {
        super(slices[0].numDimensions() + 1);
        this.slices = slices;
        this.position = new double[this.n];
        this.sliceAccesses = new RealRandomAccess[slices.length];
        this.sliceAccesses[0] = slices[0].realRandomAccess();
        this.sliceAccess = this.sliceAccesses[0];
        this.lastSliceIndex = slices.length - 1;
    }

    public NearestNeighborRealRandomAccessibleStackInterpolator(List<RealRandomAccessible<T>> slices) {
        this((RealRandomAccessible[])slices.toArray((Object[])Cast.unchecked(Array.newInstance(RealRandomAccessible.class, slices.size()))));
    }

    protected NearestNeighborRealRandomAccessibleStackInterpolator(NearestNeighborRealRandomAccessibleStackInterpolator<T> a) {
        super(a.n);
        this.slices = a.slices;
        this.sliceAccesses = (RealRandomAccess[])Cast.unchecked(Array.newInstance(RealRandomAccess.class, a.sliceAccesses.length));
        this.sliceAccess = a.sliceAccess.copy();
        this.position = (double[])a.position.clone();
        this.sliceIndex = a.sliceIndex;
        this.sliceAccesses[this.sliceIndex] = this.sliceAccess;
        this.lastSliceIndex = this.sliceAccesses.length - 1;
    }

    protected int getSliceIndex(double position) {
        return Math.max(0, Math.min(this.lastSliceIndex, (int)Math.round(position)));
    }

    protected RealRandomAccess<T> getOrCreateAccess(int i) {
        RealRandomAccess<T> access = this.sliceAccesses[i];
        if (access == null) {
            this.sliceAccesses[i] = this.slices[i].realRandomAccess();
            return this.sliceAccesses[i];
        }
        return access;
    }

    protected void setSlice(int i) {
        if (i != this.sliceIndex) {
            this.sliceIndex = i;
            RealRandomAccess<T> access = this.getOrCreateAccess(i);
            access.setPosition(this.sliceAccess);
            this.sliceAccess = access;
        }
    }

    protected void updateSlice(int i) {
        this.sliceIndex = i;
        this.sliceAccess = this.getOrCreateAccess(i);
    }

    @Override
    public void localize(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = (float)this.position[d];
        }
    }

    @Override
    public void localize(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return (float)this.position[d];
    }

    @Override
    public double getDoublePosition(int d) {
        return this.position[d];
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
        if (d < this.sd) {
            this.sliceAccess.fwd(d);
        } else {
            this.setSlice(this.getSliceIndex(this.position[d]));
        }
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
        if (d < this.sd) {
            this.sliceAccess.bck(d);
        } else {
            this.setSlice(this.getSliceIndex(this.position[d]));
        }
    }

    @Override
    public void move(int distance, int d) {
        this.move((double)distance, d);
    }

    @Override
    public void move(long distance, int d) {
        this.move((double)distance, d);
    }

    @Override
    public void move(float distance, int d) {
        this.move((double)distance, d);
    }

    @Override
    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (d < this.sd) {
            this.sliceAccess.move(distance, d);
        } else {
            this.setSlice(this.getSliceIndex(this.position[d]));
        }
    }

    @Override
    public void move(RealLocalizable distance) {
        double sliceShift = distance.getDoublePosition(this.sd);
        if (sliceShift == 0.0) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            this.sliceAccess.move(distance);
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
            }
        }
    }

    @Override
    public void move(Localizable distance) {
        long sliceShift = distance.getLongPosition(this.sd);
        if (sliceShift == 0L) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            this.sliceAccess.move(distance);
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
            }
        }
    }

    @Override
    public void move(int[] distance) {
        int sliceShift = distance[this.sd];
        if (sliceShift == 0) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            this.sliceAccess.move(distance);
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
            }
        }
    }

    @Override
    public void move(long[] distance) {
        long sliceShift = distance[this.sd];
        if (sliceShift == 0L) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            this.sliceAccess.move(distance);
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
            }
        }
    }

    @Override
    public void move(double[] distance) {
        double sliceShift = distance[this.sd];
        if (sliceShift == 0.0) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance[d];
            }
            this.sliceAccess.move(distance);
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
            }
        }
    }

    @Override
    public void move(float[] distance) {
        float sliceShift = distance[this.sd];
        if (sliceShift == 0.0f) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            this.sliceAccess.move(distance);
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
            }
        }
    }

    @Override
    public void setPosition(Localizable position) {
        int newSliceIndex = this.getSliceIndex(position.getDoublePosition(this.sd));
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position.getDoublePosition(d);
        }
        this.sliceAccess.setPosition(this.position);
    }

    @Override
    public void setPosition(RealLocalizable position) {
        int newSliceIndex = this.getSliceIndex(position.getDoublePosition(this.sd));
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position.getDoublePosition(d);
        }
        this.sliceAccess.setPosition(this.position);
    }

    @Override
    public void setPosition(int[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
    }

    @Override
    public void setPosition(long[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
    }

    @Override
    public void setPosition(double[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
    }

    @Override
    public void setPosition(float[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
    }

    @Override
    public void setPosition(int pos, int d) {
        this.setPosition((double)pos, d);
    }

    @Override
    public void setPosition(long pos, int d) {
        this.setPosition((double)pos, d);
    }

    @Override
    public void setPosition(float pos, int d) {
        this.setPosition((double)pos, d);
    }

    @Override
    public void setPosition(double pos, int d) {
        this.position[d] = pos;
        if (d < this.sd) {
            this.sliceAccess.setPosition(pos, d);
        } else {
            this.setSlice(this.getSliceIndex(pos));
        }
    }

    @Override
    public T get() {
        return this.sliceAccess.get();
    }

    @Override
    public T getType() {
        return this.sliceAccesses[0].getType();
    }

    @Override
    public NearestNeighborRealRandomAccessibleStackInterpolator<T> copy() {
        return new NearestNeighborRealRandomAccessibleStackInterpolator<T>(this);
    }
}

