/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.transform.integer.AbstractMixedTransform;
import net.imglib2.transform.integer.ComponentMapping;

public class ComponentMappingTransform
extends AbstractMixedTransform
implements ComponentMapping,
Concatenable<ComponentMapping>,
PreConcatenable<ComponentMapping> {
    protected final int[] component;

    public ComponentMappingTransform(int targetDim) {
        super(targetDim);
        this.component = new int[targetDim];
        for (int d = 0; d < targetDim; ++d) {
            this.component[d] = d;
        }
    }

    public ComponentMappingTransform(int[] component) {
        super(component.length);
        this.component = (int[])component.clone();
    }

    @Override
    public void getComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            component[d] = this.component[d];
        }
    }

    @Override
    public int getComponentMapping(int d) {
        assert (d <= this.numTargetDimensions);
        return this.component[d];
    }

    public void setComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.component[d] = component[d];
        }
    }

    @Override
    public double[][] getMatrix() {
        double[][] mat = new double[this.numTargetDimensions + 1][this.numTargetDimensions + 1];
        mat[this.numTargetDimensions][this.numTargetDimensions] = 1.0;
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            mat[d][this.component[d]] = 1.0;
        }
        return mat;
    }

    @Override
    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = source[this.component[d]];
        }
    }

    @Override
    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = source[this.component[d]];
        }
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numTargetDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target.setPosition(source.getLongPosition(this.component[d]), d);
        }
    }

    public ComponentMappingTransform concatenate(ComponentMapping t) {
        assert (this.numTargetDimensions == t.numTargetDimensions());
        ComponentMappingTransform result = new ComponentMappingTransform(this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            result.component[d] = t.getComponentMapping(this.component[d]);
        }
        return result;
    }

    @Override
    public Class<ComponentMapping> getConcatenableClass() {
        return ComponentMapping.class;
    }

    public ComponentMappingTransform preConcatenate(ComponentMapping t) {
        assert (this.numTargetDimensions == t.numTargetDimensions());
        ComponentMappingTransform result = new ComponentMappingTransform(this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            result.component[d] = this.component[t.getComponentMapping(d)];
        }
        return result;
    }

    @Override
    public Class<ComponentMapping> getPreConcatenableClass() {
        return ComponentMapping.class;
    }
}

