/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.util.IntervalIndexer;

public final class RandomAccessibleIntervalCursor<T>
extends AbstractInterval
implements Cursor<T> {
    private final RandomAccess<T> randomAccess;
    private final long[] dimensions;
    private final long[] tmp;
    private long index;
    private final long maxIndex;
    private long maxIndexOnLine;

    public <I extends RandomAccessible<T> & Interval> RandomAccessibleIntervalCursor(I interval) {
        this(interval, interval);
    }

    public RandomAccessibleIntervalCursor(RandomAccessible<T> randomAccessible, Interval interval) {
        super(interval);
        this.randomAccess = randomAccessible.randomAccess();
        this.dimensions = new long[this.n];
        this.dimensions(this.dimensions);
        this.tmp = new long[this.n];
        long size = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            size *= this.dimensions[d];
        }
        this.maxIndex = size - 1L;
        this.reset();
    }

    protected RandomAccessibleIntervalCursor(RandomAccessibleIntervalCursor<T> cursor) {
        super(cursor);
        this.randomAccess = cursor.randomAccess.copy();
        this.dimensions = (long[])cursor.dimensions.clone();
        this.tmp = new long[this.n];
        this.index = cursor.index;
        this.maxIndex = cursor.maxIndex;
        this.maxIndexOnLine = cursor.maxIndexOnLine;
    }

    @Override
    public T get() {
        return this.randomAccess.get();
    }

    @Override
    public T getType() {
        return this.randomAccess.getType();
    }

    @Override
    public void jumpFwd(long steps) {
        this.index += steps;
        long l = this.index / this.dimensions[0];
        this.maxIndexOnLine = l < 0L ? l * this.dimensions[0] : (1L + l) * this.dimensions[0] - 1L;
        IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, this.tmp);
        this.randomAccess.setPosition(this.tmp);
    }

    @Override
    public void fwd() {
        if (++this.index > this.maxIndexOnLine) {
            this.nextLine();
        } else {
            this.randomAccess.fwd(0);
        }
    }

    private void nextLine() {
        this.randomAccess.setPosition(this.min[0], 0);
        this.maxIndexOnLine += this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            this.randomAccess.fwd(d);
            if (this.randomAccess.getLongPosition(d) <= this.max[d]) break;
            this.randomAccess.setPosition(this.min[d], d);
        }
    }

    @Override
    public void reset() {
        this.index = -1L;
        this.maxIndexOnLine = this.dimensions[0] - 1L;
        this.randomAccess.setPosition(this.min);
        this.randomAccess.bck(0);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    @Override
    public RandomAccessibleIntervalCursor<T> copy() {
        return new RandomAccessibleIntervalCursor<T>(this);
    }

    @Override
    public void localize(float[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.randomAccess.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.randomAccess.getDoublePosition(d);
    }

    @Override
    public void localize(int[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.randomAccess.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.randomAccess.getLongPosition(d);
    }
}

