/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import jRenderer3D.JRenderer3D;
import jRenderer3D.Line3D;
import jRenderer3D.Text3D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.MemoryImageSource;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Interactive_3D_Surface_Plot
implements PlugIn,
MouseListener,
MouseMotionListener,
ItemListener {
    private final String version = " v3.0.1 ";
    private final int DOTS = 0;
    private final int LINES = 1;
    private final int MESH = 2;
    private final int FILLED = 3;
    private final int ISOLINES = 4;
    private int plotType = 1;
    private final String DOTS_PLOT = "Dots";
    private final String LINES_PLOT = "Lines";
    private final String MESH_PLOT = "Mesh";
    private final String FILLED_PLOT = "Filled";
    private final String ISOLINES_PLOT = "Isolines";
    private static final int ORIGINAL = 0;
    private static final int GRAYSCALE = 1;
    private static final int SPECTRUM = 2;
    private static final int FIRE = 3;
    private static final int THERMAL = 4;
    private static final int GRADIENT = 5;
    private static final int BLUE = 6;
    private static final int ORANGE = 7;
    private int colorType = 0;
    private final String ORIGINAL_COLORS = "Original Colors";
    private final String GRAYSCALE_LUT = "Grayscale";
    private final String SPECTRUM_LUT = "Spectrum LUT";
    private final String FIRE_LUT = "Fire LUT";
    private final String THERMAL_LUT = "Thermal LUT";
    private final String GRADIENT_COLORS = "Gradient";
    private final String ORANGE_LUT = "Orange";
    private final String BLUE_LUT = "Blue";
    private JFrame frame;
    private JPanel mainPanel;
    private JPanel settingsPanel1;
    private JPanel settingsPanel2;
    private JComboBox comboDisplayType;
    private JComboBox comboDisplayColors;
    private JSlider sliderLight;
    private JSlider sliderGridSize;
    private JSlider sliderSmoothing;
    private JSlider sliderScale;
    private JSlider sliderZAspectRatio;
    private JSlider sliderPerspective;
    private JSlider sliderMin;
    private JSlider sliderMax;
    private JCheckBox checkInverse;
    private JCheckBox checkIsEqualxyzRatio;
    private ImageRegion imageRegion;
    private ImagePlus image;
    private JRenderer3D jRenderer3D;
    static final int SIZE = 600;
    private int windowWidth = 720;
    private int windowHeight = 600;
    private int startWindowWidth = this.windowWidth;
    private int startWindowHeight = this.windowHeight;
    private double scaleWindow = 1.0;
    private int xStart;
    private int yStart;
    private boolean drag;
    private int xdiff;
    private int ydiff;
    private double light = 0.2;
    private double smoothOld = 0.0;
    private boolean invertZ = false;
    private boolean isExamplePlot = false;
    private int imageWidth;
    private int imageHeight;
    private double scaleInit = 1.0;
    private double zRatioInit = 1.0;
    private double scaledWidth;
    private double scaledHeight;
    private double minVal;
    private double maxVal;
    private String units;
    private double maxDistance;
    private Calibration cal;
    private boolean isEqualxyzRatio = true;
    private double zAspectRatioSlider = 1.0;
    private double zAspectRatio = 1.0;
    private double scaleSlider = 1.0;
    private double minZ;
    private double maxZ;
    protected boolean draftDrawing = true;
    private int xloc;
    private int yloc;
    private int grid = 128;
    private double smooth = 3.0;
    private double perspective = 0.0;
    private boolean drawText = true;
    private boolean drawLegend = true;
    private boolean drawAxes = true;
    private boolean drawLines = true;
    private double rotationX = 65.0;
    private double rotationZ = 39.0;
    private boolean doReset = false;
    private int minSlider = 0;
    private int maxSlider = 100;
    private boolean snapshot = false;
    protected Color bgColor = Color.GRAY;
    protected Color lineColor = Color.WHITE;

    public static void main(String[] args) {
        Interactive_3D_Surface_Plot sp = new Interactive_3D_Surface_Plot();
        new ImageJ();
        IJ.open((String)"/Users/barthel/Pictures/Beispielbilder/calibration.tif");
        sp.image = IJ.getImage();
        sp.run("");
    }

    private void generateSampleImage() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        int[] pixels = new int[this.imageWidth * this.imageHeight];
        for (int y = 0; y < this.imageHeight; ++y) {
            int dy1 = y - 80;
            int dy2 = y - 60;
            for (int x = 0; x < this.imageWidth; ++x) {
                int dx1 = x - 90;
                int dx2 = x - 180;
                double r1 = Math.sqrt(dx1 * dx1 + dy1 * dy1) / 60.0;
                double r2 = Math.sqrt(dx2 * dx2 + dy2 * dy2) / 100.0;
                int v1 = (int)(255.0 * Math.exp(-r2 * r2));
                int v2 = (int)(255.0 * Math.exp(-r1 * r1));
                pixels[y * this.imageWidth + x] = 0xFF000000 | v2 + v1 << 16 | v2 << 8 | y / 4;
            }
        }
        MemoryImageSource source = new MemoryImageSource(this.imageWidth, this.imageHeight, pixels, 0, this.imageWidth);
        Image awtImage = Toolkit.getDefaultToolkit().createImage(source);
        BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        Graphics2D g2D = bufferedImage.createGraphics();
        g2D.drawImage(awtImage, 0, 0, null);
        float ninth = 0.11111111f;
        float[] blurKernel = new float[]{ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, blurKernel));
        bufferedImage = op.filter(bufferedImage, null);
        bufferedImage = op.filter(bufferedImage, null);
        g2D = bufferedImage.createGraphics();
        g2D.setColor(new Color(0x3300FF));
        Font font = new Font("Sans", 1, 60);
        g2D.setFont(font);
        g2D.drawString("ImageJ", 20, 220);
        bufferedImage = op.filter(bufferedImage, null);
        bufferedImage = op.filter(bufferedImage, null);
        g2D.dispose();
        this.image = new ImagePlus("Example Plot", (Image)bufferedImage);
        this.isExamplePlot = true;
    }

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.36b")) {
            return;
        }
        this.image = WindowManager.getCurrentImage();
        if (this.image != null) {
            Roi roi = this.image.getRoi();
            if (roi != null) {
                Rectangle rect = roi.getBounds();
                if (rect.x < 0) {
                    rect.x = 0;
                }
                if (rect.y < 0) {
                    rect.y = 0;
                }
                this.imageWidth = rect.width;
                this.imageHeight = rect.height;
                if (this.imageWidth == 0 || this.imageHeight == 0) {
                    this.image.killRoi();
                    this.imageWidth = this.image.getWidth();
                    this.imageHeight = this.image.getHeight();
                }
            } else {
                this.imageWidth = this.image.getWidth();
                this.imageHeight = this.image.getHeight();
            }
        } else {
            this.generateSampleImage();
        }
        this.runApplication(this.image.getTitle());
    }

    private void runApplication(String name) {
        String strFrame = "Interactive 3D Surface Plot v3.0.1  (" + name + ")";
        if (!this.doReset) {
            this.readPrefs();
        }
        String str = Macro.getOptions();
        try {
            if (str != null) {
                StringTokenizer ex1 = new StringTokenizer(str);
                String[] params = new String[]{"light=", "perspective=", "grid=", "smooth=", "plotType=", "colorType=", "drawAxes=", "drawLines=", "drawText=", "drawLegend=", "invertZ=", "isEqualxyzRatio=", "rotationX=", "rotationZ=", "scale=", "scaleZ=", "min=", "max=", "snapshot=", "backgroundColor=", "lineColor=", "windowHeight=", "windowWidth="};
                double[] paramVals = new double[]{this.light, this.perspective, this.grid, this.smooth, this.plotType, this.colorType, this.drawAxes ? 1.0 : 0.0, this.drawLines ? 1.0 : 0.0, this.drawText ? 1.0 : 0.0, this.drawLegend ? 1.0 : 0.0, this.invertZ ? 1.0 : 0.0, this.isEqualxyzRatio ? 1.0 : 0.0, this.rotationX, this.rotationZ, this.scaleSlider, this.zAspectRatioSlider, this.minSlider, this.maxSlider, this.snapshot ? 1.0 : 0.0, this.bgColor.getRGB(), this.lineColor.getRGB(), this.windowHeight, this.windowWidth};
                String errorString = null;
                while (ex1.hasMoreTokens()) {
                    boolean found = false;
                    str = ex1.nextToken();
                    for (int j = 0; j < params.length; ++j) {
                        String pattern = params[j];
                        if (str.lastIndexOf(pattern) > -1) {
                            int pos = str.lastIndexOf(pattern) + pattern.length();
                            paramVals[j] = pattern.equals("backgroundColor=") || pattern.equals("lineColor=") ? (double)Integer.parseInt(str.substring(pos), 16) : Double.parseDouble(str.substring(pos));
                            found = true;
                        }
                        if (found) continue;
                        errorString = str;
                    }
                    if (found) continue;
                    this.macroError(errorString);
                }
                this.light = Math.min(1.0, Math.max(0.0, paramVals[0]));
                this.perspective = Math.min(1.0, Math.max(0.0, paramVals[1]));
                this.grid = (int)Math.min(1024.0, Math.max(10.0, paramVals[2]));
                this.smooth = paramVals[3];
                this.plotType = (int)paramVals[4];
                this.colorType = (int)paramVals[5];
                this.drawAxes = paramVals[6] == 1.0;
                this.drawLines = paramVals[7] == 1.0;
                this.drawText = paramVals[8] == 1.0;
                this.drawLegend = paramVals[9] == 1.0;
                this.invertZ = paramVals[10] == 1.0;
                this.isEqualxyzRatio = paramVals[11] == 1.0;
                this.rotationX = paramVals[12];
                this.rotationZ = paramVals[13];
                this.scaleSlider = Math.min(3.0, Math.max(0.25, paramVals[14]));
                this.zAspectRatioSlider = Math.min(10.0, Math.max(0.1, paramVals[15]));
                this.minSlider = (int)Math.min(99.0, Math.max(0.0, paramVals[16]));
                this.maxSlider = (int)Math.min(100.0, Math.max(1.0, paramVals[17]));
                this.snapshot = paramVals[18] == 1.0;
                this.bgColor = new Color((int)paramVals[19]);
                this.lineColor = new Color((int)paramVals[20]);
                this.windowHeight = (int)paramVals[21];
                this.windowWidth = (int)paramVals[22];
            }
        }
        catch (NumberFormatException e1) {
            this.macroError(" Incorrect parameter ! ");
        }
        this.doReset = false;
        boolean batch = false;
        if (Interpreter.isBatchMode()) {
            batch = true;
        }
        this.setupImageRegion();
        if (!batch) {
            this.frame = new JFrame(strFrame);
            this.createGUI();
            this.frame.setLocation(this.xloc, this.yloc);
        }
        this.create3DRenderer();
        if (!batch) {
            this.frame.pack();
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Interactive_3D_Surface_Plot.this.writePrefs();
                    e.getWindow().dispose();
                }
            });
        }
        if (this.snapshot) {
            this.imageRegion.saveToImageJImage(this.image.getShortTitle());
            if (!batch) {
                this.frame.dispose();
            }
        }
    }

    private void macroError(String errorStr) {
        String str = "Error: \"" + errorStr + "\" \n \nValid macro parameters are:\n \nKeyword=Default    [Range]\n \nplotType=1              [0 .. 4]\ncolorType=0            [0 .. 7]\ndrawAxes=1            [0 / 1]\ndrawLines=1            [0 / 1]\ndrawText=1             [0 / 1]\ndrawLegend=1        [0 / 1]\ngrid=128                  [16 .. 1024]\nsmooth=0                [0 .. 100]\nperspective=0.1       [0 .. 1]\nlight=0.2                   [0 .. 1]\nisEqualxyzRatio=0   [0 / 1]\ninvertZ=0                  [0 / 1]\nrotationX=65           [-180 .. 180]\nrotationZ=-22.5      [-180 .. 180]\nscale=1                     [0.25 .. 3]\nscaleZ=1                   [0.1  .. 10]\nmax=100                 [1 .. 100]\nmin=0                       [0 .. 99]             \nsnapshot=0            [0 / 1]\nbackgroundColor=808080    [0 .. FFFFFF]\nlineColor=0                              [0 .. FFFFFF]\nwindowHeight=600\nwindowWidth=720  (depending on your screen)\n";
        IJ.showMessage((String)"Error in macro parameter list!", (String)str);
    }

    private void writePrefs() {
        Prefs.set((String)"ISP3D.xloc", (int)this.frame.getLocation().x);
        Prefs.set((String)"ISP3D.yloc", (int)this.frame.getLocation().y);
        Prefs.set((String)"ISP3D.light", (double)this.light);
        Prefs.set((String)"ISP3D.perspective", (double)this.perspective);
        Prefs.set((String)"ISP3D.grid", (int)this.grid);
        Prefs.set((String)"ISP3D.smooth", (double)this.smooth);
        Prefs.set((String)"ISP3D.plotType", (int)this.plotType);
        Prefs.set((String)"ISP3D.colorType", (int)this.colorType);
        Prefs.set((String)"ISP3D.drawAxes", (boolean)this.drawAxes);
        Prefs.set((String)"ISP3D.drawLines", (boolean)this.drawLines);
        Prefs.set((String)"ISP3D.drawText", (boolean)this.drawText);
        Prefs.set((String)"ISP3D.drawLegend", (boolean)this.drawLegend);
        Prefs.set((String)"ISP3D.invertZ", (boolean)this.invertZ);
        Prefs.set((String)"ISP3D.isEqualxyzRatio", (boolean)this.isEqualxyzRatio);
        Prefs.set((String)"ISP3D.rotationX", (double)this.rotationX);
        Prefs.set((String)"ISP3D.rotationZ", (double)this.rotationZ);
        Prefs.set((String)"ISP3D.windowHeight", (int)this.windowHeight);
        Prefs.set((String)"ISP3D.windowWidth", (int)this.windowWidth);
        Prefs.set((String)"ISP3D.scale", (double)this.scaleSlider);
        Prefs.set((String)"ISP3D.zScale", (double)this.zAspectRatioSlider);
        Prefs.set((String)"ISP3D.min", (int)this.minSlider);
        Prefs.set((String)"ISP3D.max", (int)this.maxSlider);
    }

    private void readPrefs() {
        if (this.isExamplePlot) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int screenWidth = screenSize.width;
            int screenHeight = screenSize.height;
            Insets ins = this.frame.getInsets();
            this.xloc = (screenWidth - this.windowWidth - ins.left - ins.right - 70) / 2;
            this.yloc = (screenHeight - this.windowHeight - ins.bottom - ins.top - 75) / 2;
            this.light = 0.2;
            this.perspective = 0.1;
            this.grid = 256;
            this.smooth = 6.0;
            this.plotType = 3;
            this.colorType = 5;
            this.drawAxes = true;
            this.drawLines = true;
            this.drawText = true;
            this.drawLegend = true;
            this.invertZ = false;
            this.isEqualxyzRatio = false;
            this.rotationX = 65.0;
            this.rotationZ = -22.5;
            this.scaleSlider = 1.0;
            this.zAspectRatioSlider = 1.0;
            this.minSlider = 0;
            this.maxSlider = 100;
        } else {
            this.xloc = (int)Prefs.get((String)"ISP3D.xloc", (double)100.0);
            this.yloc = (int)Prefs.get((String)"ISP3D.yloc", (double)50.0);
            this.light = Prefs.get((String)"ISP3D.light", (double)0.2);
            this.perspective = Prefs.get((String)"ISP3D.perspective", (double)0.0);
            this.grid = (int)Prefs.get((String)"ISP3D.grid", (double)256.0);
            this.smooth = Prefs.get((String)"ISP3D.smooth", (double)0.0);
            this.plotType = (int)Prefs.get((String)"ISP3D.plotType", (double)1.0);
            this.colorType = (int)Prefs.get((String)"ISP3D.colorType", (double)0.0);
            this.drawAxes = Prefs.get((String)"ISP3D.drawAxes", (boolean)true);
            this.drawLines = Prefs.get((String)"ISP3D.drawLines", (boolean)true);
            this.drawText = Prefs.get((String)"ISP3D.drawText", (boolean)true);
            this.drawLegend = Prefs.get((String)"ISP3D.drawLegend", (boolean)true);
            this.invertZ = Prefs.get((String)"ISP3D.invertZ", (boolean)false);
            this.isEqualxyzRatio = Prefs.get((String)"ISP3D.isEqualxyzRatio", (boolean)false);
            this.rotationX = Prefs.get((String)"ISP3D.rotationX", (double)65.0);
            this.rotationZ = Prefs.get((String)"ISP3D.rotationZ", (double)39.0);
            this.windowHeight = (int)Prefs.get((String)"ISP3D.windowHeight", (double)this.windowHeight);
            this.windowWidth = (int)Prefs.get((String)"ISP3D.windowWidth", (double)this.windowWidth);
            this.scaleSlider = Prefs.get((String)"ISP3D.scale", (double)this.scaleSlider);
            this.zAspectRatioSlider = Prefs.get((String)"ISP3D.zScale", (double)this.zAspectRatioSlider);
            this.minSlider = Math.min(Math.max((int)Prefs.get((String)"ISP3D.min", (double)this.minSlider), 0), 99);
            this.maxSlider = Math.min(Math.max((int)Prefs.get((String)"ISP3D.max", (double)this.maxSlider), 1), 100);
            this.bgColor = new Color((int)Prefs.get((String)"ISP3D.bgColor", (double)Color.GRAY.getRGB()));
            this.lineColor = new Color((int)Prefs.get((String)"ISP3D.lineColor", (double)Color.WHITE.getRGB()));
        }
    }

    private void create3DRenderer() {
        int gridWidth;
        int gridHeight;
        double wc = (double)this.imageWidth / 2.0;
        double hc = (double)this.imageHeight / 2.0;
        double dc = 128.0;
        this.cal = this.image.getCalibration();
        ImageProcessor ip = this.image.getProcessor();
        this.scaledWidth = this.cal.getX((double)this.imageWidth);
        this.scaledHeight = this.cal.getY((double)this.imageHeight);
        double min_ = ip.getMin();
        double max_ = ip.getMax();
        Calibration cal = this.image.getCalibration();
        if (cal != null && cal.calibrated() && (min_ = cal.getCValue((int)min_)) > (max_ = cal.getCValue((int)max_))) {
            double tmp = min_;
            min_ = max_;
            max_ = tmp;
        }
        this.minVal = min_;
        this.maxVal = max_;
        this.units = cal.getUnits();
        this.jRenderer3D = new JRenderer3D(wc, hc, dc);
        this.jRenderer3D.setBufferSize(this.windowWidth, this.windowHeight);
        this.setScaleAndZRatio();
        if (this.imageHeight > this.imageWidth) {
            gridHeight = this.grid;
            gridWidth = this.grid * this.imageWidth / this.imageHeight;
        } else {
            gridWidth = this.grid;
            gridHeight = this.grid * this.imageHeight / this.imageWidth;
        }
        this.jRenderer3D.setSurfacePlotGridSize(gridWidth, gridHeight);
        this.jRenderer3D.setAxes(this.drawAxes);
        this.jRenderer3D.setLines(this.drawLines);
        this.jRenderer3D.setText(this.drawText);
        this.jRenderer3D.setLegend(this.drawLegend);
        this.jRenderer3D.setSurfacePlot(this.image);
        this.jRenderer3D.surfacePlotSetInverse(this.invertZ);
        this.jRenderer3D.setTransformRotationXYZ(this.rotationX, 0.0, this.rotationZ);
        this.jRenderer3D.setSurfaceSmoothingFactor(this.smooth);
        this.jRenderer3D.setSurfacePlotLight(this.light);
        this.jRenderer3D.setSurfacePlotMinMax(this.minSlider, this.maxSlider);
        this.jRenderer3D.setBackgroundColor(this.bgColor.getRGB());
        this.setSurfaceColorType(this.colorType);
        this.setSurfacePlotType(this.plotType);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.renderAndUpdateDisplay();
    }

    private void setScaleAndZRatio() {
        if (this.isEqualxyzRatio) {
            this.zRatioInit = (this.maxVal - this.minVal) / (255.0 * this.scaledWidth / (double)this.imageWidth);
            this.scaleInit = 0.55 * (double)Math.max(this.startWindowHeight, this.startWindowWidth) / Math.max((double)this.imageWidth, Math.max(255.0 * this.zRatioInit, (double)this.imageHeight));
        } else {
            this.scaleInit = 0.55 * (double)Math.max(this.startWindowHeight, this.startWindowWidth) / (double)Math.max(this.imageHeight, this.imageWidth);
            this.zRatioInit = 0.55 * (double)this.startWindowHeight / (256.0 * this.scaleInit);
        }
        this.zAspectRatio = this.zRatioInit * this.zAspectRatioSlider;
        this.scaleWindow = (double)Math.min(this.windowHeight, this.windowWidth) / (double)this.startWindowHeight;
        this.jRenderer3D.setTransformZAspectRatio(this.zAspectRatio);
        double scale = this.scaleInit * this.scaleSlider * this.scaleWindow;
        this.jRenderer3D.setTransformScale(scale);
        this.jRenderer3D.setTransformPerspective(this.perspective);
        this.maxDistance = Math.max(this.scaledWidth, Math.max(this.scaledHeight, 256.0 * Math.max(this.zAspectRatio, 1.0)));
        this.jRenderer3D.setTransformMaxDistance(this.maxDistance);
        this.jRenderer3D.setLegendTextColor(this.lineColor);
        this.addCoordinateSystem();
    }

    private void addCoordinateSystem() {
        String s;
        double value;
        this.jRenderer3D.clearText();
        this.jRenderer3D.clearLines();
        this.jRenderer3D.clearCubes();
        int id = 256;
        this.minZ = this.minVal + (double)this.minSlider / 100.0 * (this.maxVal - this.minVal);
        this.maxZ = this.maxVal - (100.0 - (double)this.maxSlider) / 100.0 * (this.maxVal - this.minVal);
        this.jRenderer3D.setMinZValue(this.minZ);
        this.jRenderer3D.setMaxZValue(this.maxZ);
        double off = 16.0 / this.scaleInit;
        double fontSize = 12.0 / this.scaleInit;
        double offZ = off / this.zAspectRatio;
        int ticksDist = 40;
        Color textColor = this.lineColor;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double x2 = this.imageWidth;
        double y2 = this.imageHeight;
        double z2 = id;
        int numTicks = (int)Math.round((double)this.imageHeight * this.scaleInit / (double)ticksDist);
        double pos = 0.0;
        double stepValue = this.calcStepSize(this.scaledHeight, numTicks);
        for (value = 0.0; value <= this.scaledHeight; value += stepValue) {
            s = Math.floor(value) - value == 0.0 ? "" + (int)value : "" + (double)((int)Math.round(value * 1000.0)) / 1000.0;
            if (value + stepValue > this.scaledHeight || value == this.scaledHeight) {
                s = !this.units.equals("pixels") ? "y/" + this.units : "y";
            }
            y1 = y2 = (pos = value * (double)this.imageHeight / this.scaledHeight);
            this.jRenderer3D.addText3D(new Text3D(s, x1 - off, y1, z1 - offZ, textColor, fontSize, 2));
            this.jRenderer3D.addText3D(new Text3D(s, x2 + off, y2, z1 - offZ, textColor, fontSize));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x1, y1, z2, this.lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x2, y2, z1, x2, y2, z2, this.lineColor));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x2, y2, z1, this.lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z2, x2, y2, z2, this.lineColor));
        }
        numTicks = (int)Math.round((double)this.imageWidth * this.scaleInit / (double)ticksDist);
        stepValue = this.calcStepSize(this.scaledWidth, numTicks);
        y1 = 0.0;
        y2 = this.imageHeight;
        for (value = 0.0; value <= this.scaledWidth; value += stepValue) {
            s = Math.floor(value) - value == 0.0 ? "" + (int)value : "" + (double)((int)Math.round(value * 1000.0)) / 1000.0;
            if (value + stepValue > this.scaledWidth || value == this.scaledWidth) {
                s = !this.units.equals("pixels") ? "x/" + this.units : "x";
            }
            x1 = x2 = (pos = value * (double)this.imageWidth / this.scaledWidth);
            this.jRenderer3D.addText3D(new Text3D(s, x1, y1 - off, z1 - offZ, textColor, fontSize, 2));
            this.jRenderer3D.addText3D(new Text3D(s, x2, y2 + off, z1 - offZ, textColor, fontSize));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x1, y1, z2, this.lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x2, y2, z1, x2, y2, z2, this.lineColor));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x2, y2, z1, this.lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z2, x2, y2, z2, this.lineColor));
        }
        double d = this.maxZ - this.minZ;
        numTicks = (int)Math.round(255.0 * this.zAspectRatio * this.scaleInit / ((double)ticksDist / 1.3));
        if (numTicks < 2) {
            numTicks = 2;
        }
        stepValue = this.calcStepSize(d, numTicks);
        x1 = 0.0;
        y1 = 0.0;
        x2 = this.imageWidth;
        y2 = this.imageHeight;
        double minStart = Math.floor(this.minZ / stepValue) * stepValue;
        double delta = minStart - this.minZ;
        double value2 = 0.0;
        while (value2 + delta <= d) {
            String s2 = Math.floor(minStart + value2) - (minStart + value2) == 0.0 ? "" + (int)(minStart + value2) : "" + (double)((int)Math.round((minStart + value2) * 1000.0)) / 1000.0;
            pos = (value2 + delta) * (double)id / d;
            if (pos >= 0.0) {
                z1 = z2 = pos;
                if (this.invertZ) {
                    z1 = z2 = 255.0 - pos;
                }
                this.jRenderer3D.addText3D(new Text3D(s2, x1 - off, y1 - off, z1, textColor, fontSize, 4));
                this.jRenderer3D.addText3D(new Text3D(s2, x2 + off, y2 + off, z2, textColor, fontSize));
                this.jRenderer3D.addText3D(new Text3D(s2, x1 - off, y2 + off, z1, textColor, fontSize));
                this.jRenderer3D.addText3D(new Text3D(s2, x2 + off, y1 - off, z2, textColor, fontSize));
                this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x1, y2, z2, this.lineColor, true));
                this.jRenderer3D.addLine3D(new Line3D(x2, y1, z1, x2, y2, z2, this.lineColor));
                this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x2, y1, z2, this.lineColor, true));
                this.jRenderer3D.addLine3D(new Line3D(x1, y2, z1, x2, y2, z2, this.lineColor));
            }
            value2 += stepValue;
        }
        double myvalue = d + stepValue / 1.3;
        String mys = "  z";
        double fontzoom = 1.0;
        pos = (myvalue + delta) * (double)id / d;
        if (pos >= 0.0) {
            z1 = z2 = pos;
            if (this.invertZ) {
                z1 = z2 = 255.0 - pos;
            }
            this.jRenderer3D.addText3D(new Text3D(mys, x1 - off, y1 - off, z1, textColor, fontSize * fontzoom, 4));
            this.jRenderer3D.addText3D(new Text3D(mys, x2 + off, y2 + off, z2, textColor, fontSize * fontzoom));
            this.jRenderer3D.addText3D(new Text3D(mys, x1 - off, y2 + off, z1, textColor, fontSize * fontzoom));
            this.jRenderer3D.addText3D(new Text3D(mys, x2 + off, y1 - off, z2, textColor, fontSize * fontzoom));
        }
        this.jRenderer3D.add3DCube(0, 0, 0, this.imageWidth, this.imageHeight, id, this.lineColor);
    }

    double calcStepSize(double range, double targetSteps) {
        double tempStep = range / targetSteps;
        double mag = Math.floor(Math.log(tempStep) / Math.log(10.0));
        double magPow = Math.pow(10.0, mag);
        double magMsd = (int)(tempStep / magPow + 0.5);
        if (magMsd > 6.0) {
            magMsd = 10.0;
        } else if (magMsd > 3.0) {
            magMsd = 5.0;
        } else if (magMsd > 2.0) {
            magMsd = 4.0;
        } else if (magMsd > 1.0) {
            magMsd = 2.0;
        }
        return magMsd * magPow;
    }

    private void renderAndUpdateDisplay() {
        this.jRenderer3D.doRendering();
        if (this.imageRegion != null) {
            this.imageRegion.setImage(this.jRenderer3D);
            this.imageRegion.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion) {
            this.imageRegion.requestFocus();
            if (arg0.getClickCount() == 2) {
                this.jRenderer3D.setTransformRotationXYZ(0.0, 0.0, 0.0);
                this.renderAndUpdateDisplay();
            } else if (arg0.getClickCount() >= 3) {
                this.jRenderer3D.setTransformRotationXYZ(90.0, 0.0, 0.0);
                this.renderAndUpdateDisplay();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion) {
            this.xStart = arg0.getX();
            this.yStart = arg0.getY();
            this.xdiff = 0;
            this.ydiff = 0;
            this.drag = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.drag = false;
        this.setSurfacePlotType(this.plotType);
        this.setSurfaceColorType(this.colorType);
        this.jRenderer3D.setSurfacePlotLight(this.light);
        this.renderAndUpdateDisplay();
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion && this.drag) {
            if (this.draftDrawing) {
                this.jRenderer3D.setSurfacePlotMode(10);
            }
            int xAct = arg0.getX();
            int yAct = arg0.getY();
            this.xdiff = xAct - this.xStart;
            this.ydiff = yAct - this.yStart;
            this.xStart = xAct;
            this.yStart = yAct;
            this.jRenderer3D.changeTransformRotationXZ((double)(-this.ydiff) / 2.0, (double)this.xdiff / 2.0);
            this.rotationX = this.jRenderer3D.getTransformRotationX();
            this.rotationZ = this.jRenderer3D.getTransformRotationZ();
            this.renderAndUpdateDisplay();
            this.imageRegion.requestFocus();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private void setSurfacePlotType(int type) {
        if (type == 0) {
            this.jRenderer3D.setSurfacePlotMode(11);
        } else if (type == 1) {
            this.jRenderer3D.setSurfacePlotMode(12);
        } else if (type == 2) {
            this.jRenderer3D.setSurfacePlotMode(13);
        } else if (type == 4) {
            this.jRenderer3D.setSurfacePlotMode(15);
        } else if (type == 3) {
            this.jRenderer3D.setSurfacePlotMode(14);
        }
    }

    private void setSurfaceColorType(int type) {
        this.colorType = type;
        if (type == 0) {
            this.jRenderer3D.setSurfacePlotLut(50);
        } else if (type == 1) {
            this.jRenderer3D.setSurfacePlotLut(51);
        } else if (type == 2) {
            this.jRenderer3D.setSurfacePlotLut(52);
        } else if (type == 3) {
            this.jRenderer3D.setSurfacePlotLut(53);
        } else if (type == 4) {
            this.jRenderer3D.setSurfacePlotLut(54);
        } else if (type == 5) {
            this.jRenderer3D.setSurfacePlotLut(58);
        } else if (type == 7) {
            this.jRenderer3D.setSurfacePlotLut(55);
        } else if (type == 6) {
            this.jRenderer3D.setSurfacePlotLut(56);
        }
    }

    private void sliderChange(JSlider slider) {
        if (slider == this.sliderLight) {
            this.light = (double)this.sliderLight.getValue() / 100.0;
            this.jRenderer3D.setSurfacePlotLight(this.light);
            String str = "Lighting: " + this.light;
            this.setSliderTitle(this.sliderLight, Color.black, str);
        } else if (slider == this.sliderGridSize) {
            int gridWidth;
            int gridHeight;
            this.grid = 1 << this.sliderGridSize.getValue();
            if (this.imageHeight > this.imageWidth) {
                gridHeight = this.grid;
                gridWidth = this.grid * this.imageWidth / this.imageHeight;
            } else {
                gridWidth = this.grid;
                gridHeight = this.grid * this.imageHeight / this.imageWidth;
            }
            this.jRenderer3D.setSurfacePlotGridSize(gridWidth, gridHeight);
            this.smooth = (double)this.sliderSmoothing.getValue() * ((double)this.grid / 512.0);
            if (!slider.getValueIsAdjusting() || this.grid <= 256) {
                this.jRenderer3D.setSurfaceSmoothingFactor(this.smooth);
                this.smoothOld = this.smooth;
            }
            String str = "Grid Size: " + this.grid;
            this.setSliderTitle(this.sliderGridSize, Color.black, str);
            str = "Smoothing: " + (double)((int)(this.smooth * 100.0)) / 100.0;
            this.setSliderTitle(this.sliderSmoothing, Color.black, str);
        } else if (slider == this.sliderSmoothing) {
            this.grid = 1 << this.sliderGridSize.getValue();
            this.smooth = (double)this.sliderSmoothing.getValue() * ((double)this.grid / 512.0);
            if (!(this.smooth == this.smoothOld || slider.getValueIsAdjusting() && 1 << this.sliderGridSize.getValue() > 256)) {
                this.jRenderer3D.setSurfaceSmoothingFactor(this.smooth);
                this.smoothOld = this.smooth;
            }
            String str = "Smoothing: " + (double)((int)(this.smooth * 100.0)) / 100.0;
            this.setSliderTitle(this.sliderSmoothing, Color.black, str);
        } else if (slider == this.sliderScale) {
            this.scaleSlider = (double)this.sliderScale.getValue() / 100.0;
            String str = "Scale: " + (double)((int)(this.scaleSlider * 100.0)) / 100.0;
            this.setSliderTitle(this.sliderScale, Color.black, str);
            double scale = this.scaleInit * this.scaleWindow * this.scaleSlider;
            this.jRenderer3D.setTransformScale(scale);
        } else if (slider == this.sliderPerspective) {
            this.perspective = (double)this.sliderPerspective.getValue() / 100.0;
            this.jRenderer3D.setTransformPerspective(this.perspective);
            String str = "Perspective: " + this.perspective;
            this.setSliderTitle(this.sliderPerspective, Color.black, str);
        } else if (slider == this.sliderMin) {
            this.maxSlider = this.sliderMax.getValue();
            this.minSlider = this.sliderMin.getValue();
            if (this.minSlider >= this.maxSlider) {
                this.maxSlider = Math.min(100, this.minSlider + 1);
                this.sliderMax.setValue(this.maxSlider);
                this.sliderMax.repaint();
            }
            String str = "Min: " + this.minSlider + " %";
            this.setSliderTitle(this.sliderMin, Color.black, str);
            str = "Max: " + this.maxSlider + " %";
            this.setSliderTitle(this.sliderMax, Color.black, str);
            this.jRenderer3D.setSurfacePlotMinMax(this.minSlider, this.maxSlider);
            this.addCoordinateSystem();
        } else if (slider == this.sliderMax) {
            this.maxSlider = this.sliderMax.getValue();
            this.minSlider = this.sliderMin.getValue();
            if (this.maxSlider <= this.minSlider) {
                this.minSlider = Math.max(0, this.maxSlider - 1);
                this.sliderMin.setValue(this.minSlider);
                this.sliderMin.repaint();
            }
            String str = "Min: " + this.minSlider + " %";
            this.setSliderTitle(this.sliderMin, Color.black, str);
            str = "Max: " + this.maxSlider + " %";
            this.setSliderTitle(this.sliderMax, Color.black, str);
            this.jRenderer3D.setSurfacePlotMinMax(this.minSlider, this.maxSlider);
            this.addCoordinateSystem();
        } else if (slider == this.sliderZAspectRatio) {
            this.zAspectRatioSlider = Math.pow(10.0, (double)this.sliderZAspectRatio.getValue() / 100.0);
            String str = "z-Scale:" + IJ.d2s((double)this.zAspectRatioSlider, (int)2, (int)3);
            this.setSliderTitle(this.sliderZAspectRatio, Color.black, str);
            this.zAspectRatio = this.zAspectRatioSlider * this.zRatioInit;
            this.jRenderer3D.setTransformZAspectRatio(this.zAspectRatio);
            this.maxDistance = Math.max(this.scaledWidth, Math.max(this.scaledHeight, 256.0 * Math.max(this.zAspectRatio, 1.0)));
            this.jRenderer3D.setTransformMaxDistance(this.maxDistance);
            this.addCoordinateSystem();
        }
        this.renderAndUpdateDisplay();
    }

    public void resizeImagePanel(int width, int height) {
        if (this.jRenderer3D != null) {
            this.scaleWindow = (double)Math.min(width, height) / (double)this.startWindowHeight;
            this.jRenderer3D.setBufferSize(width, height);
            this.setScaleAndZRatio();
            this.renderAndUpdateDisplay();
        }
    }

    private void createGUI() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Interactive_3D_Surface_Plot.this.frame.dispose();
            }
        });
        this.mainPanel = this.createMainPanel();
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.setSize(this.windowWidth, this.windowHeight);
        this.frame.pack();
        this.frame.setResizable(true);
        this.frame.setVisible(true);
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Insets insetsFrame = Interactive_3D_Surface_Plot.this.frame.getInsets();
                Interactive_3D_Surface_Plot.this.windowWidth = Interactive_3D_Surface_Plot.this.frame.getWidth() - insetsFrame.left - insetsFrame.right - Interactive_3D_Surface_Plot.this.settingsPanel2.getWidth();
                Interactive_3D_Surface_Plot.this.windowHeight = Interactive_3D_Surface_Plot.this.frame.getHeight() - insetsFrame.bottom - insetsFrame.top - Interactive_3D_Surface_Plot.this.settingsPanel1.getHeight();
                if (Interactive_3D_Surface_Plot.this.windowHeight > 0 && Interactive_3D_Surface_Plot.this.windowWidth > 0) {
                    Interactive_3D_Surface_Plot.this.resizeImagePanel(Interactive_3D_Surface_Plot.this.windowWidth, Interactive_3D_Surface_Plot.this.windowHeight);
                }
                Interactive_3D_Surface_Plot.this.frame.pack();
            }
        });
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = this.createImagePanel();
        this.settingsPanel1 = this.createSettingsPanelTop();
        this.settingsPanel2 = this.createSettingsPanelRight();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.settingsPanel1, "North");
        mainPanel.add((Component)this.settingsPanel2, "East");
        mainPanel.add((Component)imagePanel, "Center");
        return mainPanel;
    }

    private void setupImageRegion() {
        this.imageRegion = new ImageRegion();
        this.imageRegion.setWidth(this.windowWidth);
        this.imageRegion.setHeight(this.windowHeight);
        this.imageRegion.addMouseListener(this);
        this.imageRegion.addMouseMotionListener(this);
        this.imageRegion.addKeyListener(new KeyAdapter(){
            private int number;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isShiftDown()) {
                    // empty if block
                }
                if (e.getKeyChar() == 's') {
                    ++this.number;
                    String str = Interactive_3D_Surface_Plot.this.image.getShortTitle() + " (" + this.number + ")";
                    Interactive_3D_Surface_Plot.this.imageRegion.saveToImageJImage(str);
                }
            }
        });
        this.imageRegion.requestFocus();
    }

    private JPanel createImagePanel() {
        this.imageRegion = new ImageRegion();
        this.imageRegion.setWidth(this.windowWidth);
        this.imageRegion.setHeight(this.windowHeight);
        this.imageRegion.addMouseListener(this);
        this.imageRegion.addMouseMotionListener(this);
        this.imageRegion.addKeyListener(new KeyAdapter(){
            private int number;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isShiftDown()) {
                    // empty if block
                }
                if (e.getKeyChar() == 's') {
                    ++this.number;
                    String str = Interactive_3D_Surface_Plot.this.image.getShortTitle() + " (" + this.number + ")";
                    Interactive_3D_Surface_Plot.this.imageRegion.saveToImageJImage(str);
                }
            }
        });
        this.imageRegion.requestFocus();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.imageRegion, "Center");
        return panel;
    }

    private JPanel createSettingsPanelTop() {
        Dimension comboDim = new Dimension(400, 25);
        Dimension sliderDim1 = new Dimension(400, 50);
        JPanel comboPanel = this.createComboPanel();
        comboPanel.setPreferredSize(comboDim);
        JPanel sliderPanel1 = this.createSliderPanel1();
        sliderPanel1.setPreferredSize(sliderDim1);
        this.settingsPanel1 = new JPanel();
        this.settingsPanel1.setLayout(new BorderLayout());
        this.settingsPanel1.add((Component)comboPanel, "North");
        this.settingsPanel1.add((Component)sliderPanel1, "South");
        return this.settingsPanel1;
    }

    private JPanel createSettingsPanelRight() {
        Dimension sliderDim2 = new Dimension(80, 400);
        JPanel sliderPanel2 = this.createSliderPanel2();
        sliderPanel2.setPreferredSize(sliderDim2);
        this.settingsPanel2 = new JPanel();
        this.settingsPanel2.setLayout(new BorderLayout());
        this.settingsPanel2.add((Component)sliderPanel2, "Center");
        return this.settingsPanel2;
    }

    void createComboDisplayColors() {
        this.comboDisplayColors = new JComboBox();
        this.comboDisplayColors.addItem("Original Colors");
        this.comboDisplayColors.addItem("Grayscale");
        this.comboDisplayColors.addItem("Spectrum LUT");
        this.comboDisplayColors.addItem("Fire LUT");
        this.comboDisplayColors.addItem("Thermal LUT");
        this.comboDisplayColors.addItem("Gradient");
        this.comboDisplayColors.addItem("Blue");
        this.comboDisplayColors.addItem("Orange");
        this.comboDisplayColors.setSelectedIndex(this.colorType);
        this.comboDisplayColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interactive_3D_Surface_Plot.this.setSurfaceColorType(Interactive_3D_Surface_Plot.this.comboDisplayColors.getSelectedIndex());
                Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
            }
        });
    }

    private JPanel createComboPanel() {
        this.comboDisplayType = new JComboBox();
        this.comboDisplayType.addItem("Dots");
        this.comboDisplayType.addItem("Lines");
        this.comboDisplayType.addItem("Mesh");
        this.comboDisplayType.addItem("Filled");
        this.comboDisplayType.addItem("Isolines");
        int selectedIndex = this.plotType;
        this.comboDisplayType.setSelectedIndex(selectedIndex);
        this.comboDisplayType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interactive_3D_Surface_Plot.this.plotType = Interactive_3D_Surface_Plot.this.comboDisplayType.getSelectedIndex();
                Interactive_3D_Surface_Plot.this.setSurfacePlotType(Interactive_3D_Surface_Plot.this.plotType);
                Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
            }
        });
        this.createComboDisplayColors();
        JButton saveButton = new JButton("Save Plot");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.imageRegion.saveToImageJImage(Interactive_3D_Surface_Plot.this.image.getShortTitle());
            }
        });
        JButton textureButton = new JButton("Load Texture");
        textureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.loadTextureImage();
            }
        });
        JButton maskImageButton = new JButton("Load Mask");
        maskImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.loadMaskImage();
            }
        });
        final JPopupMenu popup = new JPopupMenu();
        final JCheckBoxMenuItem menuItem1 = new JCheckBoxMenuItem("Axes");
        menuItem1.setSelected(this.drawAxes);
        menuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.drawAxes = menuItem1.isSelected();
                Interactive_3D_Surface_Plot.this.jRenderer3D.setAxes(Interactive_3D_Surface_Plot.this.drawAxes);
                Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
            }
        });
        popup.add(menuItem1);
        final JCheckBoxMenuItem menuItem2 = new JCheckBoxMenuItem("Lines");
        menuItem2.setSelected(this.drawLines);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.drawLines = menuItem2.isSelected();
                Interactive_3D_Surface_Plot.this.jRenderer3D.setLines(Interactive_3D_Surface_Plot.this.drawLines);
                Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
            }
        });
        popup.add(menuItem2);
        final JCheckBoxMenuItem menuItem3 = new JCheckBoxMenuItem("Text");
        menuItem3.setSelected(this.drawText);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.drawText = menuItem3.isSelected();
                Interactive_3D_Surface_Plot.this.jRenderer3D.setText(Interactive_3D_Surface_Plot.this.drawText);
                Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
            }
        });
        popup.add(menuItem3);
        final JCheckBoxMenuItem menuItem4 = new JCheckBoxMenuItem("Legend");
        menuItem4.setSelected(this.drawLegend);
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.drawLegend = menuItem4.isSelected();
                Interactive_3D_Surface_Plot.this.jRenderer3D.setLegend(Interactive_3D_Surface_Plot.this.drawLegend);
                Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
            }
        });
        popup.add(menuItem4);
        final JCheckBoxMenuItem menuItem5 = new JCheckBoxMenuItem("Fast drawing on drag");
        menuItem5.setSelected(true);
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.draftDrawing = menuItem5.isSelected();
            }
        });
        popup.add(menuItem5);
        JMenuItem menuItem6 = new JMenuItem("Reset everything");
        menuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.frame.dispose();
                Interactive_3D_Surface_Plot.this.doReset = true;
                Interactive_3D_Surface_Plot.this.light = 0.2;
                Interactive_3D_Surface_Plot.this.perspective = 0.0;
                Interactive_3D_Surface_Plot.this.grid = 256;
                Interactive_3D_Surface_Plot.this.smooth = 3.0;
                Interactive_3D_Surface_Plot.this.plotType = 3;
                Interactive_3D_Surface_Plot.this.colorType = 0;
                Interactive_3D_Surface_Plot.this.drawAxes = true;
                Interactive_3D_Surface_Plot.this.drawLines = true;
                Interactive_3D_Surface_Plot.this.drawText = true;
                Interactive_3D_Surface_Plot.this.drawLegend = true;
                Interactive_3D_Surface_Plot.this.invertZ = false;
                Interactive_3D_Surface_Plot.this.isEqualxyzRatio = false;
                Interactive_3D_Surface_Plot.this.rotationX = 65.0;
                Interactive_3D_Surface_Plot.this.rotationZ = 39.0;
                Interactive_3D_Surface_Plot.this.startWindowHeight = (Interactive_3D_Surface_Plot.this.windowHeight = 600);
                Interactive_3D_Surface_Plot.this.startWindowWidth = (Interactive_3D_Surface_Plot.this.windowWidth = 720);
                Interactive_3D_Surface_Plot.this.scaleSlider = 1.0;
                Interactive_3D_Surface_Plot.this.zAspectRatioSlider = 1.0;
                Interactive_3D_Surface_Plot.this.minSlider = 0;
                Interactive_3D_Surface_Plot.this.maxSlider = 100;
                Interactive_3D_Surface_Plot.this.lineColor = Color.WHITE;
                Interactive_3D_Surface_Plot.this.bgColor = Color.GRAY;
                Interactive_3D_Surface_Plot.this.run("");
            }
        });
        popup.add(menuItem6);
        final JButton optionsButton = new JButton("Display Options");
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.show(optionsButton, 30, 22);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 6, 0, 0));
        panel.add(this.comboDisplayType);
        panel.add(this.comboDisplayColors);
        panel.add(textureButton);
        panel.add(maskImageButton);
        panel.add(saveButton);
        panel.add(optionsButton);
        return panel;
    }

    private void loadTextureImage() {
        JFileChooser fc;
        ImagePlus impTexture = null;
        int[] wList = WindowManager.getIDList();
        boolean loadFromDisk = false;
        if (wList == null) {
            loadFromDisk = true;
        } else {
            String[] titles = new String[wList.length + 1];
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage((int)wList[i]);
                titles[i] = imp != null ? imp.getTitle() : "";
            }
            titles[wList.length] = "\"Load File from Disk\"";
            GenericDialog gd = new GenericDialog("Load texture", (Frame)IJ.getInstance());
            gd.addMessage("Please select an Image to be used as texture");
            String defaultItem = titles[0];
            gd.addChoice("Open Image:", titles, defaultItem);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int index = gd.getNextChoiceIndex();
            if (titles[index].equals("\"Load File from Disk\"")) {
                loadFromDisk = true;
            } else {
                impTexture = WindowManager.getImage((int)wList[index]);
            }
        }
        if (loadFromDisk && (fc = new JFileChooser()).showOpenDialog(null) == 0) {
            String str = fc.getSelectedFile().getPath();
            try {
                IJ.run((String)"Open...", (String)("path='" + str + "'"));
                impTexture = WindowManager.getCurrentImage();
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(null, "Error opening Image", "", -1);
                return;
            }
        }
        if (impTexture != null) {
            this.jRenderer3D.setSurfacePlotTexture(impTexture);
            this.setSurfacePlotType(this.plotType);
            this.jRenderer3D.setSurfacePlotLight(this.light);
            this.minSlider = this.sliderMin.getValue();
            this.maxSlider = this.sliderMax.getValue();
            this.jRenderer3D.setSurfacePlotMinMax(this.minSlider, this.maxSlider);
            this.jRenderer3D.surfacePlotSetInverse(this.invertZ);
            this.grid = 1 << this.sliderGridSize.getValue();
            this.smooth = (double)this.sliderSmoothing.getValue() * ((double)this.grid / 512.0);
            if (this.smooth < 1.0) {
                this.smooth = 0.0;
            }
            this.jRenderer3D.setSurfaceSmoothingFactor(this.smooth);
            this.smoothOld = this.smooth;
            this.setSurfaceColorType(0);
            this.comboDisplayColors.setSelectedIndex(0);
            this.renderAndUpdateDisplay();
        }
    }

    private void loadMaskImage() {
        JFileChooser fc;
        ImagePlus impMask = null;
        int[] wList = WindowManager.getIDList();
        boolean loadFromDisk = false;
        if (wList == null) {
            loadFromDisk = true;
        } else {
            String[] titles = new String[wList.length + 1];
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage((int)wList[i]);
                titles[i] = imp != null ? imp.getTitle() : "";
            }
            titles[wList.length] = "\"Load File from Disk\"";
            GenericDialog gd = new GenericDialog("Load mask image", (Frame)IJ.getInstance());
            gd.addMessage("Please select an image to be used as a mask image.");
            String defaultItem = titles[0];
            gd.addChoice("Open Image:", titles, defaultItem);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int index = gd.getNextChoiceIndex();
            if (titles[index].equals("\"Load File from Disk\"")) {
                loadFromDisk = true;
            } else {
                impMask = WindowManager.getImage((int)wList[index]);
            }
        }
        if (loadFromDisk && (fc = new JFileChooser()).showOpenDialog(null) == 0) {
            String str = fc.getSelectedFile().getPath();
            try {
                IJ.run((String)"Open...", (String)("path='" + str + "'"));
                impMask = WindowManager.getCurrentImage();
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(null, "Error opening Image", "", -1);
                return;
            }
        }
        if (impMask != null) {
            this.jRenderer3D.setSurfacePlotMask(impMask);
            this.setSurfacePlotType(this.plotType);
            this.jRenderer3D.setSurfacePlotLight(this.light);
            this.minSlider = this.sliderMin.getValue();
            this.maxSlider = this.sliderMax.getValue();
            this.jRenderer3D.setSurfacePlotMinMax(this.minSlider, this.maxSlider);
            this.jRenderer3D.surfacePlotSetInverse(this.invertZ);
            this.grid = 1 << this.sliderGridSize.getValue();
            this.smooth = (double)this.sliderSmoothing.getValue() * ((double)this.grid / 512.0);
            if (this.smooth < 1.0) {
                this.smooth = 0.0;
            }
            this.jRenderer3D.setSurfaceSmoothingFactor(this.smooth);
            this.smoothOld = this.smooth;
            this.setSurfaceColorType(this.colorType);
            this.comboDisplayColors.setSelectedIndex(this.colorType);
            this.renderAndUpdateDisplay();
        }
    }

    private JPanel createSliderPanel1() {
        String str = "Grid Size: " + this.grid;
        int gridSliderValue = (int)Math.round(Math.log(this.grid) / Math.log(2.0));
        gridSliderValue = Math.min(9, Math.max(5, gridSliderValue));
        this.sliderGridSize = this.createSliderHorizontal(str, 5, 10, gridSliderValue);
        str = "Smoothing: " + (double)((int)Math.round(this.smooth * 100.0)) / 100.0;
        int smoothSliderValue = (int)(this.smooth * (double)(512 / this.grid));
        smoothSliderValue = Math.min(100, Math.max(0, smoothSliderValue));
        this.sliderSmoothing = this.createSliderHorizontal(str, 0, 100, smoothSliderValue);
        str = "Perspective: " + (double)((int)Math.round(this.perspective * 100.0)) / 100.0;
        this.sliderPerspective = this.createSliderHorizontal(str, 0, 100, (int)(this.perspective * 100.0));
        int light_ = (int)Math.round(this.light * 100.0);
        this.sliderLight = this.createSliderHorizontal("Lighting: " + (double)light_ / 100.0, 0, 100, light_);
        JPanel miniPanel = new JPanel();
        miniPanel.setLayout(new GridLayout(2, 1, 0, 3));
        this.checkIsEqualxyzRatio = new JCheckBox("z = xy Ratio");
        this.checkIsEqualxyzRatio.setFont(new Font("Sans", 0, 11));
        this.checkIsEqualxyzRatio.setSelected(this.isEqualxyzRatio);
        this.checkIsEqualxyzRatio.addItemListener(this);
        this.checkInverse = new JCheckBox("Invert");
        this.checkInverse.setFont(new Font("Sans", 0, 11));
        this.checkInverse.setSelected(this.invertZ);
        this.checkInverse.addItemListener(this);
        JButton buttonBackgroundColor = new JButton("Background");
        buttonBackgroundColor.setFont(new Font("Sans", 0, 11));
        buttonBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.bgColor = JColorChooser.showDialog(null, "Choose background color", null);
                if (Interactive_3D_Surface_Plot.this.bgColor != null) {
                    Interactive_3D_Surface_Plot.this.jRenderer3D.setBackgroundColor(Interactive_3D_Surface_Plot.this.bgColor.getRGB());
                    Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
                }
            }
        });
        JButton buttonLineColor = new JButton("Line Color");
        buttonLineColor.setFont(new Font("Sans", 0, 11));
        buttonLineColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.lineColor = JColorChooser.showDialog(null, "Choose line & text color", null);
                if (Interactive_3D_Surface_Plot.this.lineColor != null) {
                    Interactive_3D_Surface_Plot.this.jRenderer3D.setLegendTextColor(Interactive_3D_Surface_Plot.this.lineColor);
                    Interactive_3D_Surface_Plot.this.addCoordinateSystem();
                    Interactive_3D_Surface_Plot.this.renderAndUpdateDisplay();
                }
            }
        });
        miniPanel.add(this.checkIsEqualxyzRatio);
        miniPanel.add(this.checkInverse);
        miniPanel.add(buttonBackgroundColor);
        miniPanel.add(buttonLineColor);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 5));
        panel.add(this.sliderGridSize);
        panel.add(this.sliderSmoothing);
        panel.add(this.sliderPerspective);
        panel.add(this.sliderLight);
        panel.add(miniPanel);
        return panel;
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkInverse) {
            this.invertZ = this.checkInverse.isSelected();
            this.jRenderer3D.surfacePlotSetInverse(this.invertZ);
            this.maxSlider = this.sliderMax.getValue();
            this.minSlider = this.sliderMin.getValue();
            this.jRenderer3D.setSurfacePlotMinMax(this.minSlider, this.maxSlider);
            this.addCoordinateSystem();
        }
        if (e.getSource() == this.checkIsEqualxyzRatio) {
            this.isEqualxyzRatio = this.checkIsEqualxyzRatio.isSelected();
            this.setScaleAndZRatio();
        }
        this.renderAndUpdateDisplay();
    }

    private JPanel createSliderPanel2() {
        String str = "Scale: " + (double)((int)(this.scaleSlider * 100.0)) / 100.0;
        this.sliderScale = this.createSliderVertical(str, 25, 300, (int)(this.scaleSlider * 100.0));
        str = "z-Scale: " + (double)((int)(this.zAspectRatioSlider * 100.0)) / 100.0;
        this.sliderZAspectRatio = this.createSliderVertical(str, -100, 100, (int)(100.0 * Math.log10(this.zAspectRatioSlider)));
        str = "Min: " + this.minSlider + " %";
        this.sliderMin = this.createSliderVertical(str, 0, 99, this.minSlider);
        str = "Max: " + this.maxSlider + " %";
        this.sliderMax = this.createSliderVertical(str, 1, 100, this.maxSlider);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1));
        panel.add(this.sliderScale);
        panel.add(this.sliderZAspectRatio);
        panel.add(this.sliderMax);
        panel.add(this.sliderMin);
        return panel;
    }

    private JSlider createSliderHorizontal(String borderTitle, int min, int max, int value) {
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        Font sliderFont = new Font("Sans", 0, 11);
        JSlider slider = this.createSliderSafe(0, min, max, value);
        slider.setBorder(new TitledBorder(empty, borderTitle, 2, 3, sliderFont));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Interactive_3D_Surface_Plot.this.sliderChange((JSlider)event.getSource());
            }
        });
        return slider;
    }

    private JSlider createSliderVertical(String borderTitle, int min, int max, int value) {
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        Font sliderFont = new Font("Sans", 0, 11);
        JSlider slider = this.createSliderSafe(1, min, max, value);
        slider.setBorder(new TitledBorder(empty, borderTitle, 2, 3, sliderFont));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Interactive_3D_Surface_Plot.this.sliderChange((JSlider)event.getSource());
            }
        });
        return slider;
    }

    private JSlider createSliderSafe(int orientation, int min, int max, int value) {
        if (min >= max || max <= min) {
            IJ.log((String)("WARNING: Interactive 3D surface plot attempted to create slider with invalid min: " + min + " and max: " + max));
            max = min + 1;
        }
        if (value < min) {
            IJ.log((String)("WARNING: Interactive 3D surface plot attempted to create slider with value: " + value + ". Capping at lower bound: " + min));
            value = min;
        } else if (value > max) {
            IJ.log((String)("WARNING: Interactive 3D surface plot attempted to create slider with invalid value: " + value + ". Capping at upper bound: " + max));
            value = max;
        }
        return new JSlider(orientation, min, max, value);
    }

    private void setSliderTitle(JSlider slider, Color color, String str) {
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        Font sliderFont = new Font("Sans", 0, 11);
        slider.setBorder(new TitledBorder(empty, str, 2, 3, sliderFont));
    }

    class ImageRegion
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image image;
        private int width;
        private int height;

        ImageRegion() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.width, this.height);
        }

        public void setImage(JRenderer3D pic) {
            this.height = pic.getHeight();
            this.width = pic.getWidth();
            this.image = pic.getImage();
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public void paint(Graphics g) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this.width, this.height, this);
            }
        }

        synchronized void saveToImageJImage(String name) {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            this.paint(bufferedImage.createGraphics());
            String str = "Surface_Plot_of_" + name;
            ImagePlus plotImage = NewImage.createRGBImage((String)str, (int)this.width, (int)this.height, (int)1, (int)1);
            ImageProcessor ip = plotImage.getProcessor();
            int[] pixels = (int[])ip.getPixels();
            bufferedImage.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
            plotImage.show();
            plotImage.updateAndDraw();
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }
}

