/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import util.FibonacciHeapDouble;

public class Lasso {
    public static final int BLOW = 0;
    public static final int LASSO = 1;
    public static final int MIN_LASSO = 2;
    public static final int MAX_TOOL = 2;
    private Mode mode = Mode.BLOW;
    private Difference difference;
    private double[] dijkstra;
    private int[] previous;
    private ImagePlus imp;
    public final int w;
    public final int h;
    private Roi originalRoi;
    private double ratioSpaceColor = 1.0;
    static final int[] stepX = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
    static final int[] stepY = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
    static final int[] stepW = new int[]{4, 3, 4, 3, 4, 3, 4, 3};
    FibonacciHeapDouble queue;
    int startX;
    int startY;

    public Lasso(ImagePlus imp, int mode) {
        this(imp, Mode.valueOf(mode));
    }

    public Lasso(ImagePlus imp, Mode mode) {
        this.imp = imp;
        this.mode = mode;
        this.w = imp.getWidth();
        this.h = imp.getHeight();
    }

    public Lasso(ImagePlus imp) {
        this(imp, Mode.BLOW);
    }

    public Lasso(ImagePlus imp, int mode, int x, int y, boolean shiftKeyDown) {
        this(imp, Mode.valueOf(mode), x, y, shiftKeyDown);
    }

    public Lasso(ImagePlus imp, Mode mode, int x, int y, boolean shiftKeyDown) {
        this(imp, mode);
        this.initDijkstra(x, y, shiftKeyDown);
    }

    public void setRatioSpaceColor(double ratioSpaceColor) {
        this.ratioSpaceColor = ratioSpaceColor;
    }

    public void optionDialog() {
        GenericDialog gd = new GenericDialog("Lasso/Blow Tool Options");
        gd.addChoice("mode", Mode.labels, this.mode.toString());
        gd.addNumericField("ratio space/color", this.ratioSpaceColor, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.mode = Mode.valueOf(gd.getNextChoiceIndex());
        this.ratioSpaceColor = gd.getNextNumber();
    }

    public ImagePlus getImage() {
        return this.imp;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void moveLasso(int x, int y) {
        int i;
        this.getDijkstra(x, y);
        int[] xPoints = new int[this.w * this.h];
        int[] yPoints = new int[this.w * this.h];
        for (i = 0; i < this.w * this.h; ++i) {
            xPoints[i] = x;
            yPoints[i] = y;
            int j = this.previous[x + this.w * y];
            x = j % this.w;
            y = j / this.w;
            if (x != this.startX || y != this.startY) continue;
        }
        PolygonRoi roi = new PolygonRoi(xPoints, yPoints, i, 7);
        if (this.originalRoi != null) {
            roi = new ShapeRoi(this.originalRoi).or(new ShapeRoi((Roi)roi));
        }
        this.imp.setRoi((Roi)roi);
        this.imp.updateAndDraw();
    }

    public void moveBlow(int x, int y) {
        this.getDijkstra(x, y);
        FloatProcessor fp = new FloatProcessor(this.w, this.h, this.dijkstra);
        fp.setThreshold(Double.MIN_VALUE, this.dijkstra[x + this.w * y] + 1.0, 2);
        ImagePlus blowImage = new ImagePlus("blow", (ImageProcessor)fp);
        ThresholdToSelection t2s = new ThresholdToSelection();
        t2s.setup("", blowImage);
        t2s.run((ImageProcessor)fp);
        Roi roi = blowImage.getRoi();
        if (this.originalRoi != null) {
            roi = new ShapeRoi(this.originalRoi).or(new ShapeRoi(roi));
        }
        this.imp.setRoi(roi);
        this.imp.updateAndDraw();
    }

    Difference getDifference(ImageProcessor ip) {
        if (this.mode == Mode.MIN_LASSO) {
            if (ip instanceof ByteProcessor) {
                return new ByteMinValue((byte[])ip.getPixels());
            }
            if (ip instanceof ColorProcessor) {
                return new ColorMinValue((int[])ip.getPixels());
            }
            return new MinValue(ip);
        }
        if (ip instanceof ByteProcessor) {
            return new ByteDifference((byte[])ip.getPixels());
        }
        if (ip instanceof ColorProcessor) {
            return new ColorDifference((int[])ip.getPixels());
        }
        return new Difference(ip);
    }

    public void initDijkstra(int x, int y, boolean shiftKeyDown) {
        this.originalRoi = shiftKeyDown ? this.imp.getRoi() : null;
        ImageProcessor ip = this.imp.getProcessor();
        this.difference = this.getDifference(ip);
        this.previous = new int[this.w * this.h];
        this.previous[x + this.w * y] = x + this.w * y;
        this.dijkstra = new double[this.w * this.h];
        for (int i = 0; i < this.w * this.h; ++i) {
            this.dijkstra[i] = Double.MAX_VALUE;
        }
        this.queue = new FibonacciHeapDouble();
        this.queue.add(0.0, new PixelCost(x, y, 0.0));
        this.startX = x;
        this.startY = y;
    }

    private void getDijkstra(int x_, int y_) {
        PixelCost pixel;
        while (this.queue.compareTo(this.dijkstra[x_ + this.w * y_]) < 0.0 && (pixel = (PixelCost)this.queue.pop()) != null) {
            int x = pixel.x;
            int y = pixel.y;
            double cost = pixel.cost;
            if (this.dijkstra[x + this.w * y] <= cost) continue;
            this.dijkstra[x + this.w * y] = cost;
            for (int i = 0; i < stepW.length; ++i) {
                double newC;
                int x2 = x + stepX[i];
                int y2 = y + stepY[i];
                if (x2 < 0 || y2 < 0 || x2 >= this.w || y2 >= this.h || !(this.dijkstra[x2 + this.w * y2] > (newC = cost + (double)stepW[i] + this.ratioSpaceColor * this.difference.difference(x, y, x2, y2)))) continue;
                this.queue.add(newC, new PixelCost(x2, y2, newC));
                this.previous[x2 + this.w * y2] = x + this.w * y;
            }
        }
    }

    private class PixelCost {
        int x;
        int y;
        double cost;

        public PixelCost(int x, int y, double cost) {
            this.x = x;
            this.y = y;
            this.cost = cost;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ": " + this.cost + ")";
        }
    }

    private class ColorMinValue
    extends Difference {
        int[] pixels;

        ColorMinValue(int[] pixels) {
            super(null);
            this.pixels = pixels;
        }

        @Override
        final double difference(int x0, int y0, int x1, int y1) {
            int v1 = this.pixels[x1 + Lasso.this.w * y1];
            int r = v1 >> 16 & 0xFF;
            int g = v1 >> 8 & 0xFF;
            int b = v1 & 0xFF;
            return r + g + b;
        }
    }

    private class ByteMinValue
    extends Difference {
        byte[] pixels;

        ByteMinValue(byte[] pixels) {
            super(null);
            this.pixels = pixels;
        }

        @Override
        final double difference(int x0, int y0, int x1, int y1) {
            return this.pixels[x1 + Lasso.this.w * y1] & 0xFF;
        }
    }

    private class MinValue
    extends Difference {
        ImageProcessor ip;

        MinValue(ImageProcessor ip) {
            super(null);
            this.ip = ip;
        }

        @Override
        double difference(int x0, int y0, int x1, int y1) {
            return this.ip.getPixelValue(x1, y1);
        }
    }

    private class ColorDifference
    extends Difference {
        int[] pixels;

        ColorDifference(int[] pixels) {
            super(null);
            this.pixels = pixels;
        }

        @Override
        final double difference(int x0, int y0, int x1, int y1) {
            int v0 = this.pixels[x0 + Lasso.this.w * y0];
            int v1 = this.pixels[x1 + Lasso.this.w * y1];
            int r = (v1 >> 16 & 0xFF) - (v0 >> 16 & 0xFF);
            int g = (v1 >> 8 & 0xFF) - (v0 >> 8 & 0xFF);
            int b = (v1 & 0xFF) - (v0 & 0xFF);
            return Math.abs(r) + Math.abs(g) + Math.abs(b);
        }
    }

    private class ByteDifference
    extends Difference {
        byte[] pixels;

        ByteDifference(byte[] pixels) {
            super(null);
            this.pixels = pixels;
        }

        @Override
        final double difference(int x0, int y0, int x1, int y1) {
            return Math.abs((this.pixels[x0 + Lasso.this.w * y0] & 0xFF) - (this.pixels[x1 + Lasso.this.w * y1] & 0xFF));
        }
    }

    private class Difference {
        ImageProcessor ip;

        Difference(ImageProcessor ip) {
            this.ip = ip;
        }

        double difference(int x0, int y0, int x1, int y1) {
            return Math.abs(this.ip.getPixelValue(x0, y0) - this.ip.getPixelValue(x1, y1));
        }
    }

    public static enum Mode {
        BLOW,
        LASSO,
        MIN_LASSO;

        public static final String[] labels;

        public static Mode valueOf(int i) {
            return Mode.values()[i];
        }

        static {
            Mode[] values = Mode.values();
            labels = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                Mode.labels[i] = values[i].toString();
            }
        }
    }
}

