/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.FunctionJitter;
import org.renjin.compiler.pipeline.JittedComputation;
import org.renjin.compiler.pipeline.MeanJitter;
import org.renjin.compiler.pipeline.RowMeanJitter;
import org.renjin.compiler.pipeline.VectorPipeliner;

public class DeferredJitter {
    private String className = "Jit" + System.identityHashCode(this);
    private ClassVisitor cv;

    public JittedComputation compile(DeferredNode node) {
        long startTime = System.nanoTime();
        ClassWriter cw = new ClassWriter(3);
        this.cv = cw;
        this.cv.visit(50, 33, this.className, null, "java/lang/Object", new String[]{"org/renjin/compiler/pipeline/JittedComputation"});
        this.writeConstructor();
        this.writeCompute(node);
        this.cv.visitEnd();
        byte[] classBytes = cw.toByteArray();
        long compileTime = System.nanoTime() - startTime;
        Class jitClass = new MyClassLoader().defineClass(this.className, classBytes);
        long loadTime = System.nanoTime() - startTime - compileTime;
        if (VectorPipeliner.DEBUG) {
            System.out.println("compile: " + (double)compileTime / 1000000.0 + "ms");
            System.out.println("load: " + (double)loadTime / 1000000.0 + "ms");
        }
        try {
            return (JittedComputation)jitClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke jitted computation", e);
        }
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeCompute(DeferredNode node) {
        MethodVisitor mv = this.cv.visitMethod(1, "compute", "([Lorg/renjin/sexp/Vector;)[D", null, null);
        mv.visitCode();
        ComputeMethod methodContext = new ComputeMethod(mv);
        FunctionJitter function2 = this.getFunction(node);
        function2.compute(methodContext, node);
        mv.visitMaxs(1, methodContext.getMaxLocals());
        mv.visitEnd();
    }

    private FunctionJitter getFunction(DeferredNode node) {
        if (node.getComputation().getComputationName().equals("mean")) {
            return new MeanJitter();
        }
        if (node.getComputation().getComputationName().equals("rowMeans")) {
            return new RowMeanJitter();
        }
        throw new UnsupportedOperationException(node.toString());
    }

    class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
        }

        public Class defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

