/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.primitives.combine.Combiner;
import org.renjin.primitives.combine.Inspector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Combine {
    private static final Function<NamedValue, SEXP> VALUE_OF = new Function<NamedValue, SEXP>(){

        public SEXP apply(NamedValue input) {
            return input.getValue();
        }
    };

    @Builtin
    public static SEXP c(@ArgumentList ListVector arguments, @NamedFlag(value="recursive") boolean recursive2) {
        Inspector inspector = new Inspector(recursive2);
        inspector.acceptAll(Iterables.transform(arguments.namedValues(), VALUE_OF));
        CombinedBuilder builder = inspector.newBuilder().useNames(true);
        return new Combiner(recursive2, builder).add(arguments.namedValues()).build();
    }

    @Internal
    public static AtomicVector unlist(AtomicVector vector2, boolean recursive2, boolean useNames) {
        return vector2;
    }

    @Internal
    public static Vector unlist(ListVector vector2, boolean recursive2, boolean useNames) {
        Inspector inspector = new Inspector(recursive2);
        inspector.acceptAll(vector2);
        CombinedBuilder builder = inspector.newBuilder().useNames(useNames);
        return new Combiner(recursive2, builder).add(vector2.namedValues()).build();
    }

    @Internal
    public static SEXP rbind(@Current Context context, @Current Environment rho, int deparseLevel, @ArgumentList ListVector arguments) {
        SEXP genericResult = Combine.tryBindDispatch(context, rho, "rbind", deparseLevel, arguments);
        if (genericResult != null) {
            return genericResult;
        }
        ArrayList bindArguments = Lists.newArrayList();
        for (int i = 0; i != arguments.length(); ++i) {
            Vector argument = (Vector)EvalException.checkedCast(arguments.getElementAsSEXP(i));
            if (argument.length() == 0) continue;
            bindArguments.add(new BindArgument(null, argument, true));
        }
        if (bindArguments.isEmpty()) {
            return Null.INSTANCE;
        }
        int columns = -1;
        int rows = 0;
        for (BindArgument argument : bindArguments) {
            if (argument.matrix) {
                rows += argument.rows;
                if (columns == -1) {
                    columns = argument.cols;
                    continue;
                }
                if (columns == argument.cols) continue;
                throw new EvalException("number of columns of matrices must match", new Object[0]);
            }
            ++rows;
        }
        if (columns == -1) {
            for (BindArgument argument : bindArguments) {
                if (argument.vector.length() <= columns) continue;
                columns = argument.vector.length();
            }
        }
        for (BindArgument argument : bindArguments) {
            if (argument.matrix || columns % argument.vector.length() == 0) continue;
            throw new EvalException("number of columns of result is not a multiple of vector length", new Object[0]);
        }
        Inspector inspector = new Inspector(false);
        inspector.acceptAll(arguments);
        Vector.Builder vectorBuilder = inspector.getResult().newBuilder();
        Matrix2dBuilder builder = new Matrix2dBuilder(vectorBuilder, rows, columns);
        for (int j = 0; j != columns; ++j) {
            for (BindArgument argument : bindArguments) {
                for (int i = 0; i != argument.rows; ++i) {
                    builder.addFrom(argument, i, j);
                }
            }
        }
        Null rowNames = Null.INSTANCE;
        AtomicVector colNames = Null.INSTANCE;
        for (BindArgument argument : bindArguments) {
            if (argument.colNames.length() != columns) continue;
            colNames = argument.colNames;
            break;
        }
        builder.setDimNames(rowNames, colNames);
        return builder.build();
    }

    @Internal
    public static SEXP cbind(@Current Context context, @Current Environment rho, int deparseLevel, @ArgumentList ListVector arguments) {
        SEXP genericResult = Combine.tryBindDispatch(context, rho, "cbind", deparseLevel, arguments);
        if (genericResult != null) {
            return genericResult;
        }
        ArrayList bindArguments = Lists.newArrayList();
        for (NamedValue arg : arguments.namedValues()) {
            Vector argument = (Vector)EvalException.checkedCast(arg.getValue());
            if (argument.length() <= 0) continue;
            bindArguments.add(new BindArgument(arg.getName(), argument, false));
        }
        if (bindArguments.isEmpty()) {
            return Null.INSTANCE;
        }
        int rows = -1;
        int columns = 0;
        for (BindArgument argument : bindArguments) {
            if (argument.matrix) {
                columns += argument.cols;
                if (rows == -1) {
                    rows = argument.rows;
                    continue;
                }
                if (rows == argument.rows) continue;
                throw new EvalException("number of rows of matrices must match", new Object[0]);
            }
            ++columns;
        }
        if (rows == -1) {
            for (BindArgument argument : bindArguments) {
                if (argument.vector.length() <= rows) continue;
                rows = argument.vector.length();
            }
        }
        for (BindArgument argument : bindArguments) {
            if (argument.matrix || rows % argument.vector.length() == 0) continue;
            throw new EvalException("number of rows of result is not a multiple of vector length", new Object[0]);
        }
        Inspector inspector = new Inspector(false);
        inspector.acceptAll(arguments);
        Vector.Builder vectorBuilder = inspector.getResult().newBuilder();
        Matrix2dBuilder builder = new Matrix2dBuilder(vectorBuilder, rows, columns);
        for (BindArgument argument : bindArguments) {
            for (int j = 0; j != argument.cols; ++j) {
                for (int i = 0; i != rows; ++i) {
                    builder.addFrom(argument, i, j);
                }
            }
        }
        AtomicVector rowNames = Null.INSTANCE;
        StringVector.Builder colNames = new StringVector.Builder();
        boolean hasColNames = false;
        for (BindArgument argument : bindArguments) {
            if (argument.rowNames.length() != rows) continue;
            rowNames = argument.rowNames;
            break;
        }
        for (BindArgument argument : bindArguments) {
            int i;
            if (argument.colNames != Null.INSTANCE) {
                hasColNames = true;
                for (i = 0; i != argument.cols; ++i) {
                    colNames.add(argument.colNames.getElementAsString(i));
                }
                continue;
            }
            if (argument.argName != null && !argument.matrix) {
                colNames.add(argument.argName);
                hasColNames = true;
                continue;
            }
            for (i = 0; i != argument.cols; ++i) {
                colNames.add("");
            }
        }
        builder.setDimNames(rowNames, (AtomicVector)((Object)(hasColNames ? colNames.build() : Null.INSTANCE)));
        return builder.build();
    }

    private static SEXP tryBindDispatch(Context context, Environment rho, String bindFunctionName, int deparseLevel, ListVector arguments) {
        Symbol foundMethod = null;
        org.renjin.sexp.Function foundFunction = null;
        for (SEXP argument : arguments) {
            Vector classes = (Vector)argument.getAttribute(Symbols.CLASS);
            for (int i = 0; i != classes.length(); ++i) {
                Symbol methodName = Symbol.get(bindFunctionName + "." + classes.getElementAsString(i));
                org.renjin.sexp.Function function2 = rho.findFunction(context, methodName);
                if (function2 == null) continue;
                if (foundMethod != null && methodName != foundMethod) {
                    return null;
                }
                foundMethod = methodName;
                foundFunction = function2;
            }
        }
        if (foundFunction == null) {
            return null;
        }
        PairList.Builder args2 = new PairList.Builder();
        args2.add("deparse.level", (SEXP)new Promise(Symbol.get("deparse.level"), (SEXP)new IntArrayVector(deparseLevel)));
        args2.addAll(arguments);
        FunctionCall call2 = new FunctionCall(Symbol.get(bindFunctionName), args2.build());
        return foundFunction.apply(context, rho, call2, call2.getArguments());
    }

    private static class Matrix2dBuilder {
        private final Vector.Builder builder;
        private final int rows;
        private final int cols;
        private int count = 0;

        private Matrix2dBuilder(Vector.Builder builder, int rows, int cols) {
            this.builder = builder;
            this.rows = rows;
            this.cols = cols;
        }

        public void addFrom(BindArgument argument, int rowIndex, int colIndex) {
            int recycledColIndex = colIndex % argument.cols;
            int recycledRowIndex = rowIndex % argument.rows;
            this.builder.setFrom(this.count, argument.vector, recycledColIndex * argument.rows + recycledRowIndex);
            ++this.count;
        }

        public void setDimNames(AtomicVector rowNames, AtomicVector colNames) {
            if (rowNames.length() != 0 || colNames.length() != 0) {
                this.builder.setAttribute(Symbols.DIMNAMES, (SEXP)new ListVector(rowNames, colNames));
            }
        }

        public Vector build() {
            return this.builder.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(this.rows, this.cols)).build();
        }
    }

    private static class BindArgument {
        private final Vector vector;
        private final int rows;
        private final int cols;
        private AtomicVector rowNames = Null.INSTANCE;
        private AtomicVector colNames = Null.INSTANCE;
        private final boolean matrix;
        private String argName;

        public BindArgument(String argName, Vector vector2, boolean defaultToRows) {
            this.argName = argName;
            Vector dim2 = vector2.getAttributes().getDim();
            this.vector = vector2;
            if (dim2 == Null.INSTANCE || dim2.length() != 2) {
                if (defaultToRows) {
                    this.rows = 1;
                    this.cols = vector2.length();
                    this.colNames = vector2.getNames();
                } else {
                    this.cols = 1;
                    this.rows = vector2.length();
                    this.rowNames = vector2.getNames();
                }
                this.matrix = false;
            } else {
                AtomicVector dimVector = (AtomicVector)dim2;
                this.rows = dimVector.getElementAsInt(0);
                this.cols = dimVector.getElementAsInt(1);
                Vector dimNames = (Vector)this.vector.getAttribute(Symbols.DIMNAMES);
                if (dimNames instanceof ListVector && dimNames.length() == 2) {
                    this.rowNames = (AtomicVector)dimNames.getElementAsSEXP(0);
                    this.colNames = (AtomicVector)dimNames.getElementAsSEXP(1);
                }
                this.matrix = true;
            }
        }
    }
}

