/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scijava.ui.behaviour.Behaviour;

public class BehaviourMap {
    private final Map<String, Behaviour> behaviours = new HashMap<String, Behaviour>();
    private BehaviourMap parent = null;
    private int expectedParentModCount = 0;
    private int modCount = 0;

    public void setParent(BehaviourMap map) {
        this.parent = map;
        if (map != null) {
            this.expectedParentModCount = this.parent.modCount();
        }
        ++this.modCount;
    }

    public BehaviourMap getParent() {
        return this.parent;
    }

    public synchronized void put(String key, Behaviour behaviour) {
        this.behaviours.put(key, behaviour);
        ++this.modCount;
    }

    public synchronized Behaviour get(String key) {
        Behaviour behaviour = this.behaviours.get(key);
        if (behaviour == null && this.parent != null) {
            return this.parent.get(key);
        }
        return behaviour;
    }

    public synchronized void remove(String key) {
        this.behaviours.remove(key);
        ++this.modCount;
    }

    public synchronized void clear() {
        this.behaviours.clear();
        ++this.modCount;
    }

    public synchronized Map<String, Behaviour> getAllBindings() {
        HashMap<String, Behaviour> allBindings = this.parent == null ? new HashMap() : this.parent.getAllBindings();
        for (Map.Entry<String, Behaviour> entry : this.behaviours.entrySet()) {
            allBindings.put(entry.getKey(), entry.getValue());
        }
        return allBindings;
    }

    public synchronized Set<String> keys() {
        return new HashSet<String>(this.behaviours.keySet());
    }

    public int modCount() {
        int m;
        if (this.parent != null && (m = this.parent.modCount()) != this.expectedParentModCount) {
            this.expectedParentModCount = m;
            ++this.modCount;
        }
        return this.modCount;
    }
}

