/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerDescription;
import org.scijava.ui.behaviour.io.InputTriggerDescriptionsBuilder;

public class InputTriggerConfig
implements InputTriggerAdder.Factory,
KeyStrokeAdder.Factory {
    final LinkedHashMap<String, Set<Input>> actionToInputsMap = new LinkedHashMap();

    public InputTriggerConfig() {
    }

    public InputTriggerConfig(Collection<InputTriggerDescription> keyMappings) throws IllegalArgumentException {
        if (keyMappings == null) {
            return;
        }
        for (InputTriggerDescription mapping : keyMappings) {
            String[] triggers;
            String behaviour = mapping.getAction();
            HashSet<String> contexts = new HashSet<String>();
            contexts.addAll(Arrays.asList(mapping.getContexts()));
            for (String triggerStr : triggers = mapping.getTriggers()) {
                InputTrigger trigger = InputTrigger.getFromString(triggerStr);
                Input input = new Input(trigger, behaviour, contexts);
                Set inputs = this.actionToInputsMap.computeIfAbsent(input.behaviour, k -> new LinkedHashSet());
                inputs.add(input);
            }
        }
    }

    @Override
    public InputTriggerAdder inputTriggerAdder(InputTriggerMap map, String ... contexts) {
        return new InputTriggerAdderImp(map, this, contexts);
    }

    @Override
    public KeyStrokeAdder keyStrokeAdder(InputMap map, String ... contexts) {
        return new KeyStrokeAdderImp(map, this, contexts);
    }

    public Set<InputTrigger> getInputs(String behaviourName, String context) {
        return this.getInputs(behaviourName, Collections.singleton(context));
    }

    public Set<InputTrigger> getInputs(String behaviourName, Set<String> contexts) {
        Set<Input> inputs = this.actionToInputsMap.get(behaviourName);
        LinkedHashSet<InputTrigger> triggers = new LinkedHashSet<InputTrigger>();
        if (inputs != null) {
            for (Input input : inputs) {
                if (Collections.disjoint(contexts, input.contexts)) continue;
                triggers.add(input.trigger);
            }
        }
        return triggers;
    }

    public static String prettyPrintInputs(Set<InputTrigger> triggers) {
        StringBuilder sb = new StringBuilder();
        Iterator<InputTrigger> it = triggers.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    public void clear() {
        this.actionToInputsMap.clear();
    }

    public void set(InputTriggerConfig config) {
        this.actionToInputsMap.clear();
        for (Map.Entry<String, Set<Input>> entry : config.actionToInputsMap.entrySet()) {
            String behaviourName = entry.getKey();
            LinkedHashSet inputs = new LinkedHashSet();
            entry.getValue().forEach(i -> inputs.add(i.copy()));
            this.actionToInputsMap.put(behaviourName, inputs);
        }
    }

    public void add(String trigger, String behaviourName, String context) {
        this.add(InputTrigger.getFromString(trigger), behaviourName, context);
    }

    public void add(InputTrigger trigger, String behaviourName, String context) {
        this.add(trigger, behaviourName, Collections.singleton(context));
    }

    public synchronized void add(InputTrigger trigger, String behaviourName, Collection<String> contexts) {
        Set inputs = this.actionToInputsMap.computeIfAbsent(behaviourName, k -> new LinkedHashSet());
        for (Input input : inputs) {
            if (!input.trigger.equals(trigger)) continue;
            input.contexts.addAll(contexts);
            return;
        }
        inputs.add(new Input(trigger, behaviourName, contexts));
    }

    public void remove(String trigger, String behaviourName, String context) {
        this.remove(InputTrigger.getFromString(trigger), behaviourName, context);
    }

    public void remove(InputTrigger trigger, String behaviourName, String context) {
        this.remove(trigger, behaviourName, Collections.singleton(context));
    }

    public synchronized void remove(InputTrigger trigger, String behaviourName, Collection<String> contexts) {
        Set<Input> inputs = this.actionToInputsMap.get(behaviourName);
        if (inputs == null) {
            return;
        }
        for (Input input : inputs) {
            if (!input.trigger.equals(trigger)) continue;
            input.contexts.removeAll(contexts);
            if (input.contexts.isEmpty()) {
                inputs.remove(input);
                if (inputs.isEmpty()) {
                    this.actionToInputsMap.remove(behaviourName);
                }
            }
            return;
        }
    }

    public String toString() {
        return "InputTriggerConfig{" + new InputTriggerDescriptionsBuilder(this).getDescriptions() + '}';
    }

    void addMap(InputTriggerMap map, String context) {
        for (Map.Entry<InputTrigger, Set<String>> entry : map.getAllBindings().entrySet()) {
            InputTrigger trigger = entry.getKey();
            Set<String> behaviours = entry.getValue();
            for (String behaviourName : behaviours) {
                Set inputs = this.actionToInputsMap.computeIfAbsent(behaviourName, k -> new LinkedHashSet());
                boolean added = false;
                for (Input input : inputs) {
                    if (!input.trigger.equals(trigger)) continue;
                    input.contexts.add(context);
                    added = true;
                    break;
                }
                if (added) continue;
                inputs.add(new Input(trigger, behaviourName, Collections.singleton(context)));
            }
        }
    }

    void addMap(InputMap map, String context) {
        KeyStroke[] keys;
        for (KeyStroke key : keys = map.allKeys()) {
            InputTrigger trigger = InputTrigger.getFromString(key.toString());
            String behaviourName = map.get(key).toString();
            Set inputs = this.actionToInputsMap.computeIfAbsent(behaviourName, k -> new LinkedHashSet());
            boolean added = false;
            for (Input input : inputs) {
                if (!input.trigger.equals(trigger)) continue;
                input.contexts.add(context);
                added = true;
                break;
            }
            if (added) continue;
            inputs.add(new Input(trigger, behaviourName, Collections.singleton(context)));
        }
    }

    static class Input {
        final InputTrigger trigger;
        final String behaviour;
        final Set<String> contexts;

        Input(InputTrigger trigger, String behaviour, Collection<String> contexts) {
            this.trigger = trigger;
            this.behaviour = behaviour;
            this.contexts = new HashSet<String>(contexts);
        }

        Input(Input input) {
            this.trigger = input.trigger;
            this.behaviour = input.behaviour;
            this.contexts = new HashSet<String>(input.contexts);
        }

        Input copy() {
            return new Input(this);
        }

        public int hashCode() {
            int value = 17;
            value = 31 * value + this.trigger.hashCode();
            value = 31 * value + this.behaviour.hashCode();
            value = 31 * value + this.contexts.hashCode();
            return value;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Input)) {
                return false;
            }
            Input i = (Input)obj;
            return i.trigger.equals(this.trigger) && i.behaviour.equals(this.behaviour) && i.contexts.equals(this.contexts);
        }

        InputTriggerDescription getDescription() {
            return new InputTriggerDescription(new String[]{this.trigger.toString()}, this.behaviour, this.contexts.toArray(new String[0]));
        }
    }

    public static class KeyStrokeAdderImp
    implements KeyStrokeAdder {
        private final InputMap map;
        private final InputTriggerConfig config;
        private final Set<String> contexts;

        public KeyStrokeAdderImp(InputMap map, InputTriggerConfig config, Set<String> contexts) {
            this.map = map;
            this.config = config;
            this.contexts = contexts;
        }

        public KeyStrokeAdderImp(InputMap map, InputTriggerConfig config, String ... contexts) {
            this.map = map;
            this.config = config;
            this.contexts = new HashSet<String>(Arrays.asList(contexts));
        }

        @Override
        @Deprecated
        public void put(String actionName, KeyStroke ... defaultKeyStrokes) {
            Set<InputTrigger> triggers = this.config.getInputs(actionName, this.contexts);
            if (triggers.contains(InputTrigger.NOT_MAPPED)) {
                return;
            }
            boolean configKeyAdded = false;
            for (InputTrigger trigger : triggers) {
                if (!trigger.isKeyStroke()) continue;
                this.map.put(trigger.getKeyStroke(), actionName);
                configKeyAdded = true;
            }
            if (configKeyAdded) {
                return;
            }
            if (defaultKeyStrokes.length > 0) {
                for (KeyStroke keyStroke : defaultKeyStrokes) {
                    this.config.add(InputTrigger.getFromString(keyStroke.toString()), actionName, this.contexts);
                    this.map.put(keyStroke, actionName);
                }
            } else {
                System.err.println("Could not assign KeyStroke for \"" + actionName + "\". Nothing defined in InputTriggerConfig, and no default given.");
            }
        }

        @Override
        public void put(String actionName, InputTrigger ... defaultKeyStrokes) {
            Set<InputTrigger> triggers = this.config.getInputs(actionName, this.contexts);
            if (triggers.contains(InputTrigger.NOT_MAPPED)) {
                return;
            }
            boolean configKeyAdded = false;
            for (InputTrigger trigger : triggers) {
                if (!trigger.isKeyStroke()) continue;
                this.map.put(trigger.getKeyStroke(), actionName);
                configKeyAdded = true;
            }
            if (configKeyAdded) {
                return;
            }
            if (defaultKeyStrokes.length > 0) {
                if (defaultKeyStrokes[0].equals(InputTrigger.NOT_MAPPED)) {
                    this.config.add(InputTrigger.NOT_MAPPED, actionName, this.contexts);
                    return;
                }
                for (InputTrigger trigger : defaultKeyStrokes) {
                    if (!trigger.isKeyStroke()) continue;
                    this.config.add(trigger, actionName, this.contexts);
                    this.map.put(trigger.getKeyStroke(), actionName);
                    configKeyAdded = true;
                }
            }
            if (!configKeyAdded) {
                System.err.println("Could not assign KeyStroke for \"" + actionName + "\". Nothing defined in InputTriggerConfig, and no default given.");
            }
        }

        @Override
        public void put(String actionName, String ... defaultKeyStrokes) {
            InputTrigger[] keyStrokes = new InputTrigger[defaultKeyStrokes.length];
            int i = 0;
            for (String s : defaultKeyStrokes) {
                keyStrokes[i++] = InputTrigger.getFromString(s);
            }
            this.put(actionName, keyStrokes);
        }

        @Override
        public void put(String actionName) {
            this.put(actionName, new KeyStroke[0]);
        }
    }

    public static class InputTriggerAdderImp
    implements InputTriggerAdder {
        private final InputTriggerMap map;
        private final InputTriggerConfig config;
        private final Set<String> contexts;

        public InputTriggerAdderImp(InputTriggerMap map, InputTriggerConfig config, Set<String> contexts) {
            this.map = map;
            this.config = config;
            this.contexts = contexts;
        }

        public InputTriggerAdderImp(InputTriggerMap map, InputTriggerConfig config, String ... contexts) {
            this.map = map;
            this.config = config;
            this.contexts = new HashSet<String>(Arrays.asList(contexts));
        }

        @Override
        public void put(String behaviourName, InputTrigger ... defaultTriggers) {
            Set<InputTrigger> triggers = this.config.getInputs(behaviourName, this.contexts);
            if (!triggers.isEmpty()) {
                if (triggers.contains(InputTrigger.NOT_MAPPED)) {
                    return;
                }
                for (InputTrigger trigger : triggers) {
                    this.map.put(trigger, behaviourName);
                }
            } else if (defaultTriggers.length > 0) {
                if (defaultTriggers[0].equals(InputTrigger.NOT_MAPPED)) {
                    this.config.add(InputTrigger.NOT_MAPPED, behaviourName, this.contexts);
                    return;
                }
                for (InputTrigger trigger : defaultTriggers) {
                    this.config.add(trigger, behaviourName, this.contexts);
                    this.map.put(trigger, behaviourName);
                }
            } else {
                System.err.println("Could not assign InputTrigger for \"" + behaviourName + "\". Nothing defined in InputTriggerConfig, and no default given.");
            }
        }

        @Override
        public void put(String behaviourName, String ... defaultTriggers) {
            InputTrigger[] triggers = new InputTrigger[defaultTriggers.length];
            int i = 0;
            for (String s : defaultTriggers) {
                triggers[i++] = InputTrigger.getFromString(s);
            }
            this.put(behaviourName, triggers);
        }

        @Override
        public void put(String behaviourName) {
            this.put(behaviourName, new InputTrigger[0]);
        }
    }
}

