/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import java.util.List;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public final class CFPointWriterUtils {
    private CFPointWriterUtils() {
    }

    public static LatLonRect getBoundingBox(List<? extends Station> stnList) {
        Station s = stnList.get(0);
        LatLonPoint llpt = LatLonPoint.create(s.getLatitude(), s.getLongitude());
        LatLonRect rect = new LatLonRect(llpt, 0.0, 0.0);
        for (int i = 1; i < stnList.size(); ++i) {
            s = stnList.get(i);
            rect.extend(LatLonPoint.create(s.getLatitude(), s.getLongitude()));
        }
        double newLowerLeftLat = rect.getLowerLeftPoint().getLatitude() - 5.0E-4;
        double newLowerLeftLon = rect.getLowerLeftPoint().getLongitude() - 5.0E-4;
        LatLonPoint newLowerLeftPoint = LatLonPoint.create(newLowerLeftLat, newLowerLeftLon);
        double newUpperRightLat = rect.getUpperRightPoint().getLatitude() + 5.0E-4;
        double newUpperRightLon = rect.getUpperRightPoint().getLongitude() + 5.0E-4;
        LatLonPoint newUpperRightPoint = LatLonPoint.create(newUpperRightLat, newUpperRightLon);
        rect.extend(newLowerLeftPoint);
        rect.extend(newUpperRightPoint);
        return rect;
    }
}

