/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.links.console;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.links.LinkService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=ConsoleArgument.class, priority=10000.0)
public class LinkArgument
extends AbstractConsoleArgument {
    @Parameter(required=false)
    private LinkService linkService;

    public void handle(LinkedList<String> args) {
        if (this.linkService == null) {
            return;
        }
        if (args.isEmpty()) {
            return;
        }
        URI uri = this.link(args.getFirst());
        if (uri == null) {
            return;
        }
        this.linkService.handle(uri);
    }

    public boolean supports(LinkedList<String> args) {
        return !args.isEmpty() && this.link(args.getFirst()) != null;
    }

    private URI link(String s) {
        try {
            URI uri = new URI(s);
            return uri.getScheme() == null ? null : uri;
        }
        catch (URISyntaxException e) {
            LogService log = this.log();
            if (log != null) {
                log.debug((Throwable)e);
            }
            return null;
        }
    }
}

