/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bigwarp.BigWarp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TransformTypeSelectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String TPS = "Thin Plate Spline";
    @Deprecated
    public static final String MASKEDTPS = "Masked Thin Plate Spline";
    @Deprecated
    public static final String MASKEDSIMTPS = "Masked Similarity + Thin Plate Spline";
    @Deprecated
    public static final String AFFINE = "Affine";
    @Deprecated
    public static final String SIMILARITY = "Similarity";
    @Deprecated
    public static final String ROTATION = "Rotation";
    @Deprecated
    public static final String TRANSLATION = "Translation";
    private final BigWarp<?> bw;
    private String transformType;
    private final ButtonGroup group;
    private final JRadioButton tpsButton;
    private final JRadioButton affineButton;
    private final JRadioButton similarityButton;
    private final JRadioButton rotationButton;
    private final JRadioButton translationButton;
    private boolean active;

    public TransformTypeSelectDialog(Frame owner, BigWarp<?> bw) {
        super(owner, "Transform Type select", false);
        this.bw = bw;
        this.active = true;
        this.setLayout(new BorderLayout());
        this.transformType = bw.getTransformType();
        this.tpsButton = new JRadioButton(TPS);
        this.affineButton = new JRadioButton(AFFINE);
        this.similarityButton = new JRadioButton(SIMILARITY);
        this.rotationButton = new JRadioButton(ROTATION);
        this.translationButton = new JRadioButton(TRANSLATION);
        this.group = new ButtonGroup();
        this.group.add(this.tpsButton);
        this.group.add(this.affineButton);
        this.group.add(this.similarityButton);
        this.group.add(this.rotationButton);
        this.group.add(this.translationButton);
        this.updateButtonGroup();
        this.addActionListender(this.tpsButton);
        this.addActionListender(this.affineButton);
        this.addActionListender(this.similarityButton);
        this.addActionListender(this.rotationButton);
        this.addActionListender(this.translationButton);
        JPanel radioPanel = new JPanel(new GridLayout(0, 1));
        radioPanel.add(this.tpsButton);
        radioPanel.add(this.affineButton);
        radioPanel.add(this.similarityButton);
        radioPanel.add(this.rotationButton);
        radioPanel.add(this.translationButton);
        radioPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Transform type"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.add((Component)radioPanel, "First");
        this.pack();
    }

    private void updateButtonGroup() {
        switch (this.transformType) {
            case "Thin Plate Spline": {
                this.tpsButton.setSelected(true);
                break;
            }
            case "Affine": {
                this.affineButton.setSelected(true);
                break;
            }
            case "Similarity": {
                this.similarityButton.setSelected(true);
                break;
            }
            case "Rotation": {
                this.rotationButton.setSelected(true);
                break;
            }
            case "Translation": {
                this.translationButton.setSelected(true);
            }
        }
    }

    public void addActionListender(final JRadioButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TransformTypeSelectDialog.this.active) {
                    String type = button.getText();
                    TransformTypeSelectDialog.this.bw.setTransformType(type);
                    TransformTypeSelectDialog.this.bw.updateTransformTypePanel(type);
                }
            }
        });
    }

    public void addFalloffActionListender(final JRadioButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransformTypeSelectDialog.this.bw.getTransformPlateauMaskSource().getRandomAccessible().setFalloffShape(button.getText());
                TransformTypeSelectDialog.this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
                TransformTypeSelectDialog.this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
            }
        });
    }

    public void setTransformType(String transformType) {
        this.transformType = transformType;
        this.updateButtonGroup();
        this.validate();
        this.repaint();
    }

    public void deactivate() {
        this.active = false;
    }

    public void activate() {
        this.active = true;
    }
}

