/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.landmarks;

import bdv.ij.ApplyBigwarpPlugin;
import bdv.viewer.Source;
import bigwarp.BigWarp;
import bigwarp.landmarks.LandmarkTableModel;
import ij.gui.GenericDialog;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.iterator.RealIntervalIterator;
import net.imglib2.realtransform.BoundingBoxEstimation;

public class LandmarkGridGenerator {
    public static int NUM_LANDMARKS_FOR_WARNING = 1200;
    private static final double SPACING_MULTIPLIER = 0.9999999;
    protected final double[] spacing;
    protected final RealInterval interval;
    private TableModelListener[] listeners;

    public LandmarkGridGenerator(RealInterval interval, double[] spacing) {
        this.interval = interval;
        this.spacing = spacing;
    }

    public LandmarkGridGenerator(RealInterval interval, long[] number) {
        this.interval = interval;
        this.spacing = new double[interval.numDimensions()];
        for (int i = 0; i < interval.numDimensions(); ++i) {
            this.spacing[i] = 0.9999999 * (interval.realMax(i) - interval.realMin(i)) / (double)(number[i] - 1L);
        }
    }

    public double approxNumberOfPoints() {
        double total = 1.0;
        for (int i = 0; i < this.interval.numDimensions(); ++i) {
            total *= (this.interval.realMax(i) - this.interval.realMin(i)) / this.spacing[i] + 1.0;
        }
        return total;
    }

    public int fill(LandmarkTableModel ltm) {
        this.pauseListeners(ltm);
        int i = 0;
        double[] p = new double[this.interval.numDimensions()];
        RealIntervalIterator it = new RealIntervalIterator(this.interval, this.spacing);
        while (it.hasNext()) {
            it.fwd();
            it.localize(p);
            ltm.add(p, true);
            ltm.setPoint(ltm.getNextRow(false), false, p, null);
            ++i;
        }
        this.resumeAndTriggerListeners(ltm);
        return i;
    }

    public static boolean fillFromDialog(BigWarp<?> bw) {
        LandmarkTableModel ltm = bw.getLandmarkPanel().getTableModel();
        int nd = ltm.ndims;
        GenericDialog gd = new GenericDialog("Generate landmark grid.");
        gd.addMessage("Field of view and resolution:");
        gd.addMessage("Number of points per dimension (default)");
        gd.addNumericField("nx", 5.0, 2);
        gd.addNumericField("ny", 5.0, 2);
        if (nd > 2) {
            gd.addNumericField("nz", 5.0, 2);
        }
        gd.addMessage("Spacing");
        gd.addNumericField("sx", -1.0, 4);
        gd.addNumericField("sy", -1.0, 4);
        if (nd > 2) {
            gd.addNumericField("sz", -1.0, 4);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        double nx = gd.getNextNumber();
        double ny = gd.getNextNumber();
        double nz = -1.0;
        if (nd > 2) {
            nz = gd.getNextNumber();
        }
        double sx = gd.getNextNumber();
        double sy = gd.getNextNumber();
        double sz = -1.0;
        if (nd > 2) {
            sz = gd.getNextNumber();
        }
        Source tgtSrc = null;
        if (bw.getData().numTargetSources() == 0) {
            throw new RuntimeException("Requested target field of view, but no target source exists.");
        }
        tgtSrc = bw.getData().getTargetSource(0).getSpimSource();
        double[] res = ApplyBigwarpPlugin.getResolution(bw.getData(), "Target", null);
        List<RealInterval> outputIntervals = ApplyBigwarpPlugin.getPhysicalInterval(bw.getData(), ltm, null, "Target", null, null, null, null, res);
        double[] offset = ApplyBigwarpPlugin.getPhysicalOffset("Target", null, ltm, null, "", new BoundingBoxEstimation(), res, null, tgtSrc);
        RealInterval interval = LandmarkGridGenerator.offsetAndSqueezeInterval(outputIntervals.get(0), offset, nd);
        LandmarkGridGenerator gen = sx > 0.0 || sy > 0.0 || sz > 0.0 ? new LandmarkGridGenerator(interval, new double[]{sx, sy, sz}) : new LandmarkGridGenerator(interval, new long[]{(long)nx, (long)ny, (long)nz});
        double N = gen.approxNumberOfPoints();
        if (N > (double)NUM_LANDMARKS_FOR_WARNING) {
            GenericDialog warningDialog = new GenericDialog("Warning");
            warningDialog.addMessage("You are about to add approximately\n" + Math.round(N) + "\npoints.");
            warningDialog.addMessage("This could cause Bigwarp to be slow or crash.");
            warningDialog.addMessage("Proceed?");
            warningDialog.showDialog();
            if (warningDialog.wasCanceled()) {
                return false;
            }
        }
        gen.fill(ltm);
        return true;
    }

    private void pauseListeners(LandmarkTableModel ltm) {
        for (TableModelListener l : this.listeners = ltm.getTableModelListeners()) {
            ltm.removeTableModelListener(l);
        }
    }

    private void resumeAndTriggerListeners(LandmarkTableModel ltm) {
        TableModelEvent e = new TableModelEvent(ltm);
        for (TableModelListener l : this.listeners) {
            ltm.addTableModelListener(l);
            l.tableChanged(e);
        }
    }

    private static RealInterval offsetAndSqueezeInterval(RealInterval interval, double[] offset, int nd) {
        if (interval.numDimensions() <= nd) {
            return interval;
        }
        double[] min = new double[nd];
        double[] max = new double[nd];
        for (int i = 0; i < nd; ++i) {
            min[i] = interval.realMin(i) + offset[i];
            max[i] = interval.realMax(i) + offset[i];
        }
        return new FinalRealInterval(min, max);
    }
}

