/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.ui.keymap;

import bdv.TransformEventHandler2D;
import bdv.TransformEventHandler3D;
import bdv.tools.CloseWindowActions;
import bdv.viewer.NavigationActions;
import bigwarp.BigWarpActions;
import bigwarp.ui.keymap.KeymapManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.scijava.Context;
import org.scijava.plugin.PluginService;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.InputTriggerDescriptionsBuilder;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionsBuilder;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;

class DumpInputConfig {
    DumpInputConfig() {
    }

    public static void writeToYaml(String fileName, InputTriggerConfig config) throws IOException {
        DumpInputConfig.mkdirs(fileName);
        List descriptions = new InputTriggerDescriptionsBuilder(config).getDescriptions();
        YamlConfigIO.write((Iterable)descriptions, (String)fileName);
    }

    public static void writeDefaultConfigToYaml(String fileName, Context context) throws IOException {
        DumpInputConfig.mkdirs(fileName);
        List descriptions = new InputTriggerDescriptionsBuilder(DumpInputConfig.buildCommandDescriptions(context).createDefaultKeyconfig()).getDescriptions();
        YamlConfigIO.write((Iterable)descriptions, (String)fileName);
    }

    private static boolean mkdirs(String fileName) {
        File dir = new File(fileName).getParentFile();
        return dir != null && dir.mkdirs();
    }

    static CommandDescriptions buildCommandDescriptions(Context context) {
        CommandDescriptionsBuilder builder = new CommandDescriptionsBuilder();
        context.inject((Object)builder);
        builder.addManually((CommandDescriptionProvider)new BigWarpActions.Descriptions(), "bigwarp");
        builder.addManually((CommandDescriptionProvider)new NavigationActions.Descriptions(), "bigwarp");
        builder.addManually((CommandDescriptionProvider)new CloseWindowActions.Descriptions(), "bigwarp");
        builder.addManually((CommandDescriptionProvider)new TransformEventHandler3D.Descriptions(), "bigwarp");
        builder.addManually((CommandDescriptionProvider)new TransformEventHandler2D.Descriptions(), "bigwarp");
        builder.verifyManuallyAdded();
        return builder.build();
    }

    public static void main(String[] args) throws IOException {
        String target = KeymapManager.class.getResource("default.yaml").getFile();
        File resource = new File(target.replaceAll("target/classes", "src/main/resources"));
        System.out.println("resource = " + resource);
        DumpInputConfig.writeDefaultConfigToYaml(resource.getAbsolutePath(), new Context(new Class[]{PluginService.class}));
    }
}

