/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility.geom;

import java.util.List;
import org.janelia.utility.geom.GeomUtils;
import org.janelia.utility.geom.Sphere;

public class BoundingSphereRitter {
    public static Sphere boundingSphere(List<double[]> points) {
        if (points == null || points.isEmpty()) {
            return null;
        }
        int nd = points.get(0).length;
        double[] x = new double[nd];
        double[] y = new double[nd];
        double maxSqrDist = -1.0;
        for (int i = 0; i < points.size(); ++i) {
            for (int j = i + 1; j < points.size(); ++j) {
                double d = GeomUtils.squaredDistance(points.get(i), points.get(j));
                if (!(d > maxSqrDist)) continue;
                maxSqrDist = d;
                System.arraycopy(points.get(i), 0, x, 0, nd);
                System.arraycopy(points.get(j), 0, y, 0, nd);
            }
        }
        double[] center = new double[nd];
        for (int d = 0; d < nd; ++d) {
            center[d] = 0.5 * (x[d] + y[d]);
        }
        Sphere sph = new Sphere(center, Math.sqrt(maxSqrDist) / 2.0);
        boolean allCovered = false;
        for (int k = 0; !allCovered && k < 5; ++k) {
            allCovered = false;
            for (double[] p : points) {
                allCovered |= BoundingSphereRitter.updateSphere(sph, p);
            }
        }
        return sph;
    }

    public static double[] furthestFrom(List<double[]> points, double[] p) {
        double maxSqrDist = -1.0;
        int maxIndex = -1;
        for (int i = 0; i < points.size(); ++i) {
            double dist = GeomUtils.squaredDistance(p, points.get(i));
            if (!(dist > maxSqrDist)) continue;
            maxSqrDist = dist;
            maxIndex = i;
        }
        return points.get(maxIndex);
    }

    public static boolean updateSphere(Sphere sphere, double[] p) {
        int i;
        double r;
        double sqrDist = GeomUtils.squaredDistance(sphere.getCenterArray(), p);
        if (sqrDist <= (r = sphere.getRadius()) * r) {
            return false;
        }
        double halfDist = 0.5 * (Math.sqrt(sqrDist) - sphere.getRadius());
        double[] c = sphere.getCenterArray();
        double[] v = new double[c.length];
        double mag = 0.0;
        for (i = 0; i < c.length; ++i) {
            v[i] = p[i] - c[i];
            mag += v[i] * v[i];
        }
        for (i = 0; i < c.length; ++i) {
            int n = i;
            c[n] = c[n] + v[i] * halfDist / Math.sqrt(mag);
        }
        sphere.setRadius(sphere.getRadius() + halfDist);
        return true;
    }
}

