/*
 * Decompiled with CFR 0.152.
 */
package preview.net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodCursor;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodFactory;

public final class NeighborhoodIterableInterval<T>
extends AbstractInterval
implements IterableInterval<Neighborhood<T>> {
    private final RandomAccessibleInterval<T> source;
    private final long size;
    final NeighborhoodFactory factory;

    public NeighborhoodIterableInterval(RandomAccessibleInterval<T> source, NeighborhoodFactory factory) {
        super(source);
        this.source = source;
        this.factory = factory;
        long s = source.dimension(0);
        for (int d = 1; d < this.n; ++d) {
            s *= source.dimension(d);
        }
        this.size = s;
    }

    public long size() {
        return this.size;
    }

    public Neighborhood<T> firstElement() {
        return (Neighborhood)this.cursor().next();
    }

    public Object iterationOrder() {
        return new FlatIterationOrder((Interval)this);
    }

    public Iterator<Neighborhood<T>> iterator() {
        return this.cursor();
    }

    public Cursor<Neighborhood<T>> cursor() {
        return new NeighborhoodCursor<T>(this.source, this.factory);
    }

    public Cursor<Neighborhood<T>> localizingCursor() {
        return this.cursor();
    }
}

