/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.lipschitz;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.lipschitz.ConeMorphology;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

@Deprecated
@Plugin(type=FeatureOp.class, label="Lipschitz")
public class SingleLipschitzFeature
extends AbstractFeatureOp {
    @Parameter
    private double slope;
    @Parameter
    private long border;

    public SingleLipschitzFeature() {
    }

    public SingleLipschitzFeature(double slope, long border) {
        this.slope = slope;
        this.border = border;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        this.apply(input, output.get(0));
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    private void apply(FeatureInput in, RandomAccessibleInterval<FloatType> out) {
        RandomAccessible<FloatType> original = in.original();
        double[] pixelSize = this.globalSettings().pixelSizeAsDoubleArray();
        FinalInterval expandedInterval = Intervals.expand(out, (long[])this.scaledBorder(pixelSize, out));
        RandomAccessibleInterval<FloatType> tmp = RevampUtils.createImage((Interval)expandedInterval, new FloatType());
        this.copy(original, tmp);
        ConeMorphology.performConeOperation(ConeMorphology.Operation.DILATION, tmp, this.scaledSlope(pixelSize));
        this.outEquals255PlusAMinusB((RandomAccessibleInterval)out, (RandomAccessible)original, (RandomAccessible)tmp);
    }

    private double[] scaledSlope(double[] pixelSizes) {
        return Arrays.stream(pixelSizes).map(pixelSize -> this.slope * pixelSize).toArray();
    }

    private long[] scaledBorder(double[] pixelSizes, RandomAccessibleInterval<FloatType> out) {
        return Arrays.stream(pixelSizes).mapToLong(pixelSize -> (long)Math.ceil((double)this.border / pixelSize)).toArray();
    }

    private <T extends Type<T>> void copy(RandomAccessible<T> in, RandomAccessibleInterval<T> out) {
        LoopBuilder.setImages((RandomAccessibleInterval)Views.interval(in, out), out).multiThreaded().forEachPixel((i, o) -> o.set(i));
    }

    private <T extends RealType<T>> void outEquals255PlusAMinusB(RandomAccessibleInterval<T> out, RandomAccessible<T> A, RandomAccessible<T> B) {
        RealType offset = (RealType)((RealType)Util.getTypeFromInterval(out)).createVariable();
        offset.setReal(255.0f);
        LoopBuilder.setImages((RandomAccessibleInterval)Views.interval(A, out), (RandomAccessibleInterval)Views.interval(B, out), out).forEachPixel((a, b, o) -> {
            o.set((Type)offset);
            o.sub(b);
            o.add(a);
        });
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("Lipschitz_true_true_" + this.slope);
    }
}

