/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import ij.ImagePlus;
import imagescience.feature.Differentiator;
import imagescience.feature.Edges;
import imagescience.feature.Hessian;
import imagescience.feature.Laplacian;
import imagescience.feature.Structure;
import imagescience.image.Aspects;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import java.util.ArrayList;
import java.util.Vector;

public final class ImageScience {
    private ImageScience() {
    }

    public static boolean isAvailable() {
        Image.class.getName();
        return true;
    }

    public static ArrayList<ImagePlus> computeEigenimages(double sigma, double integrationScale, ImagePlus imp) {
        Image img = Image.wrap((ImagePlus)imp);
        Aspects aspects = img.aspects();
        FloatImage newimg = new FloatImage(img);
        Structure structure = new Structure();
        Vector eigenimages = structure.run((Image)newimg, sigma, integrationScale);
        int nrimgs = eigenimages.size();
        for (int i = 0; i < nrimgs; ++i) {
            ((Image)eigenimages.get(i)).aspects(aspects);
        }
        ArrayList<ImagePlus> result = new ArrayList<ImagePlus>(nrimgs);
        for (Image eigenimage : eigenimages) {
            result.add(eigenimage.imageplus());
        }
        return result;
    }

    public static ImagePlus computeDerivativeImage(double sigma, int xOrder, int yOrder, ImagePlus imp) {
        Image img = Image.wrap((ImagePlus)imp);
        Aspects aspects = img.aspects();
        FloatImage newimg = new FloatImage(img);
        Differentiator diff = new Differentiator();
        diff.run((Image)newimg, sigma, xOrder, yOrder, 0);
        newimg.aspects(aspects);
        return newimg.imageplus();
    }

    public static ImagePlus computeLaplacianImage(double sigma, ImagePlus imp) {
        Image img = Image.wrap((ImagePlus)imp);
        Aspects aspects = img.aspects();
        FloatImage newimg = new FloatImage(img);
        Laplacian laplace = new Laplacian();
        newimg = laplace.run((Image)newimg, sigma);
        newimg.aspects(aspects);
        return newimg.imageplus();
    }

    public static ImagePlus computeDifferentialImage(double sigma, int xOrder, int yOrder, int zOrder, ImagePlus imp) {
        Image img = Image.wrap((ImagePlus)imp);
        Aspects aspects = img.aspects();
        FloatImage newimg = new FloatImage(img);
        Differentiator diff = new Differentiator();
        diff.run((Image)newimg, sigma, xOrder, yOrder, zOrder);
        newimg.aspects(aspects);
        ImagePlus ip = newimg.imageplus();
        return ip;
    }

    public static ArrayList<ImagePlus> computeHessianImages(double sigma, boolean absolute, ImagePlus imp) {
        Image img = Image.wrap((ImagePlus)imp);
        Aspects aspects = img.aspects();
        FloatImage newimg = new FloatImage(img);
        Hessian hessian = new Hessian();
        Vector hessianImages = hessian.run((Image)newimg, sigma, absolute);
        int nrimgs = hessianImages.size();
        for (int i = 0; i < nrimgs; ++i) {
            ((Image)hessianImages.get(i)).aspects(aspects);
        }
        ArrayList<ImagePlus> result = new ArrayList<ImagePlus>(nrimgs);
        for (Image hessianImage : hessianImages) {
            result.add(hessianImage.imageplus());
        }
        return result;
    }

    public static ImagePlus computeEdgesImage(double sigma, ImagePlus imp) {
        Image img = Image.wrap((ImagePlus)imp);
        Aspects aspects = img.aspects();
        FloatImage newimg = new FloatImage(img);
        Edges edges = new Edges();
        newimg = edges.run((Image)newimg, sigma, false);
        newimg.aspects(aspects);
        return newimg.imageplus();
    }
}

