/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.LocalCorrelationFilter;
import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.dsp.SincInterpolator;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class LocalShiftFinder {
    private LocalCorrelationFilter _lcfSimple;
    private SincInterpolator _si;
    private boolean _interpolateDisplacements = true;

    public LocalShiftFinder(double sigma) {
        this(sigma, sigma, sigma);
    }

    public LocalShiftFinder(double sigma1, double sigma2) {
        this(sigma1, sigma2, sigma2);
    }

    public LocalShiftFinder(double sigma1, double sigma2, double sigma3) {
        Check.argument(sigma1 >= 1.0, "sigma1>=1.0");
        Check.argument(sigma2 >= 1.0, "sigma2>=1.0");
        Check.argument(sigma3 >= 1.0, "sigma3>=1.0");
        this._lcfSimple = new LocalCorrelationFilter(LocalCorrelationFilter.Type.SIMPLE, LocalCorrelationFilter.Window.GAUSSIAN, sigma1, sigma2, sigma3);
        this._si = new SincInterpolator();
        this._si.setExtrapolation(SincInterpolator.Extrapolation.CONSTANT);
    }

    public void setInterpolateDisplacements(boolean enable) {
        this._interpolateDisplacements = enable;
    }

    public void find1(int min1, int max1, float[] f, float[] g, float[] u) {
        this.findShifts(min1, max1, f, g, u, null, null);
    }

    public void find1(int min1, int max1, float[] f, float[] g, float[] u, float[] c, float[] d) {
        this.findShifts(min1, max1, f, g, u, c, d);
    }

    public void find1(int min1, int max1, float[][] f, float[][] g, float[][] u) {
        this.findShifts(1, min1, max1, f, g, u);
    }

    public void find2(int min2, int max2, float[][] f, float[][] g, float[][] u) {
        this.findShifts(2, min2, max2, f, g, u);
    }

    public void find1(int min1, int max1, float[][][] f, float[][][] g, float[][][] u) {
        this.findShifts(1, min1, max1, f, g, u);
    }

    public void find2(int min2, int max2, float[][][] f, float[][][] g, float[][][] u) {
        this.findShifts(2, min2, max2, f, g, u);
    }

    public void find3(int min3, int max3, float[][][] f, float[][][] g, float[][][] u) {
        this.findShifts(3, min3, max3, f, g, u);
    }

    public void shift1(float[] du, float[] u1, float[] h) {
        int n1 = h.length;
        float[] xu1 = new float[n1];
        float[] u1a = u1;
        float[] u1b = new float[n1];
        float[] ha = h;
        float[] hb = new float[n1];
        for (int i1 = 0; i1 < n1; ++i1) {
            xu1[i1] = (float)i1 + du[i1];
        }
        this._si.interpolate(n1, 1.0, 0.0, ha, n1, xu1, hb);
        ArrayMath.copy(hb, h);
        if (this._interpolateDisplacements) {
            this._si.interpolate(n1, 1.0, 0.0, u1a, n1, xu1, u1b);
            ArrayMath.copy(u1b, u1);
        }
    }

    public void shift1(float[][] du, float[][] u1, float[][] u2, float[][] h) {
        int n1 = h[0].length;
        int n2 = h.length;
        float[] xu1 = new float[n1];
        float[] u1b = new float[n1];
        float[] u2b = new float[n1];
        float[] hb = new float[n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int i1;
            float[] ha = h[i2];
            float[] u1a = u1[i2];
            float[] u2a = u2[i2];
            float[] du1 = du[i2];
            for (i1 = 0; i1 < n1; ++i1) {
                xu1[i1] = (float)i1 + du1[i1];
            }
            this._si.interpolate(n1, 1.0, 0.0, ha, n1, xu1, hb);
            if (this._interpolateDisplacements) {
                this._si.interpolate(n1, 1.0, 0.0, u1a, n1, xu1, u1b);
                this._si.interpolate(n1, 1.0, 0.0, u2a, n1, xu1, u2b);
            } else {
                ArrayMath.copy(u1a, u1b);
                ArrayMath.copy(u2a, u2b);
            }
            for (i1 = 0; i1 < n1; ++i1) {
                h[i2][i1] = hb[i1];
                u1[i2][i1] = u1b[i1] + du1[i1];
                u2[i2][i1] = u2b[i1];
            }
        }
    }

    public void shift2(float[][] du, float[][] u1, float[][] u2, float[][] h) {
        int n1 = h[0].length;
        int n2 = h.length;
        float[] du2 = new float[n2];
        float[] xu2 = new float[n2];
        float[] u1a = new float[n2];
        float[] u1b = new float[n2];
        float[] u2a = new float[n2];
        float[] u2b = new float[n2];
        float[] ha = new float[n2];
        float[] hb = new float[n2];
        for (int i1 = 0; i1 < n1; ++i1) {
            int i2;
            for (i2 = 0; i2 < n2; ++i2) {
                ha[i2] = h[i2][i1];
                u1a[i2] = u1[i2][i1];
                u2a[i2] = u2[i2][i1];
                du2[i2] = du[i2][i1];
                xu2[i2] = (float)i2 + du2[i2];
            }
            this._si.interpolate(n2, 1.0, 0.0, ha, n2, xu2, hb);
            if (this._interpolateDisplacements) {
                this._si.interpolate(n2, 1.0, 0.0, u1a, n2, xu2, u1b);
                this._si.interpolate(n2, 1.0, 0.0, u2a, n2, xu2, u2b);
            } else {
                ArrayMath.copy(u1a, u1b);
                ArrayMath.copy(u2a, u2b);
            }
            for (i2 = 0; i2 < n2; ++i2) {
                h[i2][i1] = hb[i2];
                u1[i2][i1] = u1b[i2];
                u2[i2][i1] = u2b[i2] + du2[i2];
            }
        }
    }

    public void shift1(float[][][] du, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] h) {
        int n1 = h[0][0].length;
        int n2 = h[0].length;
        int n3 = h.length;
        float[] xu1 = new float[n1];
        float[] u1b = new float[n1];
        float[] u2b = new float[n1];
        float[] u3b = new float[n1];
        float[] hb = new float[n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int i1;
                float[] ha = h[i3][i2];
                float[] u1a = u1[i3][i2];
                float[] u2a = u2[i3][i2];
                float[] u3a = u3[i3][i2];
                float[] du1 = du[i3][i2];
                for (i1 = 0; i1 < n1; ++i1) {
                    xu1[i1] = (float)i1 + du1[i1];
                }
                this._si.interpolate(n1, 1.0, 0.0, ha, n1, xu1, hb);
                if (this._interpolateDisplacements) {
                    this._si.interpolate(n1, 1.0, 0.0, u1a, n1, xu1, u1b);
                    this._si.interpolate(n1, 1.0, 0.0, u2a, n1, xu1, u2b);
                    this._si.interpolate(n1, 1.0, 0.0, u3a, n1, xu1, u3b);
                } else {
                    ArrayMath.copy(u1a, u1b);
                    ArrayMath.copy(u2a, u2b);
                    ArrayMath.copy(u3a, u3b);
                }
                for (i1 = 0; i1 < n1; ++i1) {
                    h[i3][i2][i1] = hb[i1];
                    u1[i3][i2][i1] = u1b[i1] + du1[i1];
                    u2[i3][i2][i1] = u2b[i1];
                    u3[i3][i2][i1] = u3b[i1];
                }
            }
        }
    }

    public void shift2(float[][][] du, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] h) {
        int n1 = h[0][0].length;
        int n2 = h[0].length;
        int n3 = h.length;
        float[] du2 = new float[n2];
        float[] xu2 = new float[n2];
        float[] u1a = new float[n2];
        float[] u1b = new float[n2];
        float[] u2a = new float[n2];
        float[] u2b = new float[n2];
        float[] u3a = new float[n2];
        float[] u3b = new float[n2];
        float[] ha = new float[n2];
        float[] hb = new float[n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i1 = 0; i1 < n1; ++i1) {
                int i2;
                for (i2 = 0; i2 < n2; ++i2) {
                    ha[i2] = h[i3][i2][i1];
                    u1a[i2] = u1[i3][i2][i1];
                    u2a[i2] = u2[i3][i2][i1];
                    u3a[i2] = u3[i3][i2][i1];
                    du2[i2] = du[i3][i2][i1];
                    xu2[i2] = (float)i2 + du2[i2];
                }
                this._si.interpolate(n2, 1.0, 0.0, ha, n2, xu2, hb);
                if (this._interpolateDisplacements) {
                    this._si.interpolate(n2, 1.0, 0.0, u1a, n2, xu2, u1b);
                    this._si.interpolate(n2, 1.0, 0.0, u2a, n2, xu2, u2b);
                    this._si.interpolate(n2, 1.0, 0.0, u3a, n2, xu2, u3b);
                } else {
                    ArrayMath.copy(u1a, u1b);
                    ArrayMath.copy(u2a, u2b);
                    ArrayMath.copy(u3a, u3b);
                }
                for (i2 = 0; i2 < n2; ++i2) {
                    h[i3][i2][i1] = hb[i2];
                    u1[i3][i2][i1] = u1b[i2];
                    u2[i3][i2][i1] = u2b[i2] + du2[i2];
                    u3[i3][i2][i1] = u3b[i2];
                }
            }
        }
    }

    public void shift3(float[][][] du, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] h) {
        int n1 = h[0][0].length;
        int n2 = h[0].length;
        int n3 = h.length;
        float[] du3 = new float[n3];
        float[] xu3 = new float[n3];
        float[] u1a = new float[n3];
        float[] u1b = new float[n3];
        float[] u2a = new float[n3];
        float[] u2b = new float[n3];
        float[] u3a = new float[n3];
        float[] u3b = new float[n3];
        float[] ha = new float[n3];
        float[] hb = new float[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                int i3;
                for (i3 = 0; i3 < n3; ++i3) {
                    ha[i3] = h[i3][i2][i1];
                    u1a[i3] = u1[i3][i2][i1];
                    u2a[i3] = u2[i3][i2][i1];
                    u3a[i3] = u3[i3][i2][i1];
                    du3[i3] = du[i3][i2][i1];
                    xu3[i3] = (float)i3 + du3[i3];
                }
                this._si.interpolate(n3, 1.0, 0.0, ha, n3, xu3, hb);
                if (this._interpolateDisplacements) {
                    this._si.interpolate(n3, 1.0, 0.0, u1a, n3, xu3, u1b);
                    this._si.interpolate(n3, 1.0, 0.0, u2a, n3, xu3, u2b);
                    this._si.interpolate(n3, 1.0, 0.0, u3a, n3, xu3, u3b);
                } else {
                    ArrayMath.copy(u1a, u1b);
                    ArrayMath.copy(u2a, u2b);
                    ArrayMath.copy(u3a, u3b);
                }
                for (i3 = 0; i3 < n3; ++i3) {
                    h[i3][i2][i1] = hb[i3];
                    u1[i3][i2][i1] = u1b[i3];
                    u2[i3][i2][i1] = u2b[i3];
                    u3[i3][i2][i1] = u3b[i3] + du3[i3];
                }
            }
        }
    }

    public void whiten(float[][] f, float[][] g) {
        this.whiten(1.0, f, g);
    }

    public void whiten(double sigma, float[][] f, float[][] g) {
        int i2;
        int n1 = f[0].length;
        int n2 = f.length;
        float[][] r00 = new float[n2][n1];
        float[][] rpm = new float[n2][n1];
        float[][] rm0 = new float[n2][n1];
        float[][] r0m = new float[n2][n1];
        this._lcfSimple.setInputs(f, f);
        this._lcfSimple.correlate(0, 0, r00);
        this._lcfSimple.correlate(1, -1, rpm);
        this._lcfSimple.correlate(-1, 0, rm0);
        this._lcfSimple.correlate(0, -1, r0m);
        float[][] s = rm0;
        float[][] t = r0m;
        for (i2 = 0; i2 < n2; ++i2) {
            s[i2][0] = 0.0f;
        }
        for (int i1 = 0; i1 < n1; ++i1) {
            s[0][i1] = 0.0f;
        }
        for (i2 = 1; i2 < n2; ++i2) {
            for (int i1 = 1; i1 < n1; ++i1) {
                double b1 = rm0[i2][i1];
                double b2 = r0m[i2][i1];
                double a11 = r00[i2][i1 - 1];
                double a21 = rpm[i2][i1 - 1];
                double a22 = r00[i2 - 1][i1];
                double l11 = ArrayMath.sqrt(a11);
                double l21 = a21 / l11;
                double d22 = a22 - l21 * l21;
                double x1 = 0.0;
                double x2 = 0.0;
                if (d22 > 0.0) {
                    double l22 = ArrayMath.sqrt(d22);
                    double v1 = b1 / l11;
                    double v2 = (b2 - l21 * v1) / l22;
                    x2 = v2 / l22;
                    x1 = (v1 - l21 * x2) / l11;
                }
                float a1 = (float)x1;
                float a2 = (float)x2;
                s[i2][i1] = f[i2][i1] - a1 * f[i2][i1 - 1] - a2 * f[i2 - 1][i1];
            }
        }
        if (sigma >= 1.0) {
            RecursiveGaussianFilter rgf = new RecursiveGaussianFilter(sigma);
            rgf.apply0X(s, t);
            rgf.applyX0(t, g);
        } else {
            ArrayMath.copy(s, g);
        }
    }

    public void whiten(float[][][] f, float[][][] g) {
        this.whiten(1.0, f, g);
    }

    public void whiten(double sigma, float[][][] f, float[][][] g) {
        int i1;
        int i2;
        int i3;
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        float[][][] r000 = new float[n3][n2][n1];
        float[][][] rpm0 = new float[n3][n2][n1];
        float[][][] rp0m = new float[n3][n2][n1];
        float[][][] r0pm = new float[n3][n2][n1];
        float[][][] rm00 = new float[n3][n2][n1];
        float[][][] r0m0 = new float[n3][n2][n1];
        float[][][] r00m = new float[n3][n2][n1];
        float[][][] s = rm00;
        float[][][] t = r0m0;
        this._lcfSimple.setInputs(f, f);
        this._lcfSimple.correlate(0, 0, 0, r000);
        this._lcfSimple.correlate(1, -1, 0, rpm0);
        this._lcfSimple.correlate(1, 0, -1, rp0m);
        this._lcfSimple.correlate(0, 1, -1, r0pm);
        this._lcfSimple.correlate(-1, 0, 0, rm00);
        this._lcfSimple.correlate(0, -1, 0, r0m0);
        this._lcfSimple.correlate(0, 0, -1, r00m);
        for (i3 = 0; i3 < n3; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                s[i3][i2][0] = 0.0f;
            }
        }
        for (i3 = 0; i3 < n3; ++i3) {
            for (i1 = 0; i1 < n1; ++i1) {
                s[i3][0][i1] = 0.0f;
            }
        }
        for (int i22 = 0; i22 < n2; ++i22) {
            for (i1 = 0; i1 < n1; ++i1) {
                s[0][i22][i1] = 0.0f;
            }
        }
        for (i3 = 1; i3 < n3; ++i3) {
            for (i2 = 1; i2 < n2; ++i2) {
                for (int i12 = 1; i12 < n1; ++i12) {
                    double l22;
                    double l32;
                    double d33;
                    double b1 = rm00[i3][i2][i12];
                    double b2 = r0m0[i3][i2][i12];
                    double b3 = r00m[i3][i2][i12];
                    double a11 = r000[i3][i2][i12 - 1];
                    double a21 = rpm0[i3][i2][i12 - 1];
                    double a22 = r000[i3][i2 - 1][i12];
                    double a31 = rp0m[i3][i2][i12 - 1];
                    double a32 = r0pm[i3][i2 - 1][i12];
                    double a33 = r000[i3 - 1][i2][i12];
                    double x1 = 0.0;
                    double x2 = 0.0;
                    double x3 = 0.0;
                    double l11 = ArrayMath.sqrt(a11);
                    double l21 = a21 / l11;
                    double l31 = a31 / l11;
                    double d22 = a22 - l21 * l21;
                    if (d22 > 0.0 && (d33 = a33 - l31 * l31 - (l32 = (a32 - l31 * l21) / (l22 = ArrayMath.sqrt(d22))) * l32) > 0.0) {
                        double l33 = ArrayMath.sqrt(d33);
                        double v1 = b1 / l11;
                        double v2 = (b2 - l21 * v1) / l22;
                        double v3 = (b3 - l31 * v1 - l32 * v2) / l33;
                        x3 = v3 / l33;
                        x2 = (v2 - l32 * x3) / l22;
                        x1 = (v1 - l21 * x2 - l31 * x3) / l11;
                    }
                    float a1 = (float)x1;
                    float a2 = (float)x2;
                    float a3 = (float)x3;
                    s[i3][i2][i12] = f[i3][i2][i12] - a1 * f[i3][i2][i12 - 1] - a2 * f[i3][i2 - 1][i12] - a3 * f[i3 - 1][i2][i12];
                }
            }
        }
        if (sigma >= 1.0) {
            RecursiveGaussianFilter rgf = new RecursiveGaussianFilter(sigma);
            rgf.apply0XX(s, t);
            rgf.applyX0X(t, s);
            rgf.applyXX0(s, g);
        } else {
            ArrayMath.copy(s, g);
        }
    }

    private void findShifts(int min, int max, float[] f, float[] g, float[] u, float[] c, float[] d) {
        int n1 = f.length;
        ArrayMath.zero(u);
        if (c != null) {
            ArrayMath.zero(c);
        } else {
            c = ArrayMath.zerofloat(n1);
        }
        if (d != null) {
            ArrayMath.zero(d);
        }
        float[][] c3 = new float[3][n1];
        LocalCorrelationFilter lcf = this._lcfSimple;
        lcf.setInputs(f, g);
        int lag1 = min;
        lcf.correlate(lag1, c3[1]);
        lcf.normalize(lag1, c3[1]);
        for (int lag = min; lag <= max; ++lag) {
            float[] cc;
            int i = lag - min;
            float[] ca = lag > min ? c3[i % 3] : c3[(i + 2) % 3];
            float[] cb = c3[(i + 1) % 3];
            float[] fArray = cc = lag < max ? c3[(i + 2) % 3] : c3[i % 3];
            if (lag < max) {
                lag1 = lag + 1;
                lcf.correlate(lag1, cc);
                lcf.normalize(lag1, cc);
            }
            for (int i1 = 0; i1 < n1; ++i1) {
                double c1;
                double c2;
                double up;
                double c0;
                double cp;
                float ai = ca[i1];
                float bi = cb[i1];
                float ci = cc[i1];
                if (!(bi >= ai) || !(bi >= ci) || !((cp = (c0 = (double)bi) + (up = (c2 = 0.5 * (double)(ci + ai) - (double)bi) < 0.0 ? -0.5 * c1 / c2 : 0.0) * ((c1 = 0.5 * (double)(ci - ai)) + up * c2)) > (double)c[i1])) continue;
                if (d != null) {
                    d[i1] = (float)cp - c[i1];
                }
                c[i1] = (float)cp;
                u[i1] = (float)((double)lag + up);
            }
        }
    }

    private void findShifts(int min, int max, float[] f, float[] g, float[] u) {
        int n1 = f.length;
        ArrayMath.zero(u);
        float[][] c = new float[3][n1];
        float[] cmax = new float[n1];
        LocalCorrelationFilter lcf = this._lcfSimple;
        lcf.setInputs(f, g);
        int lag1 = min;
        lcf.correlate(lag1, c[1]);
        lcf.normalize(lag1, c[1]);
        for (int lag = min; lag <= max; ++lag) {
            float[] cc;
            int i = lag - min;
            float[] ca = lag > min ? c[i % 3] : c[(i + 2) % 3];
            float[] cb = c[(i + 1) % 3];
            float[] fArray = cc = lag < max ? c[(i + 2) % 3] : c[i % 3];
            if (lag < max) {
                lag1 = lag + 1;
                lcf.correlate(lag1, cc);
                lcf.normalize(lag1, cc);
            }
            for (int i1 = 0; i1 < n1; ++i1) {
                double c1;
                double c2;
                double up;
                double c0;
                double cp;
                float ai = ca[i1];
                float bi = cb[i1];
                float ci = cc[i1];
                if (!(bi >= ai) || !(bi >= ci) || !((cp = (c0 = (double)bi) + (up = (c2 = 0.5 * (double)(ci + ai) - (double)bi) < 0.0 ? -0.5 * c1 / c2 : 0.0) * ((c1 = 0.5 * (double)(ci - ai)) + up * c2)) > (double)cmax[i1])) continue;
                cmax[i1] = (float)cp;
                u[i1] = (float)((double)lag + up);
            }
        }
    }

    private void findShifts(int dim, int min, int max, float[][] f, float[][] g, float[][] u) {
        int n1 = f[0].length;
        int n2 = f.length;
        ArrayMath.zero(u);
        float[][][] c = new float[3][n2][n1];
        float[][] cmax = new float[n2][n1];
        LocalCorrelationFilter lcf = this._lcfSimple;
        lcf.setInputs(f, g);
        int lag1 = dim == 1 ? min : 0;
        int lag2 = dim == 2 ? min : 0;
        lcf.correlate(lag1, lag2, c[1]);
        lcf.normalize(lag1, lag2, c[1]);
        for (int lag = min; lag <= max; ++lag) {
            float[][] cc;
            int i = lag - min;
            float[][] ca = lag > min ? c[i % 3] : c[(i + 2) % 3];
            float[][] cb = c[(i + 1) % 3];
            float[][] fArray = cc = lag < max ? c[(i + 2) % 3] : c[i % 3];
            if (lag < max) {
                lag1 = dim == 1 ? lag + 1 : 0;
                lag2 = dim == 2 ? lag + 1 : 0;
                lcf.correlate(lag1, lag2, cc);
                lcf.normalize(lag1, lag2, cc);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                float[] ca2 = ca[i2];
                float[] cb2 = cb[i2];
                float[] cc2 = cc[i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    double c1;
                    double c2;
                    double up;
                    double c0;
                    double cp;
                    float ai = ca2[i1];
                    float bi = cb2[i1];
                    float ci = cc2[i1];
                    if (!(bi >= ai) || !(bi >= ci) || !((cp = (c0 = (double)bi) + (up = (c2 = 0.5 * (double)(ci + ai) - (double)bi) < 0.0 ? -0.5 * c1 / c2 : 0.0) * ((c1 = 0.5 * (double)(ci - ai)) + up * c2)) > (double)cmax[i2][i1])) continue;
                    cmax[i2][i1] = (float)cp;
                    u[i2][i1] = (float)((double)lag + up);
                }
            }
        }
    }

    private void findShifts(int dim, int min, int max, float[][][] f, float[][][] g, float[][][] u) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        ArrayMath.zero(u);
        float[][][][] c = new float[3][n3][n2][n1];
        float[][][] cmax = new float[n3][n2][n1];
        LocalCorrelationFilter lcf = this._lcfSimple;
        lcf.setInputs(f, g);
        int lag1 = dim == 1 ? min : 0;
        int lag2 = dim == 2 ? min : 0;
        int lag3 = dim == 3 ? min : 0;
        lcf.correlate(lag1, lag2, lag3, c[1]);
        lcf.normalize(lag1, lag2, lag3, c[1]);
        for (int lag = min; lag <= max; ++lag) {
            float[][][] cc;
            int i = lag - min;
            float[][][] ca = lag > min ? c[i % 3] : c[(i + 2) % 3];
            float[][][] cb = c[(i + 1) % 3];
            float[][][] fArray = cc = lag < max ? c[(i + 2) % 3] : c[i % 3];
            if (lag < max) {
                lag1 = dim == 1 ? lag + 1 : 0;
                lag2 = dim == 2 ? lag + 1 : 0;
                lag3 = dim == 3 ? lag + 1 : 0;
                lcf.correlate(lag1, lag2, lag3, cc);
                lcf.normalize(lag1, lag2, lag3, cc);
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    float[] ca32 = ca[i3][i2];
                    float[] cb32 = cb[i3][i2];
                    float[] cc32 = cc[i3][i2];
                    for (int i1 = 0; i1 < n1; ++i1) {
                        double c1;
                        double c2;
                        double up;
                        double c0;
                        double cp;
                        float ai = ca32[i1];
                        float bi = cb32[i1];
                        float ci = cc32[i1];
                        if (!(bi >= ai) || !(bi >= ci) || !((cp = (c0 = (double)bi) + (up = (c2 = 0.5 * (double)(ci + ai) - (double)bi) < 0.0 ? -0.5 * c1 / c2 : 0.0) * ((c1 = 0.5 * (double)(ci - ai)) + up * c2)) > (double)cmax[i3][i2][i1])) continue;
                        cmax[i3][i2][i1] = (float)cp;
                        u[i3][i2][i1] = (float)((double)lag + up);
                    }
                }
            }
        }
    }
}

