/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.LasserreVolume;
import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixQrd;
import edu.mines.jtk.mesh.Geometry;
import edu.mines.jtk.mesh.TriMesh;
import edu.mines.jtk.util.Check;
import java.util.ArrayList;

public class SibsonInterpolator2 {
    private TriMesh _mesh;
    private TriMesh.Node[] _nodes;
    private TriMesh.NodeList _nodeList;
    private TriMesh.TriList _triList;
    private AreaAccumulator _va;
    private boolean _haveGradients;
    private double _gradientPower;
    private float _fnull;
    private float _x1min;
    private float _x1max;
    private float _x2min;
    private float _x2max;
    private float _x1bmn;
    private float _x1bmx;
    private float _x2bmn;
    private float _x2bmx;
    private boolean _useBoundingBox;

    public SibsonInterpolator2(float[] x1, float[] x2) {
        this(Method.HALE_LIANG, null, x1, x2);
    }

    public SibsonInterpolator2(float[] f, float[] x1, float[] x2) {
        this(Method.HALE_LIANG, f, x1, x2);
    }

    public SibsonInterpolator2(Method method, float[] x1, float[] x2) {
        this(method, null, x1, x2);
    }

    public SibsonInterpolator2(Method method, float[] f, float[] x1, float[] x2) {
        this.makeMesh(f, x1, x2);
        this._nodeList = new TriMesh.NodeList();
        this._triList = new TriMesh.TriList();
        if (method == Method.WATSON_SAMBRIDGE) {
            this._va = new WatsonSambridge();
        } else if (method == Method.BRAUN_SAMBRIDGE) {
            this._va = new BraunSambridge();
        } else if (method == Method.HALE_LIANG) {
            this._va = new HaleLiang();
        }
    }

    public void setSamples(float[] f, float[] x1, float[] x2) {
        this.makeMesh(f, x1, x2);
        this._haveGradients = false;
        if (this._gradientPower > 0.0) {
            this.estimateGradients();
        }
    }

    public void setNullValue(float fnull) {
        this._fnull = fnull;
    }

    public void setGradients(float[] g1, float[] g2) {
        int n = g1.length;
        for (int i = 0; i < n; ++i) {
            TriMesh.Node node = this._nodes[i];
            NodeData data = SibsonInterpolator2.data(node);
            data.gx = g1[i];
            data.gy = g2[i];
        }
        this._haveGradients = true;
        if (this._gradientPower == 0.0) {
            this._gradientPower = 1.0;
        }
    }

    public void setGradientPower(double gradientPower) {
        if (!this._haveGradients && gradientPower > 0.0) {
            this.estimateGradients();
        }
        this._gradientPower = gradientPower;
    }

    public void setBounds(float x1min, float x1max, float x2min, float x2max) {
        Check.argument(x1min < x1max, "x1min<x1max");
        Check.argument(x2min < x2max, "x2min<x2max");
        this._x1bmn = x1min;
        this._x1bmx = x1max;
        this._x2bmn = x2min;
        this._x2bmx = x2max;
        this._useBoundingBox = true;
        float scale = 1.0f;
        float x1avg = 0.5f * (x1min + x1max);
        float x2avg = 0.5f * (x2min + x2max);
        float x1dif = Math.max(x1max - this._x1min, this._x1max - x1min);
        float x2dif = Math.max(x2max - this._x2min, this._x2max - x2min);
        float x1pad = scale * x1dif;
        float x2pad = scale * x2dif;
        float[] x1g = new float[]{x1min -= x1pad, x1max += x1pad, x1avg, x1avg};
        float[] x2g = new float[]{x2avg, x2avg, x2min -= x2pad, x2max += x2pad};
        this.addGhostNodes(x1g, x2g);
    }

    public void setBounds(Sampling s1, Sampling s2) {
        this.setBounds((float)s1.getFirst(), (float)s1.getLast(), (float)s2.getFirst(), (float)s2.getLast());
    }

    public void useConvexHullBounds() {
        this._useBoundingBox = false;
        this.removeGhostNodes();
    }

    public float interpolate(float x1, float x2) {
        if (!this.inBounds(x1, x2)) {
            return this._fnull;
        }
        double asum = this.computeAreas(x1, x2);
        if (asum <= 0.0) {
            return this._fnull;
        }
        if (this.usingGradients()) {
            return this.interpolate1(asum, x1, x2);
        }
        return this.interpolate0(asum);
    }

    public float[][] interpolate(Sampling s1, Sampling s2) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        float[][] f = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2 = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = (float)s1.getValue(i1);
                f[i2][i1] = this.interpolate(x1, x2);
            }
        }
        return f;
    }

    public IndexWeight[] getIndexWeights(float x1, float x2) {
        if (!this.inBounds(x1, x2)) {
            return null;
        }
        float wsum = (float)this.computeAreas(x1, x2);
        if (wsum == 0.0f) {
            return null;
        }
        float wscl = 1.0f / wsum;
        int nnode = this._nodeList.nnode();
        TriMesh.Node[] nodes = this._nodeList.nodes();
        IndexWeight[] iw = new IndexWeight[nnode];
        for (int inode = 0; inode < nnode; ++inode) {
            TriMesh.Node node = nodes[inode];
            int i = node.index;
            float w = (float)SibsonInterpolator2.area(node) * wscl;
            iw[inode] = new IndexWeight(i, w);
        }
        return iw;
    }

    public float validate(int i) {
        return this.validate(new int[]{i})[0];
    }

    public float[] validate(int[] i) {
        int iv;
        int nv = i.length;
        for (int iv2 = 0; iv2 < nv; ++iv2) {
            this._mesh.removeNode(this._nodes[i[iv2]]);
        }
        float[] fv = new float[nv];
        for (iv = 0; iv < nv; ++iv) {
            TriMesh.Node node = this._nodes[i[iv]];
            float xn = node.x();
            float yn = node.y();
            fv[iv] = this.interpolate(xn, yn);
        }
        for (iv = 0; iv < nv; ++iv) {
            this._mesh.addNode(this._nodes[i[iv]]);
        }
        return fv;
    }

    private static NodeData data(TriMesh.Node node) {
        return (NodeData)node.data;
    }

    private static float f(TriMesh.Node node) {
        return SibsonInterpolator2.data((TriMesh.Node)node).f;
    }

    private static float gx(TriMesh.Node node) {
        return SibsonInterpolator2.data((TriMesh.Node)node).gx;
    }

    private static float gy(TriMesh.Node node) {
        return SibsonInterpolator2.data((TriMesh.Node)node).gy;
    }

    private static double area(TriMesh.Node node) {
        return SibsonInterpolator2.data((TriMesh.Node)node).area;
    }

    private static boolean ghost(TriMesh.Node node) {
        return node.index < 0;
    }

    private void makeMesh(float[] f, float[] x1, float[] x2) {
        int i;
        int n = x1.length;
        this._x1min = x1[0];
        this._x1max = x1[0];
        this._x2min = x2[0];
        this._x2max = x2[0];
        for (i = 1; i < n; ++i) {
            if (x1[i] < this._x1min) {
                this._x1min = x1[i];
            }
            if (x1[i] > this._x1max) {
                this._x1max = x1[i];
            }
            if (x2[i] < this._x2min) {
                this._x2min = x2[i];
            }
            if (!(x2[i] > this._x2max)) continue;
            this._x2max = x2[i];
        }
        this._nodes = new TriMesh.Node[n];
        this._mesh = new TriMesh();
        for (i = 0; i < n; ++i) {
            float x1i = x1[i];
            float x2i = x2[i];
            if (x1i == this._x1min) {
                x1i -= Math.ulp(x1i);
            }
            if (x1i == this._x1max) {
                x1i += Math.ulp(x1i);
            }
            if (x2i == this._x2min) {
                x2i -= Math.ulp(x2i);
            }
            if (x2i == this._x2max) {
                x2i += Math.ulp(x2i);
            }
            TriMesh.Node node = new TriMesh.Node(x1i, x2i);
            boolean added = this._mesh.addNode(node);
            Check.argument(added, "each sample has unique coordinates");
            NodeData data = new NodeData();
            node.data = data;
            node.index = i;
            if (f != null) {
                data.f = f[i];
            }
            this._nodes[i] = node;
        }
    }

    private boolean usingGradients() {
        return this._haveGradients && this._gradientPower > 0.0;
    }

    private void addGhostNodes(float[] x, float[] y) {
        int ng = x.length;
        for (int ig = 0; ig < ng; ++ig) {
            float xg = x[ig];
            float yg = y[ig];
            TriMesh.PointLocation pl = this._mesh.locatePoint(xg, yg);
            if (!pl.isOutside()) continue;
            TriMesh.Node n = new TriMesh.Node(xg, yg);
            n.data = new NodeData();
            n.index = -1 - ig;
            this._mesh.addNode(n);
        }
    }

    private void addGhostNodesWithValues(float[] x, float[] y) {
        int ig;
        int ng = x.length;
        int nn = this._nodes.length;
        DMatrix[] a = new DMatrix[ng];
        DMatrix[] b = new DMatrix[ng];
        for (ig = 0; ig < ng; ++ig) {
            a[ig] = new DMatrix(nn, 3);
            b[ig] = new DMatrix(nn, 1);
        }
        for (int in = 0; in < nn; ++in) {
            TriMesh.Node n = this._nodes[in];
            double fn = SibsonInterpolator2.f(n);
            double xn = n.xp();
            double yn = n.yp();
            for (int ig2 = 0; ig2 < ng; ++ig2) {
                double xg = x[ig2];
                double yg = y[ig2];
                double dx = xn - xg;
                double dy = yn - yg;
                double wn = 1.0 / Math.sqrt(dx * dx + dy * dy);
                a[ig2].set(in, 0, wn);
                a[ig2].set(in, 1, wn * dx);
                a[ig2].set(in, 2, wn * dy);
                b[ig2].set(in, 0, wn * fn);
            }
        }
        for (ig = 0; ig < ng; ++ig) {
            float xg = x[ig];
            float yg = y[ig];
            TriMesh.PointLocation pl = this._mesh.locatePoint(xg, yg);
            if (!pl.isOutside()) continue;
            TriMesh.Node n = new TriMesh.Node(xg, yg);
            n.index = -1 - ig;
            this._mesh.addNode(n);
            NodeData data = new NodeData();
            n.data = data;
            DMatrixQrd qrd = new DMatrixQrd(a[ig]);
            if (qrd.isFullRank()) {
                DMatrix s = qrd.solve(b[ig]);
                data.f = (float)s.get(0, 0);
                data.gx = (float)s.get(1, 0);
                data.gy = (float)s.get(2, 0);
                continue;
            }
            TriMesh.Node m = this._mesh.findNodeNearest(xg, yg);
            data.f = SibsonInterpolator2.f(m);
            data.gx = 0.0f;
            data.gy = 0.0f;
        }
    }

    private void removeGhostNodes() {
        ArrayList<TriMesh.Node> gnodes = new ArrayList<TriMesh.Node>(4);
        TriMesh.NodeIterator ni = this._mesh.getNodes();
        while (ni.hasNext()) {
            TriMesh.Node n = ni.next();
            if (!SibsonInterpolator2.ghost(n)) continue;
            gnodes.add(n);
        }
        for (TriMesh.Node gnode : gnodes) {
            this._mesh.removeNode(gnode);
        }
    }

    private double computeAreas(float x, float y) {
        if (!this.getNaturalNabors(x, y)) {
            return 0.0;
        }
        return this._va.accumulateAreas(x, y, this._mesh, this._nodeList, this._triList);
    }

    private boolean inBounds(float x1, float x2) {
        return !this._useBoundingBox || this._x1bmn <= x1 && x1 <= this._x1bmx && this._x2bmn <= x2 && x2 <= this._x2bmx;
    }

    private boolean getNaturalNabors(float x, float y) {
        this._mesh.clearNodeMarks();
        this._mesh.clearTriMarks();
        this._nodeList.clear();
        this._triList.clear();
        TriMesh.PointLocation pl = this._mesh.locatePoint(x, y);
        if (pl.isOutside()) {
            return false;
        }
        this.addTri(x, y, pl.tri());
        return true;
    }

    private void addTri(double xp, double yp, TriMesh.Tri tri) {
        this._mesh.mark(tri);
        this._triList.add(tri);
        this.addNode(tri.nodeA());
        this.addNode(tri.nodeB());
        this.addNode(tri.nodeC());
        TriMesh.Tri ta = tri.triA();
        TriMesh.Tri tb = tri.triB();
        TriMesh.Tri tc = tri.triC();
        if (this.needTri(xp, yp, ta)) {
            this.addTri(xp, yp, ta);
        }
        if (this.needTri(xp, yp, tb)) {
            this.addTri(xp, yp, tb);
        }
        if (this.needTri(xp, yp, tc)) {
            this.addTri(xp, yp, tc);
        }
    }

    private void addNode(TriMesh.Node node) {
        if (this._mesh.isMarked(node)) {
            return;
        }
        this._mesh.mark(node);
        this._nodeList.add(node);
        NodeData data = SibsonInterpolator2.data(node);
        data.area = 0.0;
    }

    private boolean needTri(double xp, double yp, TriMesh.Tri tri) {
        double yc;
        double xc;
        double yb;
        double xb;
        double ya;
        if (tri == null || this._mesh.isMarked(tri)) {
            return false;
        }
        TriMesh.Node na = tri.nodeA();
        TriMesh.Node nb = tri.nodeB();
        TriMesh.Node nc = tri.nodeC();
        double xa = na.xp();
        return Geometry.inCircle(xa, ya = na.yp(), xb = nb.xp(), yb = nb.yp(), xc = nc.xp(), yc = nc.yp(), xp, yp) > 0.0;
    }

    private float interpolate0(double asum) {
        double afsum = 0.0;
        int nnode = this._nodeList.nnode();
        TriMesh.Node[] nodes = this._nodeList.nodes();
        for (int inode = 0; inode < nnode; ++inode) {
            TriMesh.Node node = nodes[inode];
            float f = SibsonInterpolator2.f(node);
            double a = SibsonInterpolator2.area(node);
            afsum += a * (double)f;
        }
        return (float)(afsum / asum);
    }

    private float interpolate1(double asum, double x, double y) {
        int nnode = this._nodeList.nnode();
        TriMesh.Node[] nodes = this._nodeList.nodes();
        double fs = 0.0;
        double es = 0.0;
        double wds = 0.0;
        double wdds = 0.0;
        double wods = 0.0;
        for (int inode = 0; inode < nnode; ++inode) {
            double yn;
            double dy;
            TriMesh.Node n = nodes[inode];
            double f = SibsonInterpolator2.f(n);
            double gx = SibsonInterpolator2.gx(n);
            double gy = SibsonInterpolator2.gy(n);
            double a = SibsonInterpolator2.area(n);
            double w = a / asum;
            double xn = n.xp();
            double dx = x - xn;
            double dd = dx * dx + (dy = y - (yn = n.yp())) * dy;
            if (dd == 0.0) {
                return (float)f;
            }
            double d = Math.pow(dd, 0.5 * this._gradientPower);
            double wd = w * d;
            double wod = w / d;
            double wdd = w * dd;
            es += wod * (f + gx * dx + gy * dy);
            fs += w * f;
            wds += wd;
            wdds += wdd;
            wods += wod;
        }
        double alpha = wds / wods;
        double beta = wdds;
        return (float)((alpha * fs + beta * (es /= wods)) / (alpha + beta));
    }

    private void estimateGradients() {
        int nnode = this._nodes.length;
        for (int inode = 0; inode < nnode; ++inode) {
            this.estimateGradient(this._nodes[inode]);
        }
        this._haveGradients = true;
    }

    private void estimateGradient(TriMesh.Node n) {
        NodeData data = SibsonInterpolator2.data(n);
        double fn = data.f;
        double xn = n.xp();
        double yn = n.yp();
        this._mesh.removeNode(n);
        double asum = this.computeAreas((float)xn, (float)yn);
        this._mesh.addNode(n);
        if (asum > 0.0) {
            int nm = this._nodeList.nnode();
            TriMesh.Node[] ms = this._nodeList.nodes();
            double hxx = 0.0;
            double hxy = 0.0;
            double hyy = 0.0;
            double px = 0.0;
            double py = 0.0;
            double nr = 0.0;
            for (int im = 0; im < nm; ++im) {
                TriMesh.Node m = ms[im];
                if (SibsonInterpolator2.ghost(m)) continue;
                double fm = SibsonInterpolator2.f(m);
                double wm = SibsonInterpolator2.area(m);
                double xm = m.xp();
                double ym = m.yp();
                double df = fn - fm;
                double dx = xn - xm;
                double dy = yn - ym;
                double ds = wm / (dx * dx + dy * dy);
                hxx += ds * dx * dx;
                hxy += ds * dx * dy;
                hyy += ds * dy * dy;
                px += ds * dx * df;
                py += ds * dy * df;
                nr += 1.0;
            }
            if (nr > 1.0) {
                double lxx = Math.sqrt(hxx);
                double lxy = hxy / lxx;
                double dyy = hyy - lxy * lxy;
                double lyy = Math.sqrt(dyy);
                double qx = px / lxx;
                double qy = (py - lxy * qx) / lyy;
                double gy = qy / lyy;
                double gx = (qx - lxy * gy) / lxx;
                data.gx = (float)gx;
                data.gy = (float)gy;
            }
        }
    }

    private static class HaleLiang
    extends AreaAccumulator {
        private EdgeList _edgeList = new EdgeList();
        private double[] _xy = new double[2];

        private HaleLiang() {
        }

        @Override
        public double accumulateAreas(double xp, double yp, TriMesh mesh, TriMesh.NodeList nodeList, TriMesh.TriList triList) {
            this.clear();
            this.processTris(xp, yp, mesh, triList);
            boolean ok = this.processEdges();
            return ok ? this.sum() : 0.0;
        }

        private void processTris(double xp, double yp, TriMesh mesh, TriMesh.TriList triList) {
            this._edgeList.clear();
            int ntri = triList.ntri();
            TriMesh.Tri[] tris = triList.tris();
            for (int itri = 0; itri < ntri; ++itri) {
                TriMesh.Tri tri = tris[itri];
                TriMesh.Tri ta = tri.triA();
                TriMesh.Tri tb = tri.triB();
                TriMesh.Tri tc = tri.triC();
                TriMesh.Node na = tri.nodeA();
                TriMesh.Node nb = tri.nodeB();
                TriMesh.Node nc = tri.nodeC();
                tri.centerCircle(this._xy);
                double xt = this._xy[0] - xp;
                double yt = this._xy[1] - yp;
                this.processTriNabor(xp, yp, xt, yt, mesh, ta, nb, nc);
                this.processTriNabor(xp, yp, xt, yt, mesh, tb, nc, na);
                this.processTriNabor(xp, yp, xt, yt, mesh, tc, na, nb);
            }
        }

        private void processTriNabor(double xp, double yp, double xt, double yt, TriMesh mesh, TriMesh.Tri ta, TriMesh.Node nb, TriMesh.Node nc) {
            boolean saveEdge = true;
            if (ta != null && mesh.isMarked(ta)) {
                ta.centerCircle(this._xy);
                double xa = this._xy[0] - xp;
                double ya = this._xy[1] - yp;
                double xy = xt * ya - xa * yt;
                this.accumulate(nc, xy);
                saveEdge = false;
            }
            if (saveEdge) {
                this.addEdge(xp, yp, xt, yt, nb, nc);
            }
        }

        private void addEdge(double xp, double yp, double xr, double yr, TriMesh.Node na, TriMesh.Node nb) {
            double xa = na.xp();
            double ya = na.yp();
            double xb = nb.xp();
            double yb = nb.yp();
            Geometry.centerCircle(xp, yp, xa, ya, xb, yb, this._xy);
            double xf = this._xy[0] - xp;
            double yf = this._xy[1] - yp;
            this._edgeList.add(na, nb, xf, yf, xr, yr);
        }

        private boolean edgeNaborsOk() {
            int nedge = this._edgeList.nedge();
            ArrayList<Edge> edges = this._edgeList.edges();
            for (int iedge = 0; iedge < nedge; ++iedge) {
                Edge edge = edges.get(iedge);
                if (edge.eb != null) continue;
                return false;
            }
            return true;
        }

        private boolean processEdges() {
            if (!this.edgeNaborsOk()) {
                return false;
            }
            int nedge = this._edgeList.nedge();
            ArrayList<Edge> edges = this._edgeList.edges();
            for (int iedge = 0; iedge < nedge; ++iedge) {
                this.processEdge(edges.get(iedge));
            }
            return true;
        }

        private void processEdge(Edge edge) {
            TriMesh.Node na = edge.na;
            TriMesh.Node nb = edge.nb;
            double x1 = edge.xf;
            double y1 = edge.yf;
            double x2 = edge.xr;
            double y2 = edge.yr;
            double xy = x1 * y2 - x2 * y1;
            this.accumulate(na, xy);
            this.accumulate(nb, -xy);
            Edge eb = edge.eb;
            x2 = eb.xf;
            y2 = eb.yf;
            xy = x1 * y2 - x2 * y1;
            this.accumulate(nb, xy);
        }

        private static class EdgeList {
            private int _nedge;
            private ArrayList<Edge> _edges = new ArrayList(12);

            private EdgeList() {
            }

            int nedge() {
                return this._nedge;
            }

            ArrayList<Edge> edges() {
                return this._edges;
            }

            void clear() {
                this._nedge = 0;
            }

            void add(TriMesh.Node na, TriMesh.Node nb, double xf, double yf, double xr, double yr) {
                if (this._nedge == this._edges.size()) {
                    this._edges.add(new Edge());
                }
                Edge edge = this._edges.get(this._nedge);
                Edge eb = null;
                int nfound = 0;
                for (int iedge = 0; iedge < this._nedge && nfound < 2; ++iedge) {
                    Edge ei = this._edges.get(iedge);
                    if (nb == ei.na) {
                        eb = ei;
                        ++nfound;
                    }
                    if (na != ei.nb) continue;
                    ei.eb = edge;
                    ++nfound;
                }
                edge.na = na;
                edge.nb = nb;
                edge.xf = xf;
                edge.yf = yf;
                edge.xr = xr;
                edge.yr = yr;
                edge.eb = eb;
                ++this._nedge;
            }
        }

        private static class Edge {
            TriMesh.Node na;
            TriMesh.Node nb;
            double xf;
            double yf;
            double xr;
            double yr;
            Edge eb;

            private Edge() {
            }
        }
    }

    private static class BraunSambridge
    extends AreaAccumulator {
        private LasserreVolume _lv = new LasserreVolume(2);

        private BraunSambridge() {
        }

        @Override
        public double accumulateAreas(double x1i, double x2i, TriMesh mesh, TriMesh.NodeList nodeList, TriMesh.TriList triList) {
            this.clear();
            int nnode = nodeList.nnode();
            TriMesh.Node[] nodes = nodeList.nodes();
            for (int j = 0; j < nnode; ++j) {
                TriMesh.Node jnode = nodes[j];
                double x1j = jnode.xp();
                double x2j = jnode.yp();
                this._lv.clear();
                double x1s = 0.5 * (x1j + x1i);
                double x2s = 0.5 * (x2j + x2i);
                double x1d = x1j - x1i;
                double x2d = x2j - x2i;
                this._lv.addHalfSpace(x1d, x2d, 0.0);
                for (int k = 0; k < nnode; ++k) {
                    TriMesh.Node knode;
                    if (j == k || mesh.findTri(jnode, knode = nodes[k]) == null) continue;
                    double x1k = knode.xp();
                    double x2k = knode.yp();
                    double x1e = x1k - x1j;
                    double x2e = x2k - x2j;
                    double x1t = 0.5 * (x1k + x1j) - x1s;
                    double x2t = 0.5 * (x2k + x2j) - x2s;
                    this._lv.addHalfSpace(x1e, x2e, x1e * x1t + x2e * x2t);
                }
                double aj = this._lv.getVolume();
                this.accumulate(jnode, aj);
            }
            return this.sum();
        }
    }

    private static class WatsonSambridge
    extends AreaAccumulator {
        private double[] _ca = new double[2];
        private double[] _cb = new double[2];
        private double[] _cc = new double[2];
        private double[] _ct = new double[2];

        private WatsonSambridge() {
        }

        @Override
        public double accumulateAreas(double xp, double yp, TriMesh mesh, TriMesh.NodeList nodeList, TriMesh.TriList triList) {
            this.clear();
            int ntri = triList.ntri();
            TriMesh.Tri[] tris = triList.tris();
            for (int itri = 0; itri < ntri; ++itri) {
                TriMesh.Tri tri = tris[itri];
                TriMesh.Node na = tri.nodeA();
                TriMesh.Node nb = tri.nodeB();
                TriMesh.Node nc = tri.nodeC();
                double xa = na.xp();
                double ya = na.yp();
                double xb = nb.xp();
                double yb = nb.yp();
                double xc = nc.xp();
                double yc = nc.yp();
                Geometry.centerCircle(xp, yp, xb, yb, xc, yc, this._ca);
                Geometry.centerCircle(xp, yp, xc, yc, xa, ya, this._cb);
                Geometry.centerCircle(xp, yp, xa, ya, xb, yb, this._cc);
                Geometry.centerCircle(xa, ya, xb, yb, xc, yc, this._ct);
                double aa = this.area(this._cb, this._cc, this._ct);
                double ab = this.area(this._cc, this._ca, this._ct);
                double ac = this.area(this._ca, this._cb, this._ct);
                this.accumulate(na, aa);
                this.accumulate(nb, ab);
                this.accumulate(nc, ac);
            }
            return this.sum();
        }

        private double area(double[] ci, double[] cj, double[] ct) {
            double xt = ct[0];
            double yt = ct[1];
            double xi = ci[0] - xt;
            double yi = ci[1] - yt;
            double xj = cj[0] - xt;
            double yj = cj[1] - yt;
            return xi * yj - xj * yi;
        }
    }

    private static abstract class AreaAccumulator {
        private double _sum;

        private AreaAccumulator() {
        }

        public abstract double accumulateAreas(double var1, double var3, TriMesh var5, TriMesh.NodeList var6, TriMesh.TriList var7);

        protected void clear() {
            this._sum = 0.0;
        }

        protected double sum() {
            return this._sum;
        }

        protected void accumulate(TriMesh.Node node, double area) {
            if (SibsonInterpolator2.ghost(node)) {
                return;
            }
            NodeData data = SibsonInterpolator2.data(node);
            data.area += area;
            this._sum += area;
        }
    }

    private static class NodeData {
        float f;
        float gx;
        float gy;
        double area;

        private NodeData() {
        }
    }

    public static class IndexWeight {
        public int index;
        public float weight;

        IndexWeight(int index, float weight) {
            this.index = index;
            this.weight = weight;
        }
    }

    public static enum Method {
        HALE_LIANG,
        BRAUN_SAMBRIDGE,
        WATSON_SAMBRIDGE;

    }
}

