/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.TrilinearInterpolator3;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TrilinearInterpolator3Test
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(TrilinearInterpolator3Test.class);
        TestRunner.run((Test)suite);
    }

    public void testSingleValues() {
        float[][][][] xy = TrilinearInterpolator3Test.sampleTestFunction(11, 12, 13);
        float[] x1 = xy[0][0][0];
        float[] x2 = xy[0][0][1];
        float[] x3 = xy[0][0][2];
        float[][][] y = xy[1];
        float x1min = ArrayMath.min(x1);
        float x1max = ArrayMath.max(x1);
        float x1del = x1max - x1min;
        float x2min = ArrayMath.min(x2);
        float x2max = ArrayMath.max(x2);
        float x2del = x2max - x2min;
        float x3min = ArrayMath.min(x3);
        float x3max = ArrayMath.max(x3);
        float x3del = x3max - x3min;
        x1min -= 0.2f * x1del;
        x1max += 0.2f * x1del;
        x2min -= 0.2f * x2del;
        x2max += 0.2f * x2del;
        x3min -= 0.3f * x3del;
        x3max += 0.3f * x3del;
        TrilinearInterpolator3 ti = TrilinearInterpolator3Test.makeInterpolator(x1, x2, x3, y);
        int n = 100;
        Random r = new Random(5L);
        for (int i = 0; i < n; ++i) {
            float x1i = x1min + (x1max - x1min) * r.nextFloat();
            float x2i = x2min + (x2max - x2min) * r.nextFloat();
            float x3i = x3min + (x3max - x3min) * r.nextFloat();
            float y000 = ti.interpolate000(x1i, x2i, x3i);
            float y100 = ti.interpolate100(x1i, x2i, x3i);
            float y010 = ti.interpolate010(x1i, x2i, x3i);
            float y001 = ti.interpolate001(x1i, x2i, x3i);
            float z000 = TrilinearInterpolator3Test.testFunction000(x1i, x2i, x3i);
            float z100 = TrilinearInterpolator3Test.testFunction100(x1i, x2i, x3i);
            float z010 = TrilinearInterpolator3Test.testFunction010(x1i, x2i, x3i);
            float z001 = TrilinearInterpolator3Test.testFunction001(x1i, x2i, x3i);
            TrilinearInterpolator3Test.assertEqual(z000, y000);
            TrilinearInterpolator3Test.assertEqual(z100, y100);
            TrilinearInterpolator3Test.assertEqual(z010, y010);
            TrilinearInterpolator3Test.assertEqual(z001, y001);
        }
    }

    public void testArrayValues() {
        float[][][][] xy = TrilinearInterpolator3Test.sampleTestFunction(11, 12, 13);
        float[] x1 = xy[0][0][0];
        float[] x2 = xy[0][0][1];
        float[] x3 = xy[0][0][2];
        float[][][] y = xy[1];
        float x1min = ArrayMath.min(x1);
        float x1max = ArrayMath.max(x1);
        float x2min = ArrayMath.min(x2);
        float x2max = ArrayMath.max(x2);
        float x3min = ArrayMath.min(x3);
        float x3max = ArrayMath.max(x3);
        TrilinearInterpolator3 ti = TrilinearInterpolator3Test.makeInterpolator(x1, x2, x3, y);
        int n1i = 51;
        int n2i = 52;
        int n3i = 53;
        float d1i = (x1max - x1min) / (float)(n1i - 1);
        float d2i = (x2max - x2min) / (float)(n2i - 1);
        float d3i = (x3max - x3min) / (float)(n3i - 1);
        float f1i = x1min;
        float f2i = x2min;
        float f3i = x3min;
        float[] x1i = ArrayMath.rampfloat(f1i, d1i, n1i);
        float[] x2i = ArrayMath.rampfloat(f2i, d2i, n2i);
        float[] x3i = ArrayMath.rampfloat(f3i, d3i, n3i);
        float[][][] yi = ti.interpolate(x1i, x2i, x3i);
        for (int i3i = 0; i3i < n3i; ++i3i) {
            for (int i2i = 0; i2i < n2i; ++i2i) {
                for (int i1i = 0; i1i < n1i; ++i1i) {
                    float zi = TrilinearInterpolator3Test.testFunction000(x1i[i1i], x2i[i2i], x3i[i3i]);
                    TrilinearInterpolator3Test.assertEqual(zi, yi[i3i][i2i][i1i]);
                }
            }
        }
    }

    public void testSampleValues() {
        float[][][][] xy = TrilinearInterpolator3Test.sampleTestFunction(11, 12, 13);
        float[] x1 = xy[0][0][0];
        float[] x2 = xy[0][0][1];
        float[] x3 = xy[0][0][2];
        float[][][] y = xy[1];
        float x1min = ArrayMath.min(x1);
        float x1max = ArrayMath.max(x1);
        float x2min = ArrayMath.min(x2);
        float x2max = ArrayMath.max(x2);
        float x3min = ArrayMath.min(x3);
        float x3max = ArrayMath.max(x3);
        TrilinearInterpolator3 ti = TrilinearInterpolator3Test.makeInterpolator(x1, x2, x3, y);
        int n1i = 51;
        int n2i = 52;
        int n3i = 53;
        float d1i = (x1max - x1min) / (float)(n1i - 1);
        float d2i = (x2max - x2min) / (float)(n2i - 1);
        float d3i = (x3max - x3min) / (float)(n3i - 1);
        float f1i = x1min;
        float f2i = x2min;
        float f3i = x3min;
        Sampling s1i = new Sampling(n1i, d1i, f1i);
        Sampling s2i = new Sampling(n2i, d2i, f2i);
        Sampling s3i = new Sampling(n3i, d3i, f3i);
        float[][][] yi = ti.interpolate(s1i, s2i, s3i);
        for (int i3i = 0; i3i < n3i; ++i3i) {
            float x3i = (float)s3i.getValue(i3i);
            for (int i2i = 0; i2i < n2i; ++i2i) {
                float x2i = (float)s2i.getValue(i2i);
                for (int i1i = 0; i1i < n1i; ++i1i) {
                    float x1i = (float)s1i.getValue(i1i);
                    float zi = TrilinearInterpolator3Test.testFunction000(x1i, x2i, x3i);
                    TrilinearInterpolator3Test.assertEqual(zi, yi[i3i][i2i][i1i]);
                }
            }
        }
    }

    private static TrilinearInterpolator3 makeInterpolator(float[] x1, float[] x2, float[] x3, float[][][] y) {
        return new TrilinearInterpolator3(x1, x2, x3, y);
    }

    private static float[][][][] sampleTestFunction(int n1, int n2, int n3) {
        Random r = new Random(3L);
        float[] x1 = ArrayMath.mul(2.0f, ArrayMath.randfloat(r, n1));
        float[] x2 = ArrayMath.mul(2.0f, ArrayMath.randfloat(r, n2));
        float[] x3 = ArrayMath.mul(2.0f, ArrayMath.randfloat(r, n3));
        ArrayMath.quickSort(x1);
        ArrayMath.quickSort(x2);
        ArrayMath.quickSort(x3);
        float[][][] y = new float[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i3][i2][i1] = TrilinearInterpolator3Test.testFunction000(x1[i1], x2[i2], x3[i3]);
                }
            }
        }
        return new float[][][][]{new float[][][]{new float[][]{x1, x2, x3}}, y};
    }

    private static float testFunction000(float x1, float x2, float x3) {
        return (1.1f + x1) * (1.2f + x2) * (1.3f + x3);
    }

    private static float testFunction100(float x1, float x2, float x3) {
        return (1.2f + x2) * (1.3f + x3);
    }

    private static float testFunction010(float x1, float x2, float x3) {
        return (1.1f + x1) * (1.3f + x3);
    }

    private static float testFunction001(float x1, float x2, float x3) {
        return (1.1f + x1) * (1.2f + x2);
    }

    private static void assertEqual(float x, float y) {
        TrilinearInterpolator3Test.assertTrue((String)(x + " = " + y), (boolean)TrilinearInterpolator3Test.almostEqual(x, y));
    }

    private static boolean almostEqual(float x, float y) {
        float ax = ArrayMath.abs(x);
        float ay = ArrayMath.abs(y);
        return ArrayMath.abs(x - y) <= 0.001f * ArrayMath.max(ax, ay);
    }
}

