/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.TileZoomMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.EnumSet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MosaicTest {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MosaicTest.go();
            }
        });
    }

    private static void go() {
        int nrow = 2;
        int ncol = 3;
        EnumSet<Mosaic.AxesPlacement> axesPlacement = EnumSet.of(Mosaic.AxesPlacement.TOP, Mosaic.AxesPlacement.LEFT, Mosaic.AxesPlacement.BOTTOM, Mosaic.AxesPlacement.RIGHT);
        float[] x1 = new float[]{0.0f, 1.0f};
        float[] x2 = new float[]{0.0f, 1.0f};
        Mosaic mosaic = new Mosaic(nrow, ncol, axesPlacement);
        mosaic.setBackground(Color.WHITE);
        mosaic.setFont(new Font("SansSerif", 0, 12));
        mosaic.setWidthMinimum(1, 200);
        mosaic.setWidthElastic(1, 200);
        mosaic.setHeightElastic(0, 0);
        for (int irow = 0; irow < nrow; ++irow) {
            for (int icol = 0; icol < ncol; ++icol) {
                mosaic.getTile(irow, icol).addTiledView(new PointsView(x1, x2));
            }
        }
        mosaic.getTileAxisTop(0).setLabel("axis label");
        mosaic.getTileAxisTop(1).setLabel("axis label");
        mosaic.getTileAxisTop(2).setLabel("axis label");
        mosaic.getTileAxisLeft(0).setLabel("axis label");
        mosaic.getTileAxisLeft(1).setLabel("axis label");
        mosaic.getTileAxisBottom(0).setLabel("axis label");
        mosaic.getTileAxisBottom(1).setLabel("axis label");
        mosaic.getTileAxisBottom(2).setLabel("axis label");
        mosaic.getTileAxisRight(0).setLabel("axis label");
        mosaic.getTileAxisRight(1).setLabel("axis label");
        TileZoomMode zoomMode = new TileZoomMode(mosaic.getModeManager());
        zoomMode.setActive(true);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add((Component)mosaic, "Center");
        frame.setSize(600, 500);
        frame.setVisible(true);
    }
}

