/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.PlyReader;

class WrappingPlyReader
implements PlyReader {
    private final PlyReader reader;
    private final Map<String, WrapperFactory> unwrappedMap;
    private final Map<String, WrapperFactory> wrappedMap;
    private final List<ElementType> elementTypes;

    WrappingPlyReader(PlyReader reader, WrapperFactory ... wrappers) {
        this(reader, Arrays.asList(wrappers));
    }

    WrappingPlyReader(PlyReader reader, Iterable<WrapperFactory> wrappers) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        if (wrappers == null) {
            throw new NullPointerException("wrappers must not be null.");
        }
        this.reader = reader;
        HashMap<String, WrapperFactory> unwrappedMapTmp = new HashMap<String, WrapperFactory>();
        HashMap<String, WrapperFactory> wrappedMapTmp = new HashMap<String, WrapperFactory>();
        for (WrapperFactory wrapper : wrappers) {
            unwrappedMapTmp.put(wrapper.getUnwrappedType().getName(), wrapper);
            wrappedMapTmp.put(wrapper.getWrappedType().getName(), wrapper);
        }
        this.unwrappedMap = Collections.unmodifiableMap(unwrappedMapTmp);
        this.wrappedMap = Collections.unmodifiableMap(wrappedMapTmp);
        ArrayList<ElementType> types = new ArrayList<ElementType>();
        for (ElementType type : reader.getElementTypes()) {
            if (unwrappedMapTmp.containsKey(type.getName())) {
                types.add(((WrapperFactory)unwrappedMapTmp.get(type.getName())).getWrappedType());
                continue;
            }
            types.add(type);
        }
        this.elementTypes = Collections.unmodifiableList(types);
    }

    @Override
    public List<ElementType> getElementTypes() {
        return this.elementTypes;
    }

    @Override
    public int getElementCount(String elementType) {
        throw new UnsupportedOperationException("Wrappers might change the element count.");
    }

    @Override
    public ElementReader nextElementReader() throws IOException {
        ElementReader unwrapped = this.reader.nextElementReader();
        if (unwrapped == null) {
            return null;
        }
        WrapperFactory factory = this.unwrappedMap.get(unwrapped.getElementType().getName());
        if (factory != null) {
            return factory.wrap(unwrapped);
        }
        return unwrapped;
    }

    @Override
    public List<String> getRawHeaders() {
        return this.reader.getRawHeaders();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static abstract class WrapperFactory {
        private final ElementType unwrappedType;
        private final ElementType wrappedType;

        WrapperFactory(ElementType unwrappedType, ElementType wrappedType) {
            this.unwrappedType = unwrappedType;
            this.wrappedType = wrappedType;
        }

        public final ElementType getUnwrappedType() {
            return this.unwrappedType;
        }

        public final ElementType getWrappedType() {
            return this.wrappedType;
        }

        public abstract ElementReader wrap(ElementReader var1);
    }
}

