/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.ThreadedSaver;
import ij.IJ;
import ij.io.SaveDialog;
import java.io.FileWriter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ParticleSaver {
    public String filename;
    private FileWriter fw;
    private Lock wlock = new ReentrantLock();
    private Lock lock = new ReentrantLock();
    private int counter = 1;
    private ThreadedSaver tsaver;
    private String msg = "";

    public void setup() {
        String path = "";
        SaveDialog od = new SaveDialog("File to save particles into", "Particles Table", ".xls");
        path = od.getDirectory();
        this.filename = od.getFileName();
        this.filename = path + this.filename;
        try {
            this.fw = new FileWriter(this.filename);
            this.fw.write(" \tIntensity\tX (px)\tY (px)\tX (nm)\tY (nm)\tZ (nm)\tLeft-Width(px)\tRight-Width (px)\tUp-Height (px)\tDown-Height (px)\tX Symmetry (%)\tY Symmetry (%)\tWidth minus Height (px)\tFrame Number\n");
        }
        catch (Exception e) {
            IJ.error((String)("" + e));
        }
    }

    public void saveParticle(double s, double x, double y, double x_, double y_, double z_, double left, double right, double up, double down, double xsym, double ysym, double wmh, double frame) {
        if (this.fw == null) {
            return;
        }
        this.lock.lock();
        this.msg = this.msg + this.counter + "\t" + s + "\t" + x + "\t" + y + "\t" + x_ + "\t" + y_ + "\t" + z_ + "\t" + left + "\t" + right + "\t" + up + "\t" + down + "\t" + xsym + "\t" + ysym + "\t" + wmh + "\t" + frame + "\n";
        this.lock.unlock();
        if (this.counter % 1000 == 0) {
            this.lock.lock();
            this.tsaver = new ThreadedSaver();
            this.tsaver.mysetup(this.fw, this.wlock, this.msg);
            this.msg = "";
            this.tsaver.start();
            this.lock.unlock();
        }
        ++this.counter;
    }

    public void close() {
        if (this.fw == null) {
            return;
        }
        this.wlock.lock();
        try {
            this.fw.write(this.msg);
        }
        catch (Exception e) {
            IJ.error((String)("" + e));
        }
        this.msg = "";
        this.wlock.unlock();
        try {
            this.fw.close();
        }
        catch (Exception e) {
            IJ.error((String)("" + e));
        }
    }
}

